/* crap_font.c - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>

#include "crap_image.h"
#include "crap_png.h"
#include "crap_video.h"
#include "crap_font.h"
#include "crap_file.h"

Prop_font* _crap_font_text;
Prop_font* _crap_font_big;
Prop_font* _crap_font_penguin;
Palette _crap_font_palette;

void
crap_font_init ()
{
  Image image;
  Image subimage;

  crap_png_load ( &image, &_crap_font_palette, crap_file_find ( "font.png" ) );
  crap_setpalette ( &_crap_font_palette, 0, 256 );

/*    crap_image_subimage ( &image, &subimage, 0, 8, image.width, 23 ); */
/*    _crap_font_text = crap_pfont_load ( &subimage, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789!?.,'`-/#" ); */
  
  crap_image_subimage ( &image, &subimage, 0, 0, image.width, 20 );
  _crap_font_big = crap_pfont_load ( &subimage, "abcdefghijklmnopqrstuvwxyz-+;1234567890?P\"!@SWJ:TC)(.,/'*= " );
/*    crap_image_subimage ( &image, &subimage, 0, 9, image.width, 50 ); */
/*    _crap_font_penguin = crap_pfont_load ( &subimage, "abc" ); */
}

Palette*
crap_font_get_palette()
{
  return &_crap_font_palette;
}

Prop_font*
crap_get_penguin_font ()
{
  return _crap_font_penguin;
}

Prop_font*
crap_get_big_font ()
{
  return _crap_font_big;
}

Prop_font*
crap_get_text_font ()
{
  return _crap_font_text;
}


/* load a proportional font */
/* the font should have the lengths of the characters on the
   top row of the image */
Prop_font* crap_pfont_load ( Image* image, uint8* map_string )
{
  Prop_font* pfont;
  uint8 c;
  uint8 color;
  int pixel_offset = 1; /* first column is used as height indicator */
  int amount_chars = 0;
  int pixel_start;

  pfont = (Prop_font*) malloc ( sizeof(Prop_font) );
  pfont->image = crap_image_create ( image->width, image->height );

  memset ( pfont->char_width_map, 0, sizeof(int) * 256 );
  memset ( pfont->char_offset_map, 0, sizeof(int) * 256 );

  crap_image_copy ( pfont->image, image );

  pfont->char_height = 0;
  color = pfont->image->buffer [ pfont->image->width * pfont->char_height ];
  while ( pfont->image->buffer [ pfont->image->width * pfont->char_height ] == color )
    pfont->char_height++;

  /* work out the offset_map while setting up the char_map */
  while ( ( c = *map_string++ ) )
    {
      /* the offset is one line below pixel_offset */
      pfont->char_offset_map[ c ] = pixel_offset + pfont->image->width;

      pixel_start = pixel_offset;
      color = pfont->image->buffer[ pixel_offset ];
      while ( pfont->image->buffer[ pixel_offset ] == color )
	pixel_offset++;

      pfont->char_width_map[ c ] = pixel_offset - pixel_start;
      pixel_offset++;
      
      amount_chars ++;
    }

  return pfont;
}

Prop_font*
crap_blockfont_load ( Image* source_image, int block_count,     
		      int block_width, int block_height,
		      int horiz_blocks, int vert_blocks, 
		      int chars, int* block_encoding, 
		      uint8* map_string )  
{
  Prop_font* pfont;
  int i;
  int bx, by;
  int x, y;
  Image* block_images;
  int block_nr;
  uint8 c;
  
  pfont = (Prop_font*) malloc ( sizeof(Prop_font) );
  block_images = (Image*) malloc ( sizeof(Image) * block_count );

  /* create blocks */
  for ( i = 0; i < block_count; i++ )
    {
      crap_image_subimage ( source_image, &block_images[i],
			    (block_width+1) * i, 0, block_width, block_height );
    }
  
  /* this really ought to be an occasion to check for memory requirements ;-) */
  pfont->image = crap_image_create ( block_width * horiz_blocks * chars, block_height * vert_blocks );
  
  for ( i = 0; i < chars; i++ )
    {
      c = *map_string++;

      for ( by = 0; by < vert_blocks; by++ )
	for ( bx = 0; bx < horiz_blocks; bx++ )
	  {
	    block_nr = *block_encoding++;
	    x = i * block_width * horiz_blocks  +  bx * block_width;
	    y = by * block_height;
	    
	    crap_image_blit ( pfont->image, x, y, &block_images[block_nr] );
	  }
      pfont->char_offset_map[c] = i * block_width * horiz_blocks;
      pfont->char_width_map[c] = horiz_blocks * block_width;
    }

  pfont->char_height = vert_blocks * block_height;
  pfont->char_max_width = horiz_blocks * block_width;

  return pfont;
}

void crap_pfont_blit_character ( Prop_font* pfont, uint8* dest_buf, int dest_stride, uint8 character )
{
  int y;
  uint8* src_buf;
  int width;
  int src_stride;
  
  src_buf = &pfont->image->buffer[ pfont->char_offset_map[ character ] ];
    
  width = pfont->char_width_map[ character ];
  src_stride = pfont->image->width;

  for (y = 0; y < pfont->char_height; y++)
    {
      memcpy ( dest_buf, src_buf, width );
      src_buf += src_stride;
      dest_buf += dest_stride;
    }
}

void crap_pfont_string ( Prop_font* pfont, Image* image, int x, int y, uint8* string )
{
  uint8* dest_buffer;
  int stride = image->width;
  uint8 c;
  int char_width;

  if (( y < 0 ) || ( y > image->height - pfont->char_height ))
    return;

  dest_buffer = image->buffer + y*image->width;
  while ( (c = *string++) )
    {
      char_width = pfont->char_width_map [ c ] + 1;
      
      if (( x >= 0 ) && ( x <= image->width - char_width ))
	{
	  crap_pfont_blit_character ( pfont, dest_buffer + x, stride, c );
	}
      x += char_width;
    }
}

int
crap_pfont_string_width ( Prop_font* pfont, uint8* string )
{
  uint8 c;
  int width;

  width = 0;
  while ( (c = *string++) )
    {
      width += ( pfont->char_width_map [ c ] + 1 );
    }

  return width;
}

int
crap_pfont_get_height ( Prop_font* pfont )
{
  return pfont->char_height;
}

int
crap_pfont_get_max_width ( Prop_font* pfont )
{
  return pfont->char_max_width;
}

