#ifndef		__VOLUMETRIC_H_
#define		__VOLUMETRIC_H_

#include	"gemmath.h"
#include	"object3d.h"


typedef	struct _VOLUMEINFO
{
	gem_Vector*		chull;
	gem_Vector		emiterPos;
	WORD			vNbr;
} VOLUMEINFO, *LPVOLUMEINFO;

typedef struct _VOLUME
{
	LPD3DLVERTEX	volumeHull;
	LPD3DLVERTEX	volumeSpot;
	LPWORD			volumeHullInd;
	WORD			vNbrHull;
	WORD			iNbrHull;
	WORD			vNbrSpot;
	
} VOLUME, *LPVOLUME;

//prototypes
VOID DeleteVolume( LPVOLUME );
VOID CreateVolume( LPVOLUMEINFO,  LPVOLUME, FLOAT = 50.0f, DWORD = 0xFFFFFF );
VOID SetVolumeColor( LPVOLUME, DWORD );
VOID RenderVolume( LPVOLUME, LPDIRECTDRAWSURFACE7, LPDIRECT3DDEVICE7 );
DWORD CreateShiluette( LPOBJECT3D, LPD3DLVERTEX, LONG = 0, LONG = -1, DWORD = 0, DWORD = 0xffffffff );
VOID ExtrudeToVolume( LPOBJECT3D, LPVOLUME, WORD, WORD, FLOAT, gem_Vector& );
VOID AddToExtruded( LPOBJECT3D, LPVOLUME, WORD, WORD, FLOAT, gem_Vector& );
VOID RenderExtruded( LPVOLUME, LPDIRECT3DDEVICE7 );
VOID SetExtrudedColor( LPVOLUME, DWORD );

VOID CreateConectivityData( LPOBJECT3D, LPWORD );
DWORD CreateShadowVolume( LPOBJECT3D, LPOBJECT3D, LPWORD, gem_Vector, LPD3DVERTEX );

VOID RenderShadow( LPDIRECT3DDEVICE7 );
VOID RenderShadowVolume( WORD, LPD3DVERTEX, LPDIRECT3DDEVICE7 );

#endif
