//----------------------------------------------------------------------------------------------
// scene replay just simple title sequence coded by acid/z51 (jizz take a rest fella)
//----------------------------------------------------------------------------------------------
// this file is part of source code from intertia demo (c)zone51 `2000
//----------------------------------------------------------------------------------------------

#define  D3D_OVERLOADS
#include "directgem.h"
#include "enum.h"
#include "inertia3.h"
#include "texturemenager.h"
#include "extrastuff.h"

static	gem_Scene				scene;
DWORD	frame = 0;

static	D3DTLVERTEX				FadeV[4];
static	DWORD					Fade = 0;

static	D3DTLVERTEX				Noiz[4];
static	LPDIRECTDRAWSURFACE7	noize[4];

static	DWORD					banner = 0;
static	FLOAT					x, y, sizex, sizey;
static	DWORD					alpha;

static	DWORD					_3 = 0;
static	FLOAT					_3x, _3y, _3sizex, _3sizey;
static	DWORD					_3alpha;

static	DWORD					noizeNbr = 0;
static	FLOAT					noizeChange = 0.0f;


HRESULT fxInit_Inertia3( LPDIRECT3DDEVICE7 pd3dDevice )
{	
	LoadTexture( "data\\textures\\inertia.jpg", pd3dDevice );
	LoadTexture( "data\\textures\\3.jpg", pd3dDevice );

	LoadAlphaChannel( "data\\textures\\n1.bmp", &noize[0], pd3dDevice );
	LoadAlphaChannel( "data\\textures\\n2.bmp", &noize[1], pd3dDevice );
	LoadAlphaChannel( "data\\textures\\n3.bmp", &noize[2], pd3dDevice );
	LoadAlphaChannel( "data\\textures\\n4.bmp", &noize[3], pd3dDevice );

	D3DVECTOR vFar = D3DVECTOR( 0.0f, 0.0f, 0.5f );
    FadeV[0] = D3DTLVERTEX( vFar, 0.5f, 0xFFFFFFFF, 0, 0.01f, 0.99f );
    FadeV[1] = D3DTLVERTEX( vFar, 0.5f, 0xFFFFFFFF, 0, 0.01f, 0.01f );
    FadeV[2] = D3DTLVERTEX( vFar, 0.5f, 0xFFFFFFFF, 0, 0.99f, 0.99f );
    FadeV[3] = D3DTLVERTEX( vFar, 0.5f, 0xFFFFFFFF, 0, 0.99f, 0.01f );	

	D3DVIEWPORT7 vp;
    pd3dDevice->GetViewport(&vp);
    FadeV[0].sy = (FLOAT)vp.dwHeight;
    FadeV[2].sy = (FLOAT)vp.dwHeight;
    FadeV[2].sx = (FLOAT)vp.dwWidth;
    FadeV[3].sx = (FLOAT)vp.dwWidth;

	Noiz[0] = FadeV[0]; Noiz[0].dcColor = 0xff808080;
	Noiz[1] = FadeV[1]; Noiz[1].dcColor = 0xff808080;
	Noiz[2] = FadeV[2]; Noiz[2].dcColor = 0xff808080;
	Noiz[3] = FadeV[3]; Noiz[3].dcColor = 0xff808080;

	scene.SetViewport( 1.0f, 1e12, 1.0f );
	scene.Load( "data\\scenes\\i3.3ds" );
	scene.SetFlags( GEMFLAGS_SOFTWAREGEOMETRY );
	//scene.SetFlags( 0 );
	scene.Init( pd3dDevice );	
	
	scene.SetActiveCamera( "Camera01" );			

	return S_OK;
}


HRESULT fxFrameMove_Inertia3( LPDIRECT3DDEVICE7 pd3dDevice, LPSYNCINFO sync )
{
	//*******************************************************************
	D3DMATERIAL7 mtrl;
	ZeroMemory( &mtrl, sizeof(mtrl) );
    mtrl.ambient.r = 1.0f;
    mtrl.ambient.g = 1.0f;
    mtrl.ambient.b = 1.0f;
	mtrl.diffuse.r = 1.0f;
	mtrl.diffuse.g = 1.0f;
	mtrl.diffuse.b = 1.0f;
	mtrl.diffuse.a = 0.25f;    
	pd3dDevice->SetMaterial( &mtrl );
	
    pd3dDevice->SetRenderState( D3DRENDERSTATE_AMBIENT, 0x00808080 );
	//******************************************************************

	FLOAT			fTimeKey = sync->fTimeKey;
	FLOAT			frame = 700*fTimeKey/13.0f;	

	

	if( fTimeKey - noizeChange > 0.065f )
	{
		noizeNbr = (noizeNbr + 1)%4;
		noizeChange = fTimeKey;
	}

	if( frame>700 ) frame = 700;

	scene.Transform( frame );	

	gem_Camera*		cam = (gem_Camera*)scene.FindObject( "Camera01" );

	if( fTimeKey < 2.0f )
	{
		Fade = 1;

		DWORD alpha = (DWORD)( ( 2.0f - fTimeKey )*0.5f*255.0f );

		if( alpha > 255 ) 
			alpha = 255;

		alpha <<= 24;

		FadeV[0].dcColor = alpha | 0xffffff;
		FadeV[1].dcColor = alpha | 0xffffff;
		FadeV[2].dcColor = alpha | 0xffffff;
		FadeV[3].dcColor = alpha | 0xffffff;
	}
	else
		Fade = 0;

	if( fTimeKey > 13.0f )
	{
		mtrl.diffuse.a = 0.4f - (fTimeKey-13.0f)*0.2;		
		
		if( mtrl.diffuse.a<0 )
			mtrl.diffuse.a = 0;
	}

	if( fTimeKey > 12.0f )
	{
		banner = 1;

		x = 200 + ( fTimeKey - 12.0f )*20.0f;
		y = 150;
		sizex = 321;// + ( fTimeKey - 12.0f )*10.0f;
		sizey = 125;// + ( fTimeKey - 12.0f )*10.0f;

		alpha = (DWORD)( 255.0f*( fTimeKey - 12.0f )*0.5f );

		if( alpha > 255 )
			alpha = 255;
	}

	if( fTimeKey > 11.0f )
	{
		_3 = 1;

		_3x = 450;
		_3y = 120;
		_3sizex = 128 + ( fTimeKey - 11.0f )*10.0f;
		_3sizey = 128 + ( fTimeKey - 11.0f )*10.0f;

		_3alpha = (DWORD)( 255.0f*( fTimeKey - 11.0f )*0.5f );

		if( _3alpha > 255 )
			_3alpha = 255;
	}

	D3DLIGHT7			light;
	ZeroMemory( &light, sizeof(light) );
	light.dltType		= D3DLIGHT_POINT;
	light.dcvDiffuse.r	= 1.0f;
	light.dcvDiffuse.g	= 1.0f;
	light.dcvDiffuse.b	= 1.0f;
	light.dvPosition.x	= 0;	
	light.dvPosition.y	= 0;	
	light.dvPosition.z	= 0;
	light.dvAttenuation0= 1.0f;
	light.dvAttenuation1= 0.0f;
	light.dvAttenuation2= 0.0f;
	light.dvRange		= D3DLIGHT_RANGE_MAX;

	pd3dDevice->SetLight( 0, &light );
	pd3dDevice->LightEnable( 0, TRUE );

	pd3dDevice->SetMaterial( &mtrl );
		
	return S_OK;
}


HRESULT fxRender_Inertia3( LPDIRECT3DDEVICE7 pd3dDevice )
{
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_LINEAR );	
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_LINEAR );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_ANISOTROPIC );	
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_ANISOTROPIC );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MAXANISOTROPY, 2 );

	pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, TRUE );	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SHADEMODE, D3DSHADE_GOURAUD );	

	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND,  D3DBLEND_SRCALPHA );			
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE );			
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE, FALSE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_CULLMODE, D3DCULL_NONE );
	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, D3DZB_FALSE );

	pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET, 0x00000000, 1.0f, 0L );	

	pd3dDevice->SetTexture( 0, NULL );

	scene.Render();	

	pd3dDevice->BeginScene();

	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND,  D3DBLEND_SRCALPHA );			
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA );		
	pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );	
	DWORD		colorOp;
	pd3dDevice->GetTextureStageState( 0, D3DTSS_COLOROP, &colorOp );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG2 );	

	pd3dDevice->SetTexture( 0, noize[noizeNbr] );
	pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_TLVERTEX, Noiz, 4, 0 );				

	pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, colorOp );	

	pd3dDevice->SetTexture( 0, NULL );	

	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND,  D3DBLEND_SRCALPHA );			
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE );		

	if( Fade )
	{
		pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_TLVERTEX, FadeV, 4, 0 );				
	}
		

	if( banner )
	{
		RenderEfxFace( x, y, sizex, sizey, alpha, GetTexture( "data\\textures\\inertia.jpg" ), pd3dDevice );
	}

	if( _3 )
	{
		RenderEfxFace( _3x, _3y, _3sizex, _3sizey, _3alpha, GetTexture( "data\\textures\\3.jpg" ), pd3dDevice );
	}

	pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, TRUE );

	pd3dDevice->SetTexture( 0, NULL );

	pd3dDevice->EndScene();

	return S_OK;
}

#define SAFE_RELEASE( obj ) \
	 if( obj ) obj->Release()

VOID fxDelete_Inertia3( LPDIRECT3DDEVICE7 pd3dDevice )
{
	SAFE_RELEASE( noize[0] );
	SAFE_RELEASE( noize[1] );
	SAFE_RELEASE( noize[2] );
	SAFE_RELEASE( noize[4] );
}




