#include "texturemenager.h"

class gem_TextureContainer
{
public:

	LPDIRECTDRAWSURFACE7	texture;	
	TCHAR					name[80];

	gem_TextureContainer*	next;	

	~gem_TextureContainer()
	{
		if( next )
			delete next;

		if( texture )
			texture->Release();
	}
};


class gem_TextureMenager
{
public:

	gem_TextureContainer*		root;

	gem_TextureMenager() : root( NULL )
	{
	}

	~gem_TextureMenager()
	{
		if( root )
			delete root;
	}

	void AddTexture( gem_TextureContainer* text )
	{
		text->next = root;
		root = text;
	}

	gem_TextureContainer* FindTexture( TCHAR* name )
	{
		gem_TextureContainer*		tmp = root;  

		for( ; tmp && strcmp( name, tmp->name ) ; tmp = tmp->next );		

		return tmp;
	}
	
};

static gem_TextureMenager TextMen;

HRESULT LoadTexture( TCHAR* name, LPDIRECT3DDEVICE7 pd3dDevice, DWORD flags )
{
	gem_TextureContainer*		text = new gem_TextureContainer;

	if( GetTexture( name ) != NULL )
		return S_OK;

	if( FAILED( LoadTexture( name, &text->texture, pd3dDevice, flags, 0 ) ) )
		return E_FAIL;

	strcpy( text->name, name );

	TextMen.AddTexture( text );

	return S_OK;
}
		
LPDIRECTDRAWSURFACE7 GetTexture( TCHAR* name )
{
	gem_TextureContainer*		tmp = TextMen.FindTexture( name );
	
	if( !tmp )
		return NULL;

	return tmp->texture;
}

VOID RemoveTexture( TCHAR* name )
{
}