//----------------------------------------------------------------------------
//	file: light.cpp
//	desc: implementation of gem_Light methods
//----------------------------------------------------------------------------
#include "directgem.h"
#include "gemmath.h"
#include "enum.h"
#include "loader.h"

//simple constructor 
gem_Light::gem_Light( gem_Scene* scene ) : gem_Object( scene )
{
	fSize=15.0f;
}

//nothing to destruct so...
gem_Light::~gem_Light()
{	
}


//initialization of light, adding a light object to current device
VOID gem_Light::Init()
{
	D3DLIGHT7				light;
	LPDIRECT3DDEVICE7		lpd3dDevice = pScene->lpd3dDevice;

	fSize = pScene->fLitSize;

	dwIndex = pScene->dwLightNumber++;

	ZeroMemory( &light, sizeof(D3DLIGHT7) );

	light.dltType = D3DLIGHT_POINT;
	light.dcvDiffuse.r = 1.0f;
	light.dcvDiffuse.r = 1.0f;
	light.dcvDiffuse.r = 1.0f;
	light.dvPosition = D3DVECTOR( position.x, position.y, position.z );	      
	//light.dvRange = 100.0f;
	light.dvAttenuation0 = 1.0f;
	//light.dvAttenuation1 = 0.6f;
	//light.dvAttenuation2 = 0.9f;

	//lpd3dDevice->SetLight( dwIndex, &light );
	//lpd3dDevice->LightEnable( dwIndex, TRUE );
}

//render a light as a flare - can be disabled by setting appropiate flag in
//gem_Scene object
VOID gem_Light::Render()
{
	LPDIRECT3DDEVICE7		lpd3dDevice = pScene->lpd3dDevice;
	gem_Camera*				cam = pScene->currentCam;
	gem_Matrix				mtx = InvCameraMtx( cam->position, cam->target, cam->roll );

	DWORD					lightState;

	D3DVERTEX	vertex[4];

	D3DMATRIX	d3dmtx = (D3DMATRIX)(mtx*TranslationMtx( position ));	
	

	D3DVECTOR vNorm = D3DVECTOR( 0.0f, 0.0f, 1.0f );
    vertex[0] = D3DVERTEX( D3DVECTOR( -fSize, -fSize, 0.0f ), vNorm, 0.0f, 1.0f );
    vertex[1] = D3DVERTEX( D3DVECTOR( -fSize, +fSize, 0.0f ), vNorm, 0.0f, 0.0f );
    vertex[2] = D3DVERTEX( D3DVECTOR( +fSize, -fSize, 0.0f ), vNorm, 1.0f, 1.0f );
    vertex[3] = D3DVERTEX( D3DVECTOR( +fSize, +fSize, 0.0f ), vNorm, 1.0f, 0.0f );

	lpd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND, D3DBLEND_ONE);
    lpd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE );
	lpd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	lpd3dDevice->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE , FALSE );
	
	lpd3dDevice->SetTexture( 0, pScene->lpddsLightFlare );	
		
	lpd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &d3dmtx );	

	lpd3dDevice->GetRenderState( D3DRENDERSTATE_LIGHTING, &lightState );
	lpd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );
	
	lpd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_VERTEX, vertex, 4, NULL );		

	lpd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, lightState );

	lpd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE );
	lpd3dDevice->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE , TRUE );		

}

DWORD gem_Light::Type()
{
	return GEMOBJECTTYPE_LIGHT;
}

DWORD gem_Light::Load( FILE* inFile )
{
	LONG				size;
	LONG				pos;
	FLOAT		 		a, b, c;
	

	size = ReadDword( inFile ) - IDLENGTH;
	pos = ftell( inFile );

	a = ReadFloat( inFile );
	b = ReadFloat( inFile );
	c = ReadFloat( inFile );

	position.x = a;
	position.y = c;
	position.z = b;


	if( pos+size<ftell( inFile ) )
		if( ReadWord( inFile )==GEMCHUNK_SPOTLIGHT )
		{
			a = ReadFloat( inFile );
			b = ReadFloat( inFile );
			c = ReadFloat( inFile );

			ReadFloat( inFile );
			ReadFloat( inFile );
		}

	fseek( inFile, pos+size, SEEK_SET );

	if( feof( inFile ) )
		return GEMERROR_LOAD;

	return GEMERROR_OK;
}










