//--FILE-DESC-----------------------------------------------------------------
//	file: camera.cpp
//	desc: implementation of gem_Camera mathods
//----------------------------------------------------------------------------
#include "directgem.h"
#include "gemmath.h"
#include "enum.h"
#include "loader.h"



//--CONSTRUCTOR-DESC----------------------------------------------------------
//	gem_Camera constructor
//----------------------------------------------------------------------------
gem_Camera::gem_Camera( gem_Scene* scene ) : gem_Object( scene )
{
}


//--DESTRUCTOR-DESC-----------------------------------------------------------
//	class	: gem_Camera
//	desc	: nothing to destruct
//----------------------------------------------------------------------------
gem_Camera::~gem_Camera()
{
}

//--METHOD-DESC---------------------------------------------------------------
//	name	: Init()
//	class	: gem_Camera
//	param	: none
//	return	: void
//	desc:	: initilize camera viewport properties, properties for all cameras
//			  in scene can be changed by gem_Scene::SetViewport
//----------------------------------------------------------------------------	
VOID gem_Camera::Init()
{	
	aspect = pScene->aspect;
	farZ = pScene->farZ;
	nearZ = pScene->nearZ;	
}

//--METHOD-DESC---------------------------------------------------------------
//	name	: Render()
//	class	: gem_Camera
//	param	: none
//	return	: void
//	desc:	: nothing to render, just override a abstract virtual method from 
//			  gem_Object
//----------------------------------------------------------------------------	
VOID gem_Camera::Render()
{
}

//--METHOD-DESC---------------------------------------------------------------
//	name	: Type()
//	class	: gem_Camera
//	param	: none
//	return	: DWORD type of object
//	desc:	: can be used for identify object type (when you have a base class
//			  pointer)	
//----------------------------------------------------------------------------	
DWORD gem_Camera::Type()
{
	return GEMOBJECTTYPE_CAMERA;
}


//--METHOD-DESC---------------------------------------------------------------
//	name	: SetGeometry()
//	class	: gem_Camera
//	param	: lpd3dDevice, pointer to de Direct3D device where geometry should 
//			  be set (view & projection matrix)	
//	return	: void
//	desc:	: set view & projection matrix in device
//----------------------------------------------------------------------------	
VOID gem_Camera::SetGeometry( LPDIRECT3DDEVICE7 lpd3dDevice )
{	
	D3DMATRIX				mtx;
	gem_Matrix				mtxView;
	gem_Matrix				mtxProjection;


	mtx = GetD3DMATRIX( CameraMtx( position, target, roll ) );
	lpd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &mtx );

	mtx = GetD3DMATRIX( ProjectionMtx( fov, nearZ, farZ, aspect ) );
	lpd3dDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &mtx );
}

//--METHOD-DESC---------------------------------------------------------------
//	name	: load()
//	class	: gem_Camera
//	param	: inFile a open stream from where camera will be loaded
//	return	: DWORD error code
//	desc:	: try to load camera chunk from file inFile which should be a open
//			  stream for a .3ds file (look in documentation for details)	
//----------------------------------------------------------------------------	
DWORD gem_Camera::Load( FILE* inFile )
{
	LONG				size;
	LONG				pos;
	FLOAT				a, b, c;
	

	size = ReadDword( inFile ) - IDLENGTH;
	pos = ftell( inFile );

	a = ReadFloat( inFile );
	b = ReadFloat( inFile );
	c = ReadFloat( inFile );
			
	position.x = a;
	position.y = c;
	position.z = b;

	a = ReadFloat( inFile );
	b = ReadFloat( inFile );
	c = ReadFloat( inFile );	

	target.x = a;
	target.y = c;
	target.z = b;
	

	a = ReadFloat( inFile );
	roll = a;
	a = ReadFloat( inFile );
	fov = LensToFOV( a );
	
	fseek( inFile, pos+size, SEEK_SET );

	if( feof( inFile ) )
		return GEMERROR_LOAD;

	return GEMERROR_OK;
}



	
			