/*
 * Switchers
 *
 * Switching mechanisms, used to switch between static
 * variables (in the sense of their state time dependen-
 * cy) and dynamic variables (as defined in dynamic.h).
 */

#ifndef __OGL2_SWITCHERS__
#define __OGL2_SWITCHERS__

#include "dynamic.h"

extern "C++" {

template <class __dtype, class __type>
class DynamicSwitch {
  Dynamic<__dtype, __type> *dyn;
  __dtype st;
  bool static_active;
  bool strong_bind;
public:
  DynamicSwitch () : static_active(true), strong_bind(false) {}
  ~DynamicSwitch () {
    if(strong_bind) delete dyn;
  }
  __dtype Val (__type time = 0.0) {
    if(static_active) return st;
    return dyn->operator()(time);
  }
  void operator () (const __dtype& var) {
    if(strong_bind) {
      delete dyn;
      strong_bind = false;
    }
    static_active = true;
    st = var;
  }
  void operator () (Dynamic<__dtype, __type> *ptr, bool strong = false) {
    if(strong_bind) delete dyn;
    static_active = false;
    dyn = ptr;
    strong_bind = strong;
  }
};

} // extern "C++"

#endif
