/*
 * String class
 */

#ifndef __OGL2_STRING__
#define __OGL2_STRING__

#include <iostream>

extern "C++" {

class String {
  int len;
  mutable char* string;
public:
  String(const char* p = 0);
  String(const String& x);
  ~String();

  int length() const { return len; }
  const char* operator () () const { return string; }

  String& operator = (const char *);
  String& operator = (const String &);
  String& operator += (const char *);
  String& operator += (const String &);

};

ostream& operator << (ostream &, const String &);
bool operator == (const String &, const char *);
bool operator == (const String &, const String &);
String operator + (const String &, const String &);

} // extern "C++"

#endif
