/*

twirl

return:
  0 - doslo k chybe
  1 - este nezacal
  2 - prebehol v poriadku
  3 - uz skoncil
*/

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_17.h"
#include "syncs.h"

extern int sync_id;

int  efekt_17::init()
{
    cout << "Efekt 17 init ... ";
    start=TRUE;
    counter=ZACIATOK17*refresh;
//->init
    cntr=0;
    clr=1.0;
//<-
    cout << "ok" << endl;
    return 1;
}

int  efekt_17::load()
{
    cout << "Loading efekt17 ... ";
// -> load

    FILE *stream; 
    stream=fopen(CFGNAME17,"r");
    if (!stream) return 0;
    fscanf(stream,"texture              %s\n",tex_name);
    fscanf(stream,"mriezka              %i x %i\n",&tw_x,&tw_y);
    fscanf(stream,"otacaci bod          %i\n",&mode1);
    fscanf(stream,"stred otacania       %i\n",&mode2);
    fscanf(stream,"polomer              %f\n",&polomer);
    fscanf(stream,"otocenie             %f\n",&otocenie);
    fclose(stream);

  for (int x=0;x<tw_x;x++)
    for (int y=0;y<tw_y;y++)
      {
      tw.posx[x][y]=-1.0+x*(2.0/(tw_x-1));
      tw.posy[x][y]=-1.0+y*(2.0/(tw_y-1));

      tw.texx[x][y]=float(x)/(tw_x-1);
      tw.texy[x][y]=float(y)/(tw_y-1);
      }

   tex=texture_library->GetOrCreate(tex_name);

// <-
    cout << "ok!"<<endl;
    return 1;
}

int  efekt_17::free()  //vrati 3 ako ok, 0 ak doslo k chybe
{
    end=true;
    cout << "Efekt 17 free ... ";
// -> free

// <-
    cout << "ok!" << endl;
    return 3;
}

int  efekt_17::update()
{
    id=Sync[GetSyncNum(float(counter)/float(refresh))].id;
// -> update
    if (counter/refresh>157.0) 
      {
      if (clr>0.0) clr-=0.005;
              else clr=0.0;
      }
    if (counter/refresh>157.0) cntr+=2;
// <-
    return 1;
}

int efekt_17::go(double t)
{
if (t<ZACIATOK17) return 1;
if (end) return 3;
if (counter>=KONIEC17*refresh) return free();

if (!start) if (!init()) return 0;
int cur_frm=(int)(t*refresh);
if (cur_frm>KONIEC17*refresh) cur_frm=int(KONIEC17*refresh);
if (cur_frm>counter)
  while (counter<cur_frm)
    {
    counter++;
    if (counter<KONIEC17*refresh) update();
    }
if (counter>=KONIEC17*refresh) return free();

//tu sa kresli->

     glEnable(GL_TEXTURE_2D);

     glDisable(GL_LIGHTING);
     glDisable(GL_CULL_FACE);
     glDisable(GL_DEPTH_TEST);
     glDisable(GL_BLEND);

     glMatrixMode(GL_PROJECTION);
     glLoadIdentity();
     glMatrixMode(GL_MODELVIEW);
     glLoadIdentity();


   tex->GL();

tw.hmuch=otocenie*sin(cntr*PI/300);
tw.c1x=0.3*cos(cntr*PI/1000);
tw.c1y=0.3*sin(cntr*PI/1000);
tw.c2x=0.7*sin(cntr*PI/530);
tw.c2y=0.7*sin(cntr*PI/320);

for (int x=0;x<tw_x;x++)
  for (int y=0;y<tw_y;y++)
  {
  float r1=sqrt(  (tw.posx[x][y]-tw.c1x)*(tw.posx[x][y]-tw.c1x)  +  (tw.posy[x][y]-tw.c1y)*(tw.posy[x][y]-tw.c1y) );
  float r2=sqrt(  (tw.posx[x][y]-tw.c2x)*(tw.posx[x][y]-tw.c2x)  +  (tw.posy[x][y]-tw.c2y)*(tw.posy[x][y]-tw.c2y) );
  float r;
  switch(mode1)
    {
    case 0:      r=r1;        break;
    case 1:      r=r2;        break;
    case 2:      r=(r1+r2)/2; break;
    }
  if (r>polomer) r=polomer;
  float am= tw.hmuch*sin(r*2*PI/polomer);

  switch(mode2)
    {        
    case 0:
      tw.newx[x][y]= tw.c1x + cos(am)*(tw.posx[x][y]-tw.c1x)+sin(am)*(tw.posy[x][y]-tw.c1y);
      tw.newy[x][y]= tw.c1y + cos(am)*(tw.posy[x][y]-tw.c1y)-sin(am)*(tw.posx[x][y]-tw.c1x);
      break;
    case 1:
      tw.newx[x][y]= tw.c2x + cos(am)*(tw.posx[x][y]-tw.c2x)+sin(am)*(tw.posy[x][y]-tw.c2y);
      tw.newy[x][y]= tw.c2y + cos(am)*(tw.posy[x][y]-tw.c2y)-sin(am)*(tw.posx[x][y]-tw.c2x);
      break;
    case 2:
      tw.newx[x][y]= cos(am)*(tw.posx[x][y])+sin(am)*(tw.posy[x][y]);
      tw.newy[x][y]= cos(am)*(tw.posy[x][y])-sin(am)*(tw.posx[x][y]);
      break;
    }
  }


for (int y=1;y<tw_y;y++)
  {
  glBegin(GL_QUAD_STRIP);
  glColor3f( clr, clr, clr); 
 
  glTexCoord2f(    tw.texx[0][y  ],    tw.texy[0][y  ]);
  glVertex2f  (    tw.newx[0][y  ],    tw.newy[0][y  ]);
  glTexCoord2f(    tw.texx[0][y-1],    tw.texy[0][y-1]);
  glVertex2f  (    tw.newx[0][y-1],    tw.newy[0][y-1]);

  for (int x=1;x<tw_x;x++)
    {
    glTexCoord2f(    tw.texx[x][y  ],    tw.texy[x][y  ]);
    glVertex2f  (    tw.newx[x][y  ],    tw.newy[x][y  ]);
    glTexCoord2f(    tw.texx[x][y-1],    tw.texy[x][y-1]);
    glVertex2f  (    tw.newx[x][y-1],    tw.newy[x][y-1]); 
    }
  glEnd();
  }

//<-
return 2;
}