/*
 * Decompiled with CFR 0.152.
 */
package org.fuzzion.audio.player;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.fuzzion.audio.player.ModInstrument;

public class Mod {
    static final int voice_mk = Mod.FOURCC("M.K.");
    static final int voice_mk2 = Mod.FOURCC("M!K!");
    static final int voice_mk3 = Mod.FOURCC("M&K!");
    static final int voice_flt4 = Mod.FOURCC("FLT4");
    static final int voice_flt8 = Mod.FOURCC("FLT8");
    static final int voice_28ch = Mod.FOURCC("28CH");
    static final int voice_8chn = Mod.FOURCC("8CHN");
    static final int voice_6chn = Mod.FOURCC("6CHN");
    static final int[] voice_31_list = new int[]{voice_mk, voice_mk2, voice_mk3, voice_flt4, voice_flt8, voice_8chn, voice_6chn, voice_28ch};
    String name;
    int numtracks;
    int track_shift;
    int numpatterns;
    byte[][] patterns;
    ModInstrument[] insts;
    byte[] positions;
    int song_length_patterns;
    int song_repeat_patterns;
    boolean s3m;

    static final int FOURCC(String string) {
        return string.charAt(3) & 0xFF | (string.charAt(2) & 0xFF) << 8 | (string.charAt(1) & 0xFF) << 16 | (string.charAt(0) & 0xFF) << 24;
    }

    static final String readText(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        int n2 = n - 1;
        while (n2 >= 0) {
            if (byArray[n2] != 0) {
                return new String(byArray, 0, 0, n2 + 1);
            }
            --n2;
        }
        return "";
    }

    static final int readu8(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readByte() & 0xFF;
    }

    static final int readu16(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort() & 0xFFFF;
    }

    void readSequence(DataInputStream dataInputStream) throws IOException {
        this.positions = new byte[128];
        this.song_length_patterns = Mod.readu8(dataInputStream);
        this.song_repeat_patterns = Mod.readu8(dataInputStream);
        dataInputStream.readFully(this.positions, 0, 128);
        if (this.song_repeat_patterns > this.song_length_patterns) {
            this.song_repeat_patterns = this.song_length_patterns;
        }
        this.numpatterns = 0;
        int n = 0;
        while (n < this.positions.length) {
            if (this.positions[n] > this.numpatterns) {
                this.numpatterns = this.positions[n];
            }
            ++n;
        }
        ++this.numpatterns;
    }

    void readPatterns(DataInputStream dataInputStream) throws IOException {
        int n = this.numtracks * 4 * 64;
        this.patterns = new byte[this.numpatterns][];
        int n2 = 0;
        while (n2 < this.numpatterns) {
            this.patterns[n2] = new byte[n];
            dataInputStream.readFully(this.patterns[n2], 0, n);
            ++n2;
        }
    }

    static ModInstrument readInstrument(DataInputStream dataInputStream) throws IOException {
        ModInstrument modInstrument = new ModInstrument();
        modInstrument.name = Mod.readText(dataInputStream, 22);
        modInstrument.sample_length = Mod.readu16(dataInputStream) << 1;
        modInstrument.samples = new byte[modInstrument.sample_length + 8];
        modInstrument.finetune_value = (byte)(Mod.readu8(dataInputStream) << 4);
        modInstrument.volume = Mod.readu8(dataInputStream);
        modInstrument.repeat_point = Mod.readu16(dataInputStream) << 1;
        modInstrument.repeat_length = Mod.readu16(dataInputStream) << 1;
        if (modInstrument.repeat_point > modInstrument.sample_length) {
            modInstrument.repeat_point = modInstrument.sample_length;
        }
        if (modInstrument.repeat_point + modInstrument.repeat_length > modInstrument.sample_length) {
            modInstrument.repeat_length = modInstrument.sample_length - modInstrument.repeat_point;
        }
        return modInstrument;
    }

    static void readSampleData(DataInputStream dataInputStream, ModInstrument modInstrument) throws IOException {
        dataInputStream.readFully(modInstrument.samples, 0, modInstrument.sample_length);
        if (modInstrument.repeat_length > 3) {
            System.arraycopy(modInstrument.samples, modInstrument.repeat_point, modInstrument.samples, modInstrument.sample_length, 8);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getNumTracks() {
        return this.numtracks;
    }

    public int getNumPatterns() {
        return this.numpatterns;
    }

    public String toString() {
        return this.name + " (" + this.numtracks + " tracks, " + this.numpatterns + " patterns, " + this.insts.length + " samples)";
    }

    public Mod(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = 15;
        this.numtracks = 4;
        this.name = Mod.readText(dataInputStream, 20);
        dataInputStream.mark(1068);
        dataInputStream.skip(1060L);
        int n2 = dataInputStream.readInt();
        dataInputStream.reset();
        int n3 = 0;
        while (n3 < voice_31_list.length) {
            if (n2 == voice_31_list[n3]) {
                n = 31;
                break;
            }
            ++n3;
        }
        if (n == 31) {
            if (n2 == voice_8chn) {
                this.numtracks = 8;
            } else if (n2 == voice_6chn) {
                this.numtracks = 6;
            } else if (n2 == voice_28ch) {
                this.numtracks = 28;
            }
        }
        this.insts = new ModInstrument[n];
        n3 = 0;
        while (n3 < n) {
            this.insts[n3] = Mod.readInstrument(dataInputStream);
            ++n3;
        }
        this.readSequence(dataInputStream);
        dataInputStream.skipBytes(4);
        this.readPatterns(dataInputStream);
        try {
            n3 = 0;
            while (n3 < n) {
                Mod.readSampleData(dataInputStream, this.insts[n3]);
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Warning: EOF on MOD file");
        }
    }
}

