/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.fuzzion.audio.player.Mod;
import org.fuzzion.audio.player.ModPlayer;
import org.fuzzion.audio.player.ModPlayerState;

public abstract class TinyXANA
extends Applet
implements Runnable {
    Mod mod;
    ModPlayer plyr;
    String modfile;
    int buflen;
    int oversamp;
    int gain;
    boolean repeat;
    int pausetime = 60;
    long lastpausetime;
    boolean running;
    Image back1;
    Image back2;
    Image show_back;
    Image draw_back;
    int _width;
    int _height;
    Thread _thread;

    public abstract void Main(int var1, int var2);

    public ModPlayerState getModState() {
        return this.plyr.getState();
    }

    public void getModParams() {
        this.modfile = "music/reallycool.mod";
        String string = this.getParameter("BUFLEN");
        if (string != null) {
            this.buflen = Integer.parseInt(string);
        }
        if ((string = this.getParameter("OVERSAMPLE")) != null) {
            this.oversamp = Integer.parseInt(string);
        }
        this.repeat = true;
        string = this.getParameter("PAUSETIME");
        if (string != null) {
            this.pausetime = Integer.parseInt(string);
        }
    }

    public void loadMod() throws IOException {
        URL uRL = this.getClass().getResource(this.modfile);
        System.out.println(">>> " + uRL.toString());
        InputStream inputStream = uRL.openStream();
        this.mod = new Mod(new BufferedInputStream(inputStream));
    }

    public void init() {
        try {
            this.getModParams();
            if (this.modfile == null) {
                return;
            }
            this.loadMod();
            this.back1 = this.createImage(this.bounds().width, this.bounds().height);
            this.back2 = this.createImage(this.bounds().width, this.bounds().height);
            this.draw_back = this.back1;
            this.show_back = this.back2;
        }
        catch (IOException iOException) {
            System.out.println("Could not load .mod file");
        }
    }

    public void swapBuffers() {
        Image image = this.show_back;
        this.show_back = this.draw_back;
        this.draw_back = image;
    }

    public Graphics getDrawGraphics() {
        return this.draw_back.getGraphics();
    }

    public void start() {
        if (this.plyr == null) {
            this.plyr = new ModPlayer(this.mod);
        }
        if (this.buflen > 0) {
            this.plyr.audiobuflen = this.buflen;
        }
        if (this.oversamp > 0) {
            this.plyr.oversample = this.oversamp;
        }
        if (this.gain > 0) {
            this.plyr.gain = this.gain;
        }
        this.plyr.loop = this.repeat;
        this.plyr.start();
        this.running = true;
        if (this._thread == null) {
            this._thread = new Thread(this);
            this._thread.start();
        }
    }

    public void run() {
        Dimension dimension = this.size();
        this._width = dimension.width;
        this._height = dimension.height;
        this.Main(this._width, this._height);
    }

    public void stop() {
        this.plyr.stop();
        this.running = false;
        if (this._thread != null && this._thread.isAlive()) {
            this._thread.stop();
        }
        this._thread = null;
    }

    public synchronized void paint() {
        Graphics graphics = this.getGraphics();
        graphics.drawImage(this.show_back, 0, 0, this._width, this._height, null);
    }
}

