/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class Object3D {
    int v_num;
    int f_num;
    int c_num;
    int m_num;
    float x_pos;
    float y_pos;
    float z_pos;
    float x_rot;
    float y_rot;
    float z_rot;
    Affine trans;
    float[] v_list;
    float[] v_t_list;
    float[] v_n_list;
    float[] v_nt_list;
    short[] c_list;
    float[] map_list;
    Face3D[] f_list;

    void calc_implicit(int n) {
        double d = this.v_list[3 * this.f_list[n].v2] - this.v_list[3 * this.f_list[n].v1];
        double d2 = this.v_list[3 * this.f_list[n].v2 + 1] - this.v_list[3 * this.f_list[n].v1 + 1];
        double d3 = this.v_list[3 * this.f_list[n].v2 + 2] - this.v_list[3 * this.f_list[n].v1 + 2];
        double d4 = this.v_list[3 * this.f_list[n].v3] - this.v_list[3 * this.f_list[n].v1];
        double d5 = this.v_list[3 * this.f_list[n].v3 + 1] - this.v_list[3 * this.f_list[n].v1 + 1];
        double d6 = this.v_list[3 * this.f_list[n].v3 + 2] - this.v_list[3 * this.f_list[n].v1 + 2];
        double d7 = Math.sqrt(Math.pow(d2 * d6 - d3 * d5, 2.0) + Math.pow(d3 * d4 - d * d6, 2.0) + Math.pow(d * d5 - d2 * d4, 2.0));
        this.f_list[n].x = (float)((d2 * d6 - d3 * d5) / d7);
        this.f_list[n].y = (float)((d3 * d4 - d * d6) / d7);
        this.f_list[n].z = (float)((d * d5 - d2 * d4) / d7);
        this.f_list[n].d = -(this.f_list[n].x * this.v_list[3 * this.f_list[n].v1] + this.f_list[n].y * this.v_list[3 * this.f_list[n].v1 + 1] + this.f_list[n].z * this.v_list[3 * this.f_list[n].v1 + 2]);
    }

    void to_camera(Camera camera) {
        Affine affine = new Affine();
        Affine affine2 = new Affine();
        affine = this.trans.post_mul(camera.trans.invert());
        affine2 = affine.invert();
        affine.trans_points(this.v_list, this.v_t_list, this.v_num);
        affine.trans_faces(this.f_list, this.f_num);
        int n = 0;
        while (n < this.f_num) {
            if (this.f_list[n].distance(affine2.xo, affine2.yo, affine2.zo) > 0.0f) {
                float f = Math.abs(this.f_list[n].tz);
                this.f_list[n].tr = (int)(this.f_list[n].r * f);
                this.f_list[n].tg = (int)(this.f_list[n].g * f);
                this.f_list[n].tb = (int)(this.f_list[n].b * f);
                this.f_list[n].vv1.x = this.v_t_list[this.f_list[n].v1 * 3];
                this.f_list[n].vv1.y = this.v_t_list[this.f_list[n].v1 * 3 + 1];
                this.f_list[n].vv1.z = this.v_t_list[this.f_list[n].v1 * 3 + 2];
                this.f_list[n].vv2.x = this.v_t_list[this.f_list[n].v2 * 3];
                this.f_list[n].vv2.y = this.v_t_list[this.f_list[n].v2 * 3 + 1];
                this.f_list[n].vv2.z = this.v_t_list[this.f_list[n].v2 * 3 + 2];
                this.f_list[n].vv3.x = this.v_t_list[this.f_list[n].v3 * 3];
                this.f_list[n].vv3.y = this.v_t_list[this.f_list[n].v3 * 3 + 1];
                this.f_list[n].vv3.z = this.v_t_list[this.f_list[n].v3 * 3 + 2];
                float f2 = this.v_t_list[this.f_list[n].v1 * 3 + 2] + this.v_t_list[this.f_list[n].v2 * 3 + 2] + this.v_t_list[this.f_list[n].v3 * 3 + 2];
                camera.buf_append(this.f_list[n], f2);
            }
            ++n;
        }
    }

    Object3D(InputStream inputStream, float f, float f2, float f3, boolean bl, boolean bl2) {
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.v_num = dataInputStream.readInt();
            this.f_num = dataInputStream.readInt();
            this.z_pos = 0.0f;
            this.y_pos = 0.0f;
            this.x_pos = 0.0f;
            this.z_rot = 0.0f;
            this.y_rot = 0.0f;
            this.x_rot = 0.0f;
            this.trans = new Affine();
            this.v_list = new float[this.v_num * 3];
            this.v_t_list = new float[this.v_num * 3];
            this.v_n_list = new float[this.v_num * 3];
            this.v_nt_list = new float[this.v_num * 3];
            this.f_list = new Face3D[this.f_num];
            int n2 = 0;
            while (n2 < this.v_num) {
                this.v_list[3 * n2] = dataInputStream.readFloat();
                this.v_list[3 * n2 + 1] = dataInputStream.readFloat();
                this.v_list[3 * n2 + 2] = dataInputStream.readFloat();
                ++n2;
            }
            n2 = 0;
            while (n2 < this.f_num) {
                this.f_list[n2] = new Face3D();
                this.f_list[n2].v1 = dataInputStream.readShort();
                this.f_list[n2].v2 = dataInputStream.readShort();
                this.f_list[n2].v3 = dataInputStream.readShort();
                this.f_list[n2].vv1 = new Vertex3D();
                this.f_list[n2].vv2 = new Vertex3D();
                this.f_list[n2].vv3 = new Vertex3D();
                this.calc_implicit(n2);
                ++n2;
            }
            try {
                this.c_num = dataInputStream.readUnsignedByte();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.c_num <= 0) {
                n = 0;
                while (n < this.f_num) {
                    this.f_list[n].r = f;
                    this.f_list[n].g = f2;
                    this.f_list[n].b = f3;
                    ++n;
                }
            } else {
                this.c_list = new short[this.c_num * 3];
                n = 0;
                while (n < this.c_num) {
                    this.c_list[3 * n] = (short)dataInputStream.readUnsignedByte();
                    this.c_list[3 * n + 1] = (short)dataInputStream.readUnsignedByte();
                    this.c_list[3 * n + 2] = (short)dataInputStream.readUnsignedByte();
                    ++n;
                }
                n = 0;
                while (n < this.f_num) {
                    int n3 = dataInputStream.readUnsignedByte();
                    this.f_list[n].r = this.c_list[3 * n3];
                    this.f_list[n].g = this.c_list[3 * n3 + 1];
                    this.f_list[n].b = this.c_list[3 * n3 + 2];
                    ++n;
                }
            }
            try {
                this.m_num = dataInputStream.readInt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.m_num > 0) {
                this.map_list = new float[this.m_num * 2];
                int n4 = 0;
                while (n4 < this.m_num) {
                    this.map_list[2 * n4] = dataInputStream.readFloat();
                    this.map_list[2 * n4 + 1] = dataInputStream.readFloat();
                    ++n4;
                }
                n4 = 0;
                while (n4 < this.f_num) {
                    this.f_list[n4].vv1.u = 256.0f * this.map_list[2 * this.f_list[n4].v1];
                    this.f_list[n4].vv1.v = 256.0f * this.map_list[2 * this.f_list[n4].v1 + 1];
                    this.f_list[n4].vv2.u = 256.0f * this.map_list[2 * this.f_list[n4].v2];
                    this.f_list[n4].vv2.v = 256.0f * this.map_list[2 * this.f_list[n4].v2 + 1];
                    this.f_list[n4].vv3.u = 256.0f * this.map_list[2 * this.f_list[n4].v3];
                    this.f_list[n4].vv3.v = 256.0f * this.map_list[2 * this.f_list[n4].v3 + 1];
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    bl = true;
                    if (true) {
                        f5 = Math.abs(this.f_list[n4].vv1.u - this.f_list[n4].vv2.u);
                        if (f5 > f4) {
                            f4 = f5;
                        }
                        if ((f5 = Math.abs(this.f_list[n4].vv2.u - this.f_list[n4].vv3.u)) > f4) {
                            f4 = f5;
                        }
                        if ((f5 = Math.abs(this.f_list[n4].vv1.u - this.f_list[n4].vv3.u)) > f4) {
                            f4 = f5;
                        }
                        if (f4 > 128.0f) {
                            if (this.f_list[n4].vv1.u < 128.0f) {
                                this.f_list[n4].vv1.u += 256.0f;
                            }
                            if (this.f_list[n4].vv2.u < 128.0f) {
                                this.f_list[n4].vv2.u += 256.0f;
                            }
                            if (this.f_list[n4].vv3.u < 128.0f) {
                                this.f_list[n4].vv3.u += 256.0f;
                            }
                        }
                    }
                    bl2 = true;
                    if (true) {
                        f4 = 0.0f;
                        f5 = Math.abs(this.f_list[n4].vv1.v - this.f_list[n4].vv2.v);
                        if (f5 > f4) {
                            f4 = f5;
                        }
                        if ((f5 = Math.abs(this.f_list[n4].vv2.v - this.f_list[n4].vv3.v)) > f4) {
                            f4 = f5;
                        }
                        if ((f5 = Math.abs(this.f_list[n4].vv1.v - this.f_list[n4].vv3.v)) > f4) {
                            f4 = f5;
                        }
                        if (f4 > 128.0f) {
                            if (this.f_list[n4].vv1.v < 128.0f) {
                                this.f_list[n4].vv1.v += 256.0f;
                            }
                            if (this.f_list[n4].vv2.v < 128.0f) {
                                this.f_list[n4].vv2.v += 256.0f;
                            }
                            if (this.f_list[n4].vv3.v < 128.0f) {
                                this.f_list[n4].vv3.v += 256.0f;
                            }
                        }
                    }
                    ++n4;
                }
            }
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.toString());
        }
    }
}

