#include <stdio.h>
#include <math.h>
#include <malloc.h>

#define FX_WIDTH   320
#define FX_HEIGHT  100

char *PLASMA_Tab;
char *vbuffer;
char *fin;
int frames = 0;

int Y0;

void paleta (void)
{
    int i;

    for (i=0; i<256; i++)
    {
        outp (0x3c8, i);
        outp (0x3c9, i>>2);
        outp (0x3c9, i>>2);
        outp (0x3c9, i>>2);
    }
}

void FirePal (void)
{
    int i;
    char palette[768]={
     0, 0, 0, 0, 0, 6, 0, 0, 6, 0, 0, 7, 0, 0, 8, 0, 0, 8, 0, 0, 9, 0, 0,10 ,
     2, 0,10, 4, 0, 9, 6, 0, 9, 8, 0, 8,10, 0, 7,12, 0, 7,14, 0, 6,16, 0, 5 ,
     18, 0, 5,20, 0, 4,22, 0, 4,24, 0, 3,26, 0, 2,28, 0, 2,30, 0, 1,32, 0, 0,
     32, 0, 0,33, 0, 0,34, 0, 0,35, 0, 0,36, 0, 0,36, 0, 0,37, 0, 0,38, 0, 0,
     39, 0, 0,40, 0, 0,40, 0, 0,41, 0, 0,42, 0, 0,43, 0, 0,44, 0, 0,45, 0, 0,
     46, 1, 0,47, 1, 0,48, 2, 0,49, 2, 0,50, 3, 0,51, 3, 0,52, 4, 0,53, 4, 0,
     54, 5, 0,55, 5, 0,56, 6, 0,57, 6, 0,58, 7, 0,59, 7, 0,60, 8, 0,61, 8, 0,
     63, 9, 0,63, 9, 0,63,10, 0,63,10, 0,63,11, 0,63,11, 0,63,12, 0,63,12, 0,
     63,13, 0,63,13, 0,63,14, 0,63,14, 0,63,15, 0,63,15, 0,63,16, 0,63,16, 0,
     63,17, 0,63,17, 0,63,18, 0,63,18, 0,63,19, 0,63,19, 0,63,20, 0,63,20, 0,
     63,21, 0,63,21, 0,63,22, 0,63,22, 0,63,23, 0,63,24, 0,63,24, 0,63,25, 0,
     63,25, 0,63,26, 0,63,26, 0,63,27, 0,63,27, 0,63,28, 0,63,28, 0,63,29, 0,
     63,29, 0,63,30, 0,63,30, 0,63,31, 0,63,31, 0,63,32, 0,63,32, 0,63,33, 0,
     63,33, 0,63,34, 0,63,34, 0,63,35, 0,63,35, 0,63,36, 0,63,36, 0,63,37, 0,
     63,38, 0,63,38, 0,63,39, 0,63,39, 0,63,40, 0,63,40, 0,63,41, 0,63,41, 0,
     63,42, 0,63,42, 0,63,43, 0,63,43, 0,63,44, 0,63,44, 0,63,45, 0,63,45, 0,
     63,46, 0,63,46, 0,63,47, 0,63,47, 0,63,48, 0,63,48, 0,63,49, 0,63,49, 0,
     63,50, 0,63,50, 0,63,51, 0,63,52, 0,63,52, 0,63,52, 0,63,52, 0,63,52, 0,
     63,53, 0,63,53, 0,63,53, 0,63,53, 0,63,54, 0,63,54, 0,63,54, 0,63,54, 0,
     63,54, 0,63,55, 0,63,55, 0,63,55, 0,63,55, 0,63,56, 0,63,56, 0,63,56, 0,
     63,56, 0,63,57, 0,63,57, 0,63,57, 0,63,57, 0,63,57, 0,63,58, 0,63,58, 0,
     63,58, 0,63,58, 0,63,59, 0,63,59, 0,63,59, 0,63,59, 0,63,60, 0,63,60, 0,
     63,60, 0,63,60, 0,63,60, 0,63,61, 0,63,61, 0,63,61, 0,63,61, 0,63,62, 0,
     63,62, 0,63,62, 0,63,62, 0,63,63, 0,63,63, 1,63,63, 2,63,63, 3,63,63, 4,
     63,63, 5,63,63, 6,63,63, 7,63,63, 8,63,63, 9,63,63,10,63,63,10,63,63,11,
     63,63,12,63,63,13,63,63,14,63,63,15,63,63,16,63,63,17,63,63,18,63,63,19,
     63,63,20,63,63,21,63,63,21,63,63,22,63,63,23,63,63,24,63,63,25,63,63,26,
     63,63,27,63,63,28,63,63,29,63,63,30,63,63,31,63,63,31,63,63,32,63,63,33,
     63,63,34,63,63,35,63,63,36,63,63,37,63,63,38,63,63,39,63,63,40,63,63,41,
     63,63,42,63,63,42,63,63,43,63,63,44,63,63,45,63,63,46,63,63,47,63,63,48,
     63,63,49,63,63,50,63,63,51,63,63,52,63,63,52,63,63,53,63,63,54,63,63,55,
     63,63,56,63,63,57,63,63,58,63,63,59,63,63,60,63,63,61,63,63,62,63,63,63};

     outp (0x3c8, 0);
     for (i=0; i<768; i++)
         outp (0x3c9, palette[i]);
}


void SetVideo (char mode);
#pragma aux SetVideo = \
    "int 10h" \
    parm [ax];

void PLASMA_Init (void)
{
#define AMPLITUD  0.5
#define MAX_COLOR 64    // 4*64 = 256
    int x, y;
    int TabOff = 0;
    float Sqt;
    float Dat;
    int size = FX_WIDTH * FX_HEIGHT * 4;

    PLASMA_Tab = (char *) malloc (FX_WIDTH * FX_HEIGHT * 4);

    for (y=-FX_HEIGHT; y<FX_HEIGHT; y++ )
        for (x=-FX_WIDTH; x<FX_WIDTH; x++, TabOff++)
        {
            Sqt = sqrt( x*x + y*y ) * AMPLITUD;
            Dat = ( sin (Sqt / 9.5 ) + 1.0 ) * (MAX_COLOR >> 1);
            PLASMA_Tab[TabOff ] = (char) Dat;
        }

}

void PLASMA_Do (void)
{
    int x, y;
    char *p1, *p2;
    char *pDst = (char *) (vbuffer + 320 * Y0);
    int x0, y0, x1, y1;

    x0 = (FX_WIDTH>>1) + (FX_WIDTH>>1) * cos (frames / 171.0);
    y0 = (FX_HEIGHT>>1) + (FX_HEIGHT>>1) * cos (frames / 139.0);
    x1 = (FX_WIDTH>>1) + (FX_WIDTH>>1) * cos (frames / 101.0);
    y1 = (FX_HEIGHT>>1) + (FX_HEIGHT>>1) * cos (frames / 165.0);

    p1 = (char *) (PLASMA_Tab + x0 + (FX_WIDTH<<1) * y0);
    p2 = (char *) (PLASMA_Tab + x1 + (FX_WIDTH<<1) * y1);

    for (y=0; y<FX_HEIGHT; y++)
    {
        for (x=0; x<FX_WIDTH; x++)
            pDst[x] = p1[x] + p2[x];

        pDst += FX_WIDTH;
        p1 += FX_WIDTH<<1;
        p2 += FX_WIDTH<<1;
    }
}

void FIRE_Do (void)
{
    int x, y;
    int i;

    for (x=0; x<FX_WIDTH; x++)
    {
        vbuffer[x+320*(Y0+FX_HEIGHT-2)] = rand () % 2 == 1 ? 0 : 0xFF;
        vbuffer[x+320*(Y0+FX_HEIGHT-1)] = rand () % 2 == 1 ? 0 : 0xFF;
    }

    for (i=320*Y0; i<320*(Y0+FX_HEIGHT); i++)
    {
        vbuffer[i] = (vbuffer[i+320] + vbuffer[i+321] +
                      vbuffer[i+319] + vbuffer[i-320]) >> 2;

        if (vbuffer[i] > 0)
            vbuffer[i] --;
    }
}

void Scroll (int sy)
{
    int x, y;
    int ry;
    char *aux = (char *) malloc (64000);

    memcpy (aux, vbuffer, 64000);

    for (y=0; y<200; y++)
    {
        ry = (y + sy) % 200;
        for (x=0;x<320;x++)
            fin[x+320*y] = aux[x+320*ry];
    }

    free (aux);
}

void main (void)
{
    vbuffer = (char *) malloc (320 * 200);
    fin = (char *) malloc (320 * 200);
    memset (vbuffer, 0, 64000);
    memset (fin, 0, 64000);

    PLASMA_Init ( );

    SetVideo (0x13);
    //paleta ( );
    FirePal ( );

    while (!kbhit())
    {
        Y0 = 0;
        PLASMA_Do ();

        Y0 = FX_HEIGHT;
        FIRE_Do ();
        Scroll (frames);
        memcpy ((char *) 0xA0000, fin, 64000);

        frames ++;
    }
    getch ( );

    SetVideo (0x03);
}
