unit slit;
interface

uses routines,playmods,map;

const vidseg = $a000;
      zc = 256;
      xc = 160;
      yc = 100;

      gap = 100;
      sinsize = 360;

      skip = 4;

var virseg : word;
    virscr : pointer;
    loop : word;
    x,y,z : integer;
    stab,ctab : array[0..sinsize] of real;
    pal : array[0..255,1..3] of byte;
    palOK : boolean;
    frames : word;
    loppu : boolean;
    trackstatus : miscdata;
    status : miscdata;

procedure do_slit(nosound:boolean);

implementation

procedure do_slit(nosound:boolean);

begin
  cls(vidseg);
  randomize;
  getmem(virscr,320*200);
  virseg:=seg(virscr^);
  loadmap(virseg,'slit.map');

  for loop:=0 to sinsize do ctab[loop]:=cos(loop*pi/(sinsize div 2));
  for loop:=0 to sinsize do stab[loop]:=sin(loop*pi/(sinsize div 2));

  loppu:=false;

  loadPAL('slit.pal');
  repeat
    if nosound then begin
      inc(frames);
      if frames=gap then loppu:=true;
    end else begin
      get_module_status(trackstatus);
      if trackstatus[0]=$33 then loppu:=true;
    end;
    retrace;
    flip(virseg,vidseg);
  until (keypressed)or(loppu);
  freemem(virscr,320*200);
end;

end.