#include <stdio.h>
#include <stdlib.h>
#include <time.h>

char protomap[256][256];

int rasterizer[8]={0,32,16,48,8,40,24,56};

#define LIM(a) ((a)<0?0:((a)>255?255:(a)))

void recursive_plasma(int x0,int y0,int x1,int y1,int lev)
{
   if(x1>x0 && y1>y0)
   {
      int a=protomap[x0&255][y0&255],
          b=protomap[x1&255][y0&255],
          c=protomap[x0&255][y1&255],
          d=protomap[x1&255][y1&255],

          xm=(x0+x1)>>1,
          ym=(y0+y1)>>1;

      protomap[xm][y0]=(a+b)>>1;
      protomap[xm][y1]=(c+d)>>1;
      protomap[x0][ym]=(a+c)>>1;
      protomap[x1][ym]=(b+d)>>1;

        // 4:single detail, 8:g00d, 32:mess with great contrast
      { int k=rand()%((abs(x0-x1)<<lev)+1);
        if(k&1)k=0-k;
        protomap[xm][ym]=LIM((a+b+c+d+k)>>2);
      }

      if(x1>x0+1)
      {
         recursive_plasma(x0,y0,xm,ym,lev);
         recursive_plasma(xm,y0,x1,ym,lev);
         recursive_plasma(x0,ym,xm,y1,lev);
         recursive_plasma(xm,ym,x1,y1,lev);
      }
   }
}


void drawflier(char*pic0,char*bg0,int xzoom,int yzoom)
{
   int iy=0,ix;

   char*pic=pic0,
       *bg=bg0;

   while(*pic!='\0')
   {
      char*line=pic;
      int y=yzoom;

      for(;y;y--)
      {
         pic=line;
         while(*pic!='\n')
         {
            int x=xzoom;
            for(;x;x--)
            {
               if(*pic!=' ')
               {
                  putchar(*bg);
                  bg++;
                    if(*bg=='\0')bg=bg0;
               }
                else
               {
                  int k=protomap[iy&255][ix&255]+rasterizer[(iy^(ix<<1))&7];
                  putchar(" ..:;"[(k>>6)%5]);
               }
               ix++;
            }

            pic++;
              if(pic=='\0')pic=pic0;
         }
         iy++;
         ix=0;
         putchar('\n');
      }
      pic++;
   }
}

/********************************************************************/

char*pwpflier0=

   "                               \n"
   "                               \n"
   "                               \n"
   "         ** ********           \n" 
   "         ******** **           \n"
   "             ***               \n"
   "             ***               \n"
   "          *************        \n"
   "          *******************  \n"
   "         **********            \n"
   "         xxxxxx                \n"
   "        *****                  \n"
   "        *****    x             \n"
   "       ********                \n"
   "       ************            \n"
   "       **************          \n"
   "       ****************        \n"
   "        *****                  \n"
   "        *******                \n"
   "        ***********  xx        \n"
   "        ***************        \n"
   "         ************          \n"
   "         **********            \n"
   "           ******              \n"
   "           ******              \n"
   "           ******              \n"
   "                               \n"
   "   ******** **      ** ********\n" 
   "   ******** **      ** ********\n"
   "   **    ** **      ** **    **\n"
   "   **    ** **      ** **    **\n"
   "   ******** **  **  ** ********\n"
   "   ******** **  **  ** ********\n"
   "   **       **  **  ** **      \n"
   "   **       **  **  ** **      \n"
   "   **       ********** **      \n"
   "   **       ********** **      \n"
   "                               \n";

/* 
 *  From Jeesuksen Opetuslapset ry - freely distributable text
 *
 *  http://personal.inet.fi/yhdistys/jeesuksenopetuslapsetry./
 *
 */

char*jolry_bg=
   "Ottaisin plleni vaikka minklaisia ruttoja, jos saisin Jumalalta "
   "VOIMALLISTEN TEKOJEN ARMOLAHJAN! HENKIEN ULOSAJAMISEN ARMOLAHJAN! "
   "VAIKKA PUOLEKSI VUODEKSI!  ILMAN NIIT EN VOI KUN ITKE JA VALVOA "
   "ITNI! KYLL NE MIELESS ON NUO VUODET JA NE YT KUN TUOLLA KVELIN "
   "JA NIN KERTOMAANI! JA NYT SAAN KUULLA, ETT TM TOUHU KASVAA!!! JA "
   "JUURI THN AIKAAN!!!! SAATANA on vuositolkulla tietnyt "
   "Hengellisist asoista enemmn kuin uskovat!   "

   "1990 luvun alussa JUMALALTA tuli profetia: \"Nyt, MIN JUMALA, ALAN "
   "KURITTAMAAN SUOMEN KANSAA TOSI MIELESS, SIIT SYYST, ETT SUOMEN "
   "KANSASTA EI LYDY HNELLE KELPAAVASSA USKOSSA OLEVIA IHMISI, "
   "HNELLE RIITTV MR!   "

   "Kuinka paljon sinun perheesssi on tuhottu nitteit, joilla on ns. "
   "Hevy metalli rokkia? ns. Gospel musiikkia? Joita varhaisnuoret "
   "kuuntelevat, kuin ei mitn pahaa olisi!   "

   "SIIN TLL MENETELMLL MENEVT SITTEN 30 luvun Raamattu ja "
   "Herramme JEESUS MUKANA! VALITAN! NIN VAKAVISTA ASIOISTA ON KYSE! "
   "MINKS MIN HEILLE VOIN?! ITKE JA KOITTAA KUINKA KOVIA LYNTEJ "
   "TM NPPIMIST KEST! JA SYD PSYKOSOMAATTISIIN SAIRAUKSIINI "
   "PURKKI KAUPALLA PILLEREIT! JOITA LKRINI KIELSI SYMST! Kun ei "
   "ole varaa niihin lkkeisiin, joita tarvitsen!   "
 
   "HVETK! JOS OSAATTE!  RAAMATTU KERTOO, ETT ISRAELIN KANSA "
   "EVANKELIOIDAAN AIVAN MERKILLISELL TAVALLA! MITEN SAMASTA ASIASTA "
   "VOI OLLA KAKSI ERI VERSIOTA! PAINUKAA LUOLIIN JA TUKKIKAA SUUNNE! "
   "SANON MIN!  JOS EI TEILL MUUTA PUHUTTAVAA OLE! ON RAAMATUN "
   "LUKUNNEKIN OLLUT AIVAN TURHAA!  KUN ETTE YMMRR LUKEMAANNE! VOI "
   "PYH YKSINKERTAISUUS!  Pystyisin kaatamaan joka ainoan vitteenne! "
   "TE TULETTE RAAMATULLA!  JA AIVAN SAMALLA KIRJALLA MIN KAADAN "
   "JOKAISEN VALHEELLISEN VITTEENNE! MUTTA EN JAKSA! MUTTA VAROITAN "
   "KYLL NIST KIRJANOPPINEISTA! LK KUUNNELKO HEIT! KUUNNELKEE "
   "JEESUSTA! HN OPETTAA TEILLE RAAMATUN PERUSTOTUUDET HYVINKIN "
   "NOPEASTI! EIK NYT KYLL PITKIIN KURSSEIHIN AIKAA OLEKKAAN! VAINON "
   "AJAT OVAT LHELL!  JA TM KANSA EI TIED MITN!  ILMIANTAJIA ON "
   "TUHATMRIN ENEMMN;KUIN NIIT AITOJA JEESUKSEN SEURAAJIA JOITA "
   "TSSKIN MAASSA ALETAAN VAINOTA! NIN IKVSTI ON NYT ASIAT! JA "
   "VIEL YRITTTE SAATANAN JOUKKOJEN KEHOITUKSESTA TULEMAAN ESIIN! SE "
   "ON MIINA JOHON ME EMME NYT TULE! ANTEEKSI VAAN! TAIDAMME JOUTUA "
   "POISTUMAAN AIKAISEMMIN, KUIN OLETINKAAN!  VALMIINA KYLL OLLAAN! EI "
   "SIIN MITN! HUKASSA ON JO PALJON SUOMEN AITOJA USKOVAISIA! "
   "POISTUMME HETI KUN SILT NYTT! JEESUS ANTAA MERKIN! EMME TARVITSE "
   "KUIN TIEDON YLL! SEURAAVANA PIVN OLEMME JO KATEISSA! NIIN "
   "YKSINKERTAISTA!   "

   "YLEINEN VITTM; JOKA TAANNOIN VIIMEKSI MINULLEKKIN TAAS POSTIN "
   "KAUTTA HEITETTIIN:\" AITO PROFEETTA EI PUHU MILLOINKAAN "
   "VALHEPROFETIOITA!\" AIVAN VARMASTI JOUTUU PUHUMAAN! ILMESTYKSI "
   "NKEV; JOUTUU AIVAN VARMASTI KATSELEMAAN SAATANAN LUOMIA "
   "ILMESTYKSI!!!! SAARNAAJAT JA OPETTAJAT JOUTUVAT AIVAN VARMASTI "
   "NIHIN MIINOIHIN! JOUDUMME YLIHENGELLISYYTEEN! JOUDUMME LAN ALLE! "
   "IHAN VARMASTI JA AIVAN KYTNNSS! TM TAPAHTUU KOULUTTUKSEN "
   "AIKANA. KAIKKI NM! JA SENKIN JLKEEN SAATTAA LIPSUA!   "

   "Nyt VELI TEMPAISIKIN SUOMEKSI KOMENNON: JEESUKSEN KRISTUKSEN "
   "NASARETTILAISEN NIMESS! ANNETTIIN PIMEYDEN HENKILLE LHTKSKY! "
   "Mits nyt tapahtui?   "

   "AMERIKASTAKIN KUULEMMA AINAKIN YKSI BNDI TULEE! Sinne sitten vaan "
   "kuuntelemaan tuota SAATANAN LUOMAA MUSIIKKIA! Englannin sanakirjan "
   "mukaan gospel tarkoittaa suomeksi: evankeliumi! ETT SIIHEN MALLIIN "
   "MEILL PIN!  Tytyy teille kertoa ihan tosiasia! JA JLLEEN "
   "VALITETTAVASTI HYVIN MONIEN PETTYMYKSEKSI! SANAT OSIN RAAMATUSTA! "
   "SVELLYS SAATANAN! THN EI OLE ALUSTA ALKAENKAAN YHTYNYT JUMALA! EI "
   "PYH HENKI! EIK TULE MILLOINKAAN YHTYMN MIHINKN! MISS SAATANA "
   "TAI HNEN JOUKKONSA OVAT MUKANA! NIIISS LIIKKUU PIMEYDEN HENGET JA "
   "TUNTEET! PALJONHAN NIILLKIN AIKAAN SAADAAN! Pelottavin aikaan "
   "saannos tuollakin on JUMALAN VIHA!!! Maatamme kohtaan! SINNE NYT "
   "VANHEMMAT: KAKAROITANNE PSTTTE! SUORASTAAN TYRKYTTTE! JA "
   "KANNATTE USKOVAISEN NIME! Jttk tuo nimi pois! Ihan totta! "
   "Katsokaas, kun JUMALALLA JA SAATANALLA EI OLE MITN TEKEMIST "
   "TOISTENSA KANSSA! EI HIUSKARVAN VERTAA! EI OLE MILLOINKAAN OLLUT! "
   "SEN JLKEEN KUN SAATANA JA LANGENNEET ENKELIT TAIVAASTA VISKATTIIN! "
   "EIK TULE OLEMAAN! SAATANA ON KAIKEN MUSIIKIN JA KAIKKIEN SOITTIMIEN "
   "ASIANTUNTIJA! SIT HN OLI JO TAIVAASSA! ENNEN KUIN RYHTYI KAPINAAN "
   "JUMALAN KANSSA! Nin Raamattu meille kertoo! Valtavalle mrlle "
   "teist, tuo asia on tuttu! Mutta se nyt iknkuin ei kuuluisi "
   "teille! ARVATKAAPA: KUULUUKO???   "

   "Erotkaa, rakkaat ystvt, noista VOUHOTTAJISTA, JOTKA EIVT MITN "
   "TIED!!!  Kasetilla on sanoittus suurista ihmeist ja Raamatusta! "
   "SVELLYS ON SAATANAN!  LAULU ESITYS TYSIN TEKNINEN SUORITUS! JA "
   "KAIKEN LISKSI SURKEA SELLAINEN! SAMAT ARVOSANAT KIRJASTA! SAATANAN "
   "JOUKKOJEN KTYRI! Kuuluisuudestaan huolimatta; RIKU RINNE! AINAKIN "
   "NYT! Jos muutosta tapahtuu? VIE SE TUOLTA PAIKALTA, MISS HN NYT "
   "ON: MELKO PITKN AIKAA! EN TUOMITSE! MUTTA PALJASTAN! JA VAROITAN!   "

   "ELLEMME PSE ALKUSEURAKUNNAN KALTAISEEN JUMALAN VOIMAN VAIKUTUKSEN "
   "ALLE? ON TULOSSA ILMESTYSKIRJAN MUKAAN SELLAISTA TAVARAA MYS "
   "SUOMEEN! ETT ILMAN TT VOIMAA VOIMMEKIN SITTEN SANOA AIVAN "
   "VARMASTI TOISILLEMME HYVSTI JA HYV YT! OHJEET ANTAA JEESUS "
   "ALKUVALMISTELUT VOITTE TEHD ALKUSEURAKUNNAN TAPAAN! KERRAN MEIDT "
   "JOKAINEN RIISUTAAN!  ELLET NIHIN USKO? l vaan sitten kyt "
   "itsestsi nimityst uskovainen tai kristitty! VAAN JOS VITT ettei "
   "nm kuulu sinulle!  Eik meille tn aikana?! SIN OLET TYSI "
   "PELLE!   "

   "JA NMKN EIVT VIEL OLE TAKUULIPPU TAIVAASEEN! MUTTA, KUN "
   "KUULIAISESTI HERRAA TMN JLKEEN SEURAILEE. Voi joku saada "
   "kerrottua asian lapsilleen sukulaisilleen jne, NIMITTIN JOS NM "
   "RUKOUKSET TEET AIVAN VILPITTMSTI !  Tarkoitan tuollaista tietoista "
   "vilppi. KAIKKI ME NYT MUUTOIN OLLAAN KAIKKEA PAHUUTTA TYNN "
   "TIEDTK? SIELT....TAIVAASTA KAJAHTAA MAHTAVA VOIMA !   "

   "Ja raha on tuossa osavaltiossa ollut pois kytss tuon kokeen ajan. "
   "TM ON ILMESTYSKIRJASSA KERROTTU PEDON MERKKI! JOLLA TUOTA MERKKI "
   "EI OLE; HNELT EI OSTETA MITN! EIK MYYD MITN! SEHN ON "
   "SELVI! KUN RAHA POISTETAAN KYTST.  ON MAHDOTON ostaa tai myyd "
   "ilman tuota pedon merkki! Pyrin selittmn tmn hyvin "
   "kansanomaisesti. Ja kun tuo aika tulee. Ei paljon kertomastani voi "
   "tuo menetelm poiketa! Ja tm on sitten sellainen MERKKI, jota "
   "YKSIKN USKOVAINEN EI SAA MISSN OLOISSA OTTAA! NIMITTIN, kun "
   "Antikristus nousee ja vaaditaan tuo pedon merkki on se kovimpia "
   "koettelemuksia uskovaisille! Kansat kumartavat tuota "
   "petoa. Tottelevat hnt. Siis SAATANAN JUTTU!   "

   "Ellet tietoisesti palvele ja seuraa JEESUSTA, silloin tietmttsi "
   "palvelet ja seuraat SAATANAA! Hn pystyy tmn asian sinulta niin "
   "hmmn, ettet tied mitn! Jeesuksen omana olo ei ole salainen "
   "asia!   "

   "Kun yksikin taloudelliseti hyvin voiva henkil tekee Jumalan mielen "
   "mukaisen parannuksen. Napsahtaa omaisuudet automaattiseti Jumalan "
   "Valtakunnan tyhn!  EIK VAIN SINNE PIN! NIINKUIN NYT ON "
   "KAIKENAIKAA NHTVISS! NM SAATANAN VALTAAMAT VLINEET EIVT KOVIN "
   "KAUAA OLE USKOVAISTEN KDEN ULOTTUVILLA! JA SUOMESSA AIDOT JEESUKSEN "
   "SEURAAJAT, JUMALAN PALVELIJAT VOIVAT TEHD NIDEN LAITTEIDEN AVULLA "
   "VALTAVIA JUTTUJA, JOITA JUMALA SIUNAA KYLL SUOMESSA ON OLTAVA "
   "KETJUT KUNNOSSA: MITEN JAKO ETEENPIN TAPAHTUU! Vaikka Jumala "
   "Henkens kautta on tehnyt yht sun toista Suomessa ilman ihmisi! "
   "Raamatun mukaan IHMISI KYTETN JUMALAN VALTAKUNNAN TYSS HAMAAN "
   "JEESUKSEN TULEMUKSEEN ASTI!!!   "

   "JOS TOIMITTE: LISTIETOA TULEE JEESUKSELTA NOPEAAN TAHTIIN! KAIKKI "
   "MUU ON TYSIN TURHAA! Puhukoon Istala ja kumppanit mit tykk! "
   "Saatanan palveluksessa koko remmi ja TIUKASTI! Ja lis tulee! "
   "ISTALA KAATUU UUSIEN TUULIEN TULLESSA! Amerikassa jo valmiina! "
   "Levinnyt jo EUROOPPAAN! ENNUSTAN NILLE NYKYISILLE SAATANAN "
   "KTYREILLE nopeaa uran pttymist!   "

   "OLISIKOHAN SYYT VIIPYMATT MENN RUKOILLEN NYRASTI JEESUKSEN "
   "OPETUKSEN ALLE!  PARANNUKSEN TEON JLKEEN! JA SAMAN TIEN ANTAA "
   "ITSENS JUMALALLE OTOLLISEKSI UHRIKSI! Ehtii oppia PYHN HENGEN ja "
   "saatanallisten henkien ERON! Ainakin nin rikeiss muodoissa! "
   "Varoitan edelleen! lk tutkiko pimeyden henki????!   ";

/********************************************************************/

int main(int argc,char**argv)
{
   srand(time(NULL));

   if(argc<3)
   {
      fprintf(stderr,"usage: %s <xzoom> <yzoom> [plasma]\n",argv[0]);
   }
    else
   {
      if(argc==3)
      {
         int i,j;
         for(i=0;i<256;i++)
           for(j=0;j<256;j++)
             protomap[i][j]=0;
      }
       else
      {
         protomap[0][0]=rand()&255;
         protomap[0][255]=rand()&255;
         protomap[255][0]=rand()&255;
         protomap[255][255]=rand()&255;
         recursive_plasma(0,0,255,255,3);
      }
         
      drawflier(pwpflier0,jolry_bg,atoi(argv[1]),atoi(argv[2]));
   }
   return 0;
}

