#include "pwpdemo.h"

u8 psychtab0[64]=
{
  0x00,0x00,0x00,0x04,0x04,0x40,0x40,0x44,0x44,0x4c,0xc4,0xc4,0xcc,0xcc,
  0xca,0xac,0xfa,0xef,0xec,0xce,0xcc,0xc4,0x4c,0x44,0x40,0x04,0x00,0x00,
  0x00,0x04,0x06,0x60,0x66,0x6e,0xe6,0xee,0xef,0xfe,0xaf,0xfa,0xaa,0xea,
  0xee,0xea,0xae,0xaa,0xa3,0x3a,0x33,0x32,0x23,0x22,0x20,0x02,0x08,0x00,
  
  0x08,0x07,0x77,0x78,0x08,0x00,0x01
};

u8 psychtab1[64]=
{
  0x04,0x06,0x0e,0x6e,0xe6,0xee,0xe6,0x6e,0x60,0x06,0x00,0x01,0x10,0x15,
  0x51,0x55,0x5d,0xd5,0xdd,0xd5,0x5d,0x55,0x51,0x15,0x11,0x1e,0xe1,0xee,
  0xef,0xfe,0xff,0xfe,0xef,0xee,0xea,0xae,0xaa,0xa2,0x2a,0x20,0x02,0x00,
  0x00,0x02,0x20,0x22,0x2e,0xe2,0xee,0xea,0xaa,0xa2,0x2a,0x20,0x02,0x01,
  0x03,0x30,0x31,0x35,0x53,0x50,0x05
};

u8 psychtab2[64]=
{
  0x00,0x08,0x07,0x87,0x78,0x87,0x88,0x07,0x08,0x08,0x00,0x00,0x00,0x00,
  0x01,0x03,0x30,0x33,0x03,0x03,0x01,0x09,0x19,0x19,0x91,0x91,0x99,0x99,
  0x9c,0x99,0x91,0x19,0x1c,0x13,0x31,0x33,0x31,0x03,0x03,0x00,0x00,0x00,
  0x04,0x40,0x44,0x04,0x04,0x04,0x00,0x04,0x40,0x4e,0x40,0x04,0x00,0x04,
  0x05,0x05,0x04,0x04,0x00,0x00,0x00
};

void planes_draw(u8*map,int angle,int midpt)
{
   register u8*d=pwplib.videobuf.d;

   register int x;

   register int du=(SIN(angle)*MIN(pwplib.videobuf.width,pwplib.videobuf.height))/4096;

   int dv=(COS(angle)*pwplib.videobuf.height)/6666;

   register int i=midpt*256-(pwplib.videobuf.height>>1)*dv
                  -(pwplib.videobuf.width>>1)*du;

   int y=pwplib.videobuf.height;

   dv-=du*pwplib.videobuf.width;

   for(;y;y--)
   {
      for(x=pwplib.videobuf.width;x;x--)
      {
         *d++=map[(i>>8)&255];
         i+=du;
      }
      i+=dv;
   }
}

void xorplanes_draw(u8*map,int angle,int angle2,int midpt,int midpt2)
{
   register u8*d=pwplib.videobuf.d;

   register int x;

   register int du=(SIN(angle)*MIN(pwplib.videobuf.width,pwplib.videobuf.height))/4096,
                du2=(SIN(angle2)*MIN(pwplib.videobuf.width,pwplib.videobuf.height))/4096;

   int dv=(COS(angle)*pwplib.videobuf.height)/6666,
       dv2=(COS(angle2)*pwplib.videobuf.height)/6666;

   register int i=midpt*256-(pwplib.videobuf.height>>1)*dv
                  -(pwplib.videobuf.width>>1)*du,
                j=midpt2*256-(pwplib.videobuf.height>>1)*dv2
                  -(pwplib.videobuf.width>>1)*du2;

   int y=pwplib.videobuf.height;

   for(;y;y--)
   {
      int ii=i,jj=j;
      for(x=pwplib.videobuf.width;x;x--)
      {
         *d++=map[(ii>>8)&255]^map[(jj>>8)&255];
         ii+=du;jj+=du2;
      }
      i+=dv;j+=dv2;
   }
}


void planes_do(int t,int m)
{
   u8*tabbu[3]={psychtab0,psychtab1,psychtab2};
   u8 map[256];
   u8*tabu=tabbu[m&15];

   int step=1024,i,j=-t*80;

   for(i=0;i<128;i++)
   {
      map[i]=map[255-i]=tabu[(j>>8)&63];
      j+=step;

      step-=(step>>4);
   }

   if(m&16)
   planes_draw(map,t,SIN(t)/512);else
   xorplanes_draw(map,t,t*3/11,SIN(t)/512,SIN(t*2.376)/1024);
}
