//
// Tiny Format class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package tinyptc;



public class Format
{
    public Format(int bits)
    {
        // indexed color
        _bits = 8;
    }

    public Format(int bits,int r,int g,int b)
    {
        // direct color
        _bits = 32;
        _r = r;
        _g = g;
        _b = b;
    }

    public Format(int bits,int r,int g,int b,int a)
    {
        // direct color
        _bits = 32;
        _r = r;
        _g = g;
        _b = b;
        _a = a;
    }

    public int r()
    {
        // get r
        return _r;
    }

    public int g()
    {
        // get g
        return _g;
    }

    public int b()
    {
        // get b
        return _b;
    }

    public int a()
    {
        // get a
        return _a;
    }

    public int bits()
    {
        // get bits
        return _bits;
    }

    public int bytes()
    {
        // get bytes
        return _bits/8;
    }

    public boolean direct()
    {
        // is direct color?
        if (_bits==32) return true;
        else return false;
    }

    public boolean indexed()
    {
        // is indexed color?
        return !direct();
    }

    // format data
    private int _r;
    private int _g;
    private int _b;
    private int _a;
    private int _bits;
}
