//
// RNI Timer class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.rni;

// class imports
import ptc.Error;



public class Timer implements ptc.base.Timer
{
    public Timer() throws Error
    {
        // create object
        object = create();
    }

    public Timer(double time) throws Error
    {
        // create object
        object = create();

        // set time
        set(time);
    }

    protected void finalize() throws Error
    {
        // destroy object
        destroy(object);
    }
    
    public void set(double time) throws Error
    {
        // set time
        set(object,time);
    }

    public void start() throws Error
    {
        // start timer
        start(object);
    }

    public void stop() throws Error
    {
        // stop tmer
        stop(object);
    }

    public double time() throws Error
    {
        // get time
        return time(object);
    }

    public double delta() throws Error
    {
        // get delta
        return delta(object);
    }

    public double resolution() throws Error
    {
        // get resolution
        return resolution(object);
    }

    // object handle
    private long object;

    // native methods
    private native long create() throws Error;
    private native void destroy(long object) throws Error;
    private native void set(long object,double time) throws Error;
    private native void start(long object) throws Error;
    private native void stop(long object) throws Error;
    private native double time(long object) throws Error;
    private native double delta(long object) throws Error;
    private native double resolution(long object) throws Error;
}
