//
// Java Window class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.java;

// import classes
import ptc.Area;
import ptc.Error;
import ptc.Format;
import java.awt.Insets;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Component;
import java.awt.Container;



public class Window
{
    public Window(Component component,int width,int height)
    {
        // setup title
        title = "unknown";

        // setup component
        this.component = component;
    }

    public Window(String title,int width,int height)
    {
        // setup title
        this.title = title;

        // create frame component
        component = new Frame(this,title,width,height);
    }

    public void close()
    {
        // check component type
        if (component instanceof Frame)
        {
            // cast to frame
            Frame frame = (Frame) component;

            // free frame
            frame.dispose();
        }
    }

    public void dispose()
    {
        // close
        close();
    }

    public void update()
    {
        // check component reference
        if (component==null) return;

        // get component graphics object
        Graphics graphics = component.getGraphics();

        // paint graphics
        paint(graphics);
    }

    public void paint(Graphics graphics)
    {
        // check graphics component and display references
        if (graphics==null || component==null || display==null) return;

        // get size of component
        Dimension size = component.getSize();
    
        // check component type
        if (component instanceof Container)
        {
            // cast to container
            Container container = (Container) component;

            // get container insets
            Insets insets = container.getInsets();

            // calculate client rectangle
            int x1 = insets.left;
            int y1 = insets.top;
            int x2 = size.width - insets.right;
            int y2 = size.height - insets.bottom;

            // draw display to graphics object
            display.draw(graphics,x1,y1,x2,y2);
        }
        else
        {
            // draw display to graphics object
            display.draw(graphics,0,0,size.width,size.height);
        }
    }

    public String title()
    {
        // get title
        return title;
    }
    
    public Component component()
    {
        // get component
        return component;
    }

    public void register(Keyboard keyboard)
    {
        // add key listener to component
        component.addKeyListener(keyboard);
    }

    public void unregister(Keyboard keyboard)
    {
        // remove key listener from component
        component.removeKeyListener(keyboard);
    }

    public void register(Display display)
    {
        // register display
        this.display = display;
    }

    public void unregister(Display display)
    {
        // unregister display
        if (display==this.display) this.display = null;
    }
    
    // window data
    private String title;
    private Display display;
    private Component component;
}
