//
// Java Display class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.java;

// import classes
import ptc.Area;
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;
import java.awt.Graphics;



public class Display
{
    public Display(int width,int height,Format format,int pages)
    {
        // create display pages
        page = new Page[pages];
 
        // construct display pages
        for (int i=0; i<pages; i++) page[i] = new Page(width,height,format);

        // index
        back  = 0;
        front = 0;

        // update
        update();
    }

    void close()
    {
        // close all display pages to free memory
        for (int i=0; i<page.length; i++) page[i].close();
    }

    public void flush()
    {
        // flush display
    }

    public void finish()
    {
        // finish display
    }                    

    public void update()
    {
        // show back page
        front = back;

        // next page
        back++;
        
        // handle page array overrun
        if (back==page.length) back=0;
    }

    public void update(Area area)
    {
        // update
        update();
    }

    public void palette(Palette palette)
    {
        // iterate through all pages
        for (int i=0; i<page.length; i++) 
        {
            // set page palette
            page[i].palette(palette);
        }
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        // load pixels to back page
        page[back].load(pixels,width,height,pitch,format,palette);
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        // load pixels to back page area
        page[back].load(pixels,width,height,pitch,format,palette,source,destination);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        // save back page pixels
        page[back].save(pixels,width,height,pitch,format,palette);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        // save back page pixels area
        page[back].save(pixels,width,height,pitch,format,palette,source,destination);
    }

    public void clear(Color color,Area area) throws Error
    {
        // clear back page area
        page[back].clear(color,area);
    }

    public void draw(Graphics graphics,int x1,int y1,int x2,int y2)
    {
        // draw front page to graphics object
        page[front].draw(graphics,x1,y1,x2,y2);
    }

    // display data
    private int back;
    private int front;
    private Page page[];
}
