//
// Console interface for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.base;

// import classes
import ptc.Key;
import ptc.Area;
import ptc.Mode;
import ptc.Error;
import ptc.Format;



public interface Console extends Surface
{
    // console configuration
    public void configure(String file) throws Error;

    // console modes
    public Mode[] modes() throws Error;

    // console management
    public void open(String title) throws Error;
    public void open(String title,int pages) throws Error;
    public void open(String title,Format format) throws Error;
    public void open(String title,Format format,int pages) throws Error;
    public void open(String title,int width,int height,Format format) throws Error;
    public void open(String title,int width,int height,Format format,int pages) throws Error;
    public void open(String title,Mode mode) throws Error;
    public void open(String title,Mode mode,int pages) throws Error;
    public void close() throws Error;

    // synchronization
    public void flush() throws Error;
    public void finish() throws Error;
    public void update() throws Error;
    public void update(Area area) throws Error;

    // keyboard input
    public boolean key() throws Error;
    public Key read() throws Error;

    // data access
    public int pages() throws Error;
    public String name() throws Error;
    public String title() throws Error;
    public String information() throws Error;
}
