//
// Factory class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package
package ptc;



public class Factory
{
    public static synchronized void initialize() throws Error
    {
        // check count
        if (count==0)
        {
            try
            {
                // load ptc library
                System.loadLibrary("ptc");

                try
                {
                    // RNI
                    mode = RNI;

                    // test object creation
                    ptc.base.Timer timer = new ptc.rni.Timer();

                    // test object linkage
                    double time = timer.time();
                }
                catch (Throwable error)
                {
                    // JNI
                    mode = JNI;

                    // test object creation
                    ptc.base.Timer timer = new ptc.jni.Timer();

                    // test object linkage
                    double time = timer.time();
                }
            }
            catch (Throwable error)
            {
                // pure java
                mode = JAVA;
            }
        }

        // increment count
        count ++;
    }

    public static synchronized void free() throws Error
    {
        // decrease count
        count --;

        // check count
        if (count<0) throw new Error("factory reference count is less than zero!");
    }   

    public static synchronized ptc.base.Console console() throws Error
    {
        try
        {
            // create console
            switch (mode)
            {
                case JNI: return new ptc.jni.Console();
                case RNI: return new ptc.rni.Console();
            }
        }
        catch (Throwable error) 
        {
            // failure!
        }

        // pure java implementation
        return new ptc.java.Console();
    }

    public static synchronized ptc.base.Copy copy() throws Error
    {
        try
        {
            // create copy
            switch (mode)
            {
                case JNI: return new ptc.jni.Copy();
                case RNI: return new ptc.rni.Copy();
            }
        }
        catch (Throwable error) 
        {
            // failure!
        }

        // pure java implementation
        return new ptc.java.Copy();
    }

    public static synchronized ptc.base.Clear clear() throws Error
    {
        try
        {
            // create clear
            switch (mode)
            {
                case JNI: return new ptc.jni.Clear();
                case RNI: return new ptc.rni.Clear();
            }
        }
        catch (Throwable error) 
        {
            // failure!
        }

        // pure java implementation
        return new ptc.java.Clear();
    }

    public static synchronized ptc.base.Timer timer() throws Error
    {
        try
        {
            // create timer
            switch (mode)
            {
                case JNI: return new ptc.jni.Timer();
                case RNI: return new ptc.rni.Timer();
            }
        }
        catch (Throwable error) 
        {
            // failure!
        }

        // pure java implementation
        return new ptc.java.Timer();
    }

    // factory constants
    static final int JNI  = 0;
    static final int RNI  = 1;
    static final int JAVA = 2;

    // static factory data
    static int mode = JAVA;
    static int count = 0;
}
