/* -*- mode: c++ -*-

  This file is part of Jeeves64, an application framework for 64k
  GNU/Linux and win32 intro development. 
  
  This file is Copyright (c) 2000 Kuno Woudt <warp-tmt@dds.nl>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING; if not, write to
  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
  Boston, MA  02111-1307  USA
*/

#ifndef _TILES_H_
#define _TILES_H_

/* in this file:

   transitions:
        tile_transition_1
        tile_transition_2
   void:
        tile_void
        tile_muren1
        tile_muren2
   Anim_void:
        tile_anim_plane1
        tile_anim_plane2
        tile_anim_plane3
        tile_anim_plane4
        tile_anim_enemy
        tile_anim_bullet1
        tile_anim_bullet2
        tile_anim_laser
   Anim_void2:
        tile_ani2_plane1
        tile_ani2_plane2
        tile_ani2_plane3
        tile_ani2_plane4
        tile_ani2_laser1
        tile_ani2_laser2
        tile_ani2_laser3
        tile_ani2_enemy1
        tile_ani2_enemy2
        tile_ani2_enemy3_bullet5
        tile_ani2_enemy4
        tile_ani2_bullet1_bullet6
        tile_ani2_bullet2
        tile_ani2_bullet3
        tile_ani2_bullet4
   gras:
        tile_grasveld
   Anim_gras:
        tile_gras1
        tile_gras2
        tile_anim_koelkast_en_deur
        tile_anim_koelkast
        tile_anim_meisje
        tile_anim_knaapje
        tile_anim_tekst
   Anim_gras3:
        tile_grasIII_1
        tile_grasIII_2
        tile_anim_intro_tekst
        tile_anim_intro_deur1
        tile_anim_intro_deur2
        tile_anim_intro_knaap
        tile_anim_intro_meisje
        tile_anim_intro_robotter
        tile_anim_chase_knaap
        tile_anim_chase_meisje
        tile_anim_chase_robotter
 */

#define TILES_BG_SIZE (0x08*0x0d)
char tile_transition_1[TILES_BG_SIZE] = 
{
  0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 
  0x13, 0x12, 0x11, 0x10, 0x0f, 0x0e, 0x0d, 0x0c, 
  0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 
  0x23, 0x22, 0x21, 0x20, 0x1f, 0x1e, 0x1d, 0x1c, 
  0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 
  0x33, 0x32, 0x31, 0x30, 0x2f, 0x2e, 0x2d, 0x2c, 
  0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 
  0x43, 0x42, 0x41, 0x40, 0x3f, 0x3e, 0x3d, 0x3c, 
  0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 
  0x53, 0x52, 0x51, 0x50, 0x4f, 0x4e, 0x4d, 0x4c, 
  0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 
  0x63, 0x62, 0x61, 0x60, 0x5f, 0x5e, 0x5d, 0x5c, 
  0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b,
};

char tile_transition_2[TILES_BG_SIZE] = 
{
  0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 
  0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x0c, 
  0x28, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x30, 0x0d, 
  0x27, 0x46, 0x5d, 0x5e, 0x5f, 0x4c, 0x31, 0x0e, 
  0x26, 0x45, 0x5c, 0x6b, 0x60, 0x4d, 0x32, 0x0f, 
  0x25, 0x44, 0x5b, 0x6a, 0x61, 0x4e, 0x33, 0x10, 
  0x24, 0x43, 0x5a, 0x69, 0x62, 0x4f, 0x34, 0x11, 
  0x23, 0x42, 0x59, 0x68, 0x63, 0x50, 0x35, 0x12, 
  0x22, 0x41, 0x58, 0x67, 0x64, 0x51, 0x36, 0x13, 
  0x21, 0x40, 0x57, 0x66, 0x65, 0x52, 0x37, 0x14, 
  0x20, 0x3f, 0x56, 0x55, 0x54, 0x53, 0x38, 0x15, 
  0x1f, 0x3e, 0x3d, 0x3c, 0x3b, 0x3a, 0x39, 0x16, 
  0x1e, 0x1d, 0x1c, 0x1b, 0x1a, 0x19, 0x18, 0x17,
};

char tile_void[TILES_BG_SIZE] = 
{
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 
  0x64, 0x62, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 
  0x64, 0x64, 0x63, 0x64, 0x62, 0x64, 0x64, 0x64, 
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x63, 0x64, 

  0x64, 0x64, 0x62, 0x64, 0x64, 0x64, 0x64, 0x64, 
  0x64, 0x63, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x62, 0x64, 
  0x64, 0x64, 0x63, 0x64, 0x62, 0x64, 0x64, 0x64, 

  0x64, 0x63, 0x64, 0x64, 0x64, 0x62, 0x64, 0x64, 
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x63, 0x64, 
  0x64, 0x62, 0x64, 0x64, 0x63, 0x64, 0x64, 0x64, 
  0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 

  0x64, 0x63, 0x64, 0x64, 0x64, 0x62, 0x64, 0x64
};

char tile_muren1[TILES_BG_SIZE] = 
{
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 

  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 

  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 

  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67
};

char tile_muren2[TILES_BG_SIZE] = 
{
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 

  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 

  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 

  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68
};

char tile_anim_plane1[3*0x1c+1] = 
{
  0x1c,              // count
  0x00, 0x00, 0x00, /* */  0x04, 0x18, 0x5c, /* */  0x04, 0x17, 0x5c,   // 0x00, 0x01, 0x02
  0x04, 0x16, 0x5c, /* */  0x04, 0x15, 0x5c, /* */  0x04, 0x14, 0x5c,   // 0x03, 0x04, 0x05 
  0x05, 0x13, 0x5c, /* */  0x06, 0x12, 0x5c, /* */  0x06, 0x11, 0x5c,   // 0x06, 0x07, 0x08
  0x06, 0x10, 0x5c, /* */  0x05, 0x0f, 0x5c, /* */  0x04, 0x0e, 0x5c,   // 0x09, 0x0a, 0x0b
  0x04, 0x0d, 0x5c, /* */  0x05, 0x0c, 0x5c, /* */  0x06, 0x0c, 0x5c,   // 0x0c, 0x0d, 0x0e
  0x07, 0x0d, 0x5c, /* */  0x08, 0x0e, 0x5c, /* */  0x09, 0x0e, 0x5c,   // 0x0f, 0x10, 0x11
  0x0a, 0x0d, 0x5c, /* */  0x0a, 0x0c, 0x5c, /* */  0x0a, 0x0a, 0x5c,   // 0x12, 0x13, 0x14
  0x09, 0x08, 0x5c, /* */  0x08, 0x06, 0x5c, /* */  0x07, 0x04, 0x5c,   // 0x15, 0x16, 0x17
  0x07, 0x02, 0x5c, /* */  0x07, 0x00, 0x5c, /* */  0x00, 0x00, 0x00,   // 0x18, 0x19, 0x1a
  0x00, 0x00, 0x00                                                      // 0x1b,
};

char tile_anim_plane2[3*0x1c+1] = 
{
  0x1c,              // count
  0x00, 0x00, 0x00, /* */  0x06, 0x18, 0x5d, /* */  0x06, 0x17, 0x5d,   // 0x00, 0x01, 0x02
  0x06, 0x16, 0x5d, /* */  0x06, 0x15, 0x5d, /* */  0x06, 0x14, 0x5d,   // 0x03, 0x04, 0x05 
  0x07, 0x13, 0x5d, /* */  0x08, 0x12, 0x5d, /* */  0x08, 0x11, 0x5d,   // 0x06, 0x07, 0x08
  0x08, 0x10, 0x5d, /* */  0x07, 0x0f, 0x5d, /* */  0x06, 0x0e, 0x5d,   // 0x09, 0x0a, 0x0b
  0x06, 0x0d, 0x5d, /* */  0x07, 0x0c, 0x5d, /* */  0x08, 0x0c, 0x5d,   // 0x0c, 0x0d, 0x0e
  0x09, 0x0d, 0x5d, /* */  0x0a, 0x0e, 0x5d, /* */  0x0b, 0x0e, 0x5d,   // 0x0f, 0x10, 0x11
  0x0c, 0x0d, 0x5d, /* */  0x0c, 0x0c, 0x5d, /* */  0x0c, 0x0a, 0x5d,   // 0x12, 0x13, 0x14
  0x0b, 0x08, 0x5d, /* */  0x0a, 0x06, 0x5d, /* */  0x09, 0x04, 0x5d,   // 0x15, 0x16, 0x17
  0x09, 0x02, 0x5d, /* */  0x09, 0x00, 0x5d, /* */  0x00, 0x00, 0x00,   // 0x18, 0x19, 0x1a
  0x00, 0x00, 0x00                                                      // 0x1b,
};

char tile_anim_plane3[3*0x1c+1] = 
{
  0x1c,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,   // 0x00, 0x01, 0x02
  0x04, 0x18, 0x5e, /* */  0x04, 0x17, 0x5e, /* */  0x04, 0x16, 0x5e,   // 0x03, 0x04, 0x05 
  0x05, 0x15, 0x5e, /* */  0x06, 0x14, 0x5e, /* */  0x06, 0x13, 0x5e,   // 0x06, 0x07, 0x08
  0x06, 0x12, 0x5e, /* */  0x05, 0x11, 0x5e, /* */  0x04, 0x10, 0x5e,   // 0x09, 0x0a, 0x0b
  0x04, 0x0f, 0x5e, /* */  0x05, 0x0e, 0x5e, /* */  0x06, 0x0e, 0x5e,   // 0x0c, 0x0d, 0x0e
  0x07, 0x0f, 0x5e, /* */  0x08, 0x10, 0x5e, /* */  0x09, 0x10, 0x5e,   // 0x0f, 0x10, 0x11
  0x0a, 0x0f, 0x5e, /* */  0x0a, 0x0e, 0x5e, /* */  0x0a, 0x0c, 0x5e,   // 0x12, 0x13, 0x14
  0x09, 0x0a, 0x5e, /* */  0x08, 0x08, 0x5e, /* */  0x07, 0x06, 0x5e,   // 0x15, 0x16, 0x17
  0x07, 0x04, 0x5e, /* */  0x07, 0x02, 0x5e, /* */  0x07, 0x00, 0x5e,   // 0x18, 0x19, 0x1a
  0x00, 0x00, 0x00                                                      // 0x1b,
};

char tile_anim_plane4[3*0x1c+1] = 
{
  0x1c,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,   // 0x00, 0x01, 0x02
  0x06, 0x18, 0x5f, /* */  0x06, 0x17, 0x5f, /* */  0x06, 0x16, 0x5f,   // 0x03, 0x04, 0x05 
  0x07, 0x15, 0x5f, /* */  0x08, 0x14, 0x5f, /* */  0x08, 0x13, 0x5f,   // 0x06, 0x07, 0x08
  0x08, 0x12, 0x5f, /* */  0x07, 0x11, 0x5f, /* */  0x06, 0x10, 0x5f,   // 0x09, 0x0a, 0x0b
  0x06, 0x0f, 0x5f, /* */  0x07, 0x0e, 0x5f, /* */  0x08, 0x0e, 0x5f,   // 0x0c, 0x0d, 0x0e
  0x09, 0x0f, 0x5f, /* */  0x0a, 0x10, 0x5f, /* */  0x0b, 0x10, 0x5f,   // 0x0f, 0x10, 0x11
  0x0c, 0x0f, 0x5f, /* */  0x0c, 0x0e, 0x5f, /* */  0x0c, 0x0c, 0x5f,   // 0x12, 0x13, 0x14
  0x0b, 0x0a, 0x5f, /* */  0x0a, 0x08, 0x5f, /* */  0x09, 0x06, 0x5f,   // 0x15, 0x16, 0x17
  0x09, 0x04, 0x5f, /* */  0x09, 0x02, 0x5f, /* */  0x09, 0x00, 0x5f,   // 0x18, 0x19, 0x1a
  0x00, 0x00, 0x00                                                      // 0x1b,
};

char tile_anim_enemy[3*0x1c+1] = 
{
  0x1c,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x06, 0x00, 0x69,
  0x06, 0x01, 0x69, /* */  0x05, 0x02, 0x69, /* */  0x04, 0x03, 0x69,
  0x03, 0x04, 0x69, /* */  0x02, 0x05, 0x69, /* */  0x02, 0x06, 0x69,
  0x02, 0x07, 0x69, /* */  0x03, 0x08, 0x69, /* */  0x04, 0x08, 0x69,
  0x05, 0x07, 0x69, /* */  0x06, 0x07, 0x69, /* */  0x07, 0x06, 0x69,
  0x08, 0x06, 0x69, /* */  0x09, 0x05, 0x69, /* */  0x0a, 0x05, 0x69,
  0x0a, 0x05, 0x6a, /* */  0x0a, 0x05, 0x6b, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00                                                   
};

char tile_anim_bullet1[3*0x1c+1] = 
{
  0x1c,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x06, 0x03, 0x60, /* */  0x06, 0x04, 0x61, /* */  0x06, 0x05, 0x60,
  0x06, 0x06, 0x61, /* */  0x06, 0x07, 0x60, /* */  0x06, 0x08, 0x61,
  0x06, 0x09, 0x60, /* */  0x06, 0x0a, 0x61, /* */  0x06, 0x0b, 0x60,
  0x06, 0x0c, 0x61, /* */  0x06, 0x0d, 0x60, /* */  0x06, 0x0e, 0x61,
  0x06, 0x0f, 0x60, /* */  0x06, 0x10, 0x61, /* */  0x06, 0x11, 0x60,
  0x06, 0x12, 0x61, /* */  0x06, 0x13, 0x60, /* */  0x06, 0x14, 0x61,
  0x06, 0x15, 0x60, /* */  0x06, 0x16, 0x61, /* */  0x06, 0x17, 0x60,
  0x06, 0x18, 0x61                                                   
};

char tile_anim_bullet2[3*0x1c+1] = 
{
  0x1c,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x04, 0x09, 0x61, /* */  0x05, 0x0a, 0x60,
  0x06, 0x0b, 0x61, /* */  0x07, 0x0c, 0x60, /* */  0x08, 0x0d, 0x61,
  0x09, 0x0e, 0x60, /* */  0x0a, 0x0f, 0x61, /* */  0x0b, 0x10, 0x60,
  0x0c, 0x11, 0x61, /* */  0x0d, 0x12, 0x60, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00                                                   
};

char tile_anim_laser[3*0x1c+1] = 
{
  0x1c,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x0b, 0x0e, 0x6d,
  0x0b, 0x0c, 0x6d, /* */  0x0b, 0x0a, 0x6d, /* */  0x0b, 0x08, 0x6d,
  0x0b, 0x06, 0x6d, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00                                                   
};


/*

  order of character animation tiles:
    w/e/n/s/d - west, east, north, south, Dance!
    s/1/2 - standing still, step 1, step 2
    [ws w1 w1 es e1 e2 ns n1 n2 ss s1 s2 ds d1 d2]  

    [01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f] - knaapje
    [10 11 12 13 14 15 16 17 18 19 1a 1b 1c 1d 1e] - meisje
    [1f 20 21 22 23 24 25 26 27 28 29 2a 2b 2c 2d] - robotter

  tiles:
  0x00        empty
  0x01..0x0F  knaap met blauw haar
  0x10..0x1E  meisje met paars haar
  0x1F..0x2D  intergalactic robot
  0x2e..0x31  tegel vloer, houten vloer
  0x32..0x34  muur horizontaal, muur verticaal (links), deur
  0x35, 0x36  stoel
  0x37, 0x38  desktop pc    (c) nintendo/gamefreaks :)
  0x39, 0x3a  tv            (c) nintendo/gamefreaks :)
  0x3b..0x3e  tuner/amplifier, speaker.
  0x3f..0x42  koelkast dicht, koelkast open.
  0x43..0x46  tafel
  0x47..0x4a  asfalt weg verticaal, asfalt weg horizontaal (of andersom. tis misleidend :)
  0x4b..0x52  boom 1, boom 2
  0x53        gras!
  0x54        kiezel pad
  0x55        paaltje
  0x56        lelijk plantje
  0x57        picknick doekje of rood/wit schaakbord :)
  0x58..0x5b  tekst ballonnen: ?!?, #@!, ---, ---  
  0x5c..0x5f  vliegtuig
  0x60, 0x61  schoten
  0x62..0x64  bright star, star, no star
  0x65..0x68  left wall 1/2, right wall 1/2
  0x69..0x6b  enemy ship, (bright), (dark)
  0x6c, 0x6d  laser links, rechts
  0x6e..0x71  vliegtuig (bright)
  0x72..0x75  vliegtuig (dark)
*/

char tile_ani2_plane1[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x06, 0x18, 0x5c, /* */  0x06, 0x17, 0x5c, /* */  0x06, 0x16, 0x5c, // 6
  0x06, 0x15, 0x5c, /* */  0x06, 0x14, 0x5c, /* */  0x06, 0x13, 0x5c, // 9
  0x06, 0x12, 0x5c, /* */  0x05, 0x12, 0x5c, /* */  0x04, 0x11, 0x5c, // 12
  0x04, 0x10, 0x5c, /* */  0x04, 0x0f, 0x5c, /* */  0x05, 0x0e, 0x5c, // 15
  0x06, 0x0e, 0x5c, /* */  0x07, 0x0e, 0x5c, /* */  0x08, 0x0f, 0x5c, // 18
  0x08, 0x0f, 0x5c, /* */  0x08, 0x0f, 0x5c, /* */  0x08, 0x10, 0x5c, // 21
  0x08, 0x0f, 0x5c, /* */  0x08, 0x0e, 0x5c, /* */  0x08, 0x0f, 0x5c, // 24
  0x09, 0x10, 0x5c, /* */  0x08, 0x11, 0x5c, /* */  0x08, 0x11, 0x5c, // 27
  0x08, 0x12, 0x5c, /* */  0x07, 0x12, 0x5c, /* */  0x06, 0x12, 0x5c, // 30
  0x05, 0x12, 0x5c, /* */  0x05, 0x12, 0x6e, /* */  0x05, 0x12, 0x72, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_plane2[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x08, 0x18, 0x5d, /* */  0x08, 0x17, 0x5d, /* */  0x08, 0x16, 0x5d, // 6
  0x08, 0x15, 0x5d, /* */  0x08, 0x14, 0x5d, /* */  0x08, 0x13, 0x5d, // 9
  0x08, 0x12, 0x5d, /* */  0x07, 0x12, 0x5d, /* */  0x06, 0x11, 0x5d, // 12
  0x06, 0x10, 0x5d, /* */  0x06, 0x0f, 0x5d, /* */  0x07, 0x0e, 0x5d, // 15
  0x08, 0x0e, 0x5d, /* */  0x09, 0x0e, 0x5d, /* */  0x0a, 0x0f, 0x5d, // 18
  0x0a, 0x0f, 0x5d, /* */  0x0a, 0x0f, 0x5d, /* */  0x0a, 0x10, 0x5d, // 21
  0x0a, 0x0f, 0x5d, /* */  0x0a, 0x0e, 0x5d, /* */  0x0a, 0x0f, 0x5d, // 24
  0x0b, 0x10, 0x5d, /* */  0x0a, 0x11, 0x5d, /* */  0x0a, 0x11, 0x5d, // 27
  0x0a, 0x12, 0x5d, /* */  0x09, 0x12, 0x5d, /* */  0x08, 0x12, 0x5d, // 30
  0x07, 0x12, 0x5d, /* */  0x07, 0x12, 0x6f, /* */  0x07, 0x12, 0x73, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_plane3[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x06, 0x18, 0x5e, // 6
  0x06, 0x17, 0x5e, /* */  0x06, 0x16, 0x5e, /* */  0x06, 0x15, 0x5e, // 9
  0x06, 0x14, 0x5e, /* */  0x05, 0x14, 0x5e, /* */  0x04, 0x13, 0x5e, // 12
  0x04, 0x12, 0x5e, /* */  0x04, 0x11, 0x5e, /* */  0x05, 0x10, 0x5e, // 15
  0x06, 0x10, 0x5e, /* */  0x07, 0x10, 0x5e, /* */  0x08, 0x11, 0x5e, // 18
  0x08, 0x11, 0x5e, /* */  0x08, 0x11, 0x5e, /* */  0x08, 0x12, 0x5e, // 21
  0x08, 0x11, 0x5e, /* */  0x08, 0x10, 0x5e, /* */  0x08, 0x11, 0x5e, // 24
  0x09, 0x12, 0x5e, /* */  0x08, 0x13, 0x5e, /* */  0x08, 0x13, 0x5e, // 27
  0x08, 0x14, 0x5e, /* */  0x07, 0x14, 0x5e, /* */  0x06, 0x14, 0x5e, // 30
  0x05, 0x14, 0x5e, /* */  0x05, 0x14, 0x70, /* */  0x05, 0x14, 0x74, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_plane4[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x08, 0x18, 0x5f, // 6
  0x08, 0x17, 0x5f, /* */  0x08, 0x16, 0x5f, /* */  0x08, 0x15, 0x5f, // 9
  0x08, 0x14, 0x5f, /* */  0x07, 0x14, 0x5f, /* */  0x06, 0x13, 0x5f, // 12
  0x06, 0x12, 0x5f, /* */  0x06, 0x11, 0x5f, /* */  0x07, 0x10, 0x5f, // 15
  0x08, 0x10, 0x5f, /* */  0x09, 0x10, 0x5f, /* */  0x0a, 0x11, 0x5f, // 18
  0x0a, 0x11, 0x5f, /* */  0x0a, 0x11, 0x5f, /* */  0x0a, 0x12, 0x5f, // 21
  0x0a, 0x11, 0x5f, /* */  0x0a, 0x10, 0x5f, /* */  0x0a, 0x11, 0x5f, // 24
  0x0b, 0x12, 0x5f, /* */  0x0a, 0x13, 0x5f, /* */  0x0a, 0x13, 0x5f, // 27
  0x0a, 0x14, 0x5f, /* */  0x09, 0x14, 0x5f, /* */  0x08, 0x14, 0x5f, // 30
  0x07, 0x14, 0x5f, /* */  0x07, 0x14, 0x71, /* */  0x07, 0x14, 0x75, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_laser1_laser3[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x04, 0x10, 0x6c, /* */  0x04, 0x0e, 0x6c, /* */  0x04, 0x0c, 0x6c, // 15
  0x04, 0x0a, 0x6c, /* */  0x04, 0x08, 0x6c, /* */  0x04, 0x06, 0x6c, // 18
  0x0a, 0x0f, 0x6d, /* */  0x0a, 0x0d, 0x6d, /* */  0x0a, 0x0b, 0x6d, // 21
  0x0a, 0x09, 0x6d, /* */  0x0a, 0x07, 0x6d, /* */  0x0a, 0x05, 0x6d, // 24
  0x0a, 0x03, 0x6d, /* */  0x0a, 0x01, 0x6d, /* */  0x00, 0x00, 0x00, // 27
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 30
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_laser2_laser5[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 15
  0x00, 0x00, 0x00, /* */  0x07, 0x0e, 0x6c, /* */  0x07, 0x0c, 0x6c, // 18
  0x07, 0x0a, 0x6c, /* */  0x07, 0x08, 0x6c, /* */  0x07, 0x06, 0x6c, // 21
  0x07, 0x04, 0x6c, /* */  0x07, 0x02, 0x6c, /* */  0x07, 0x00, 0x6c, // 24
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 27
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x08, 0x12, 0x6d, // 30
  0x08, 0x10, 0x6d, /* */  0x08, 0x0e, 0x6d, /* */  0x00, 0x00, 0x00, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_laser4[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 15
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 18
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x08, 0x10, 0x6c, // 21
  0x08, 0x0e, 0x6c, /* */  0x08, 0x0c, 0x6c, /* */  0x08, 0x0a, 0x6c, // 24
  0x08, 0x08, 0x6c, /* */  0x08, 0x06, 0x6c, /* */  0x08, 0x04, 0x6c, // 27
  0x08, 0x02, 0x6c, /* */  0x08, 0x00, 0x6c, /* */  0x00, 0x00, 0x00, // 30
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_enemy1[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x03, 0x69, // 9
  0x01, 0x04, 0x69, /* */  0x02, 0x05, 0x69, /* */  0x03, 0x05, 0x69, // 12
  0x04, 0x06, 0x69, /* */  0x05, 0x06, 0x69, /* */  0x06, 0x07, 0x69, // 15
  0x07, 0x07, 0x69, /* */  0x08, 0x07, 0x69, /* */  0x09, 0x07, 0x69, // 18
  0x0a, 0x07, 0x69, /* */  0x0b, 0x08, 0x69, /* */  0x0c, 0x09, 0x69, // 21
  0x0c, 0x0a, 0x69, /* */  0x0b, 0x0b, 0x69, /* */  0x0a, 0x0c, 0x69, // 24
  0x09, 0x0c, 0x69, /* */  0x08, 0x0c, 0x69, /* */  0x07, 0x0c, 0x69, // 27
  0x06, 0x0c, 0x69, /* */  0x05, 0x0b, 0x69, /* */  0x04, 0x0a, 0x69, // 30
  0x03, 0x0a, 0x69, /* */  0x02, 0x0a, 0x69, /* */  0x01, 0x0b, 0x69, // 33
  0x00, 0x0c, 0x69, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_enemy2[3*42+1] = 
{
  42,              //  count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x03, 0x69, /* */  0x01, 0x04, 0x69, // 12
  0x02, 0x05, 0x69, /* */  0x03, 0x05, 0x69, /* */  0x04, 0x06, 0x69, // 15
  0x05, 0x06, 0x69, /* */  0x06, 0x07, 0x69, /* */  0x07, 0x07, 0x69, // 18
  0x08, 0x07, 0x69, /* */  0x09, 0x07, 0x69, /* */  0x0a, 0x07, 0x69, // 21
  0x0b, 0x08, 0x69, /* */  0x0c, 0x09, 0x69, /* */  0x0c, 0x0a, 0x69, // 24
  0x0b, 0x0b, 0x69, /* */  0x0a, 0x0c, 0x69, /* */  0x09, 0x0c, 0x69, // 27
  0x08, 0x0c, 0x69, /* */  0x07, 0x0c, 0x69, /* */  0x06, 0x0c, 0x69, // 30
  0x05, 0x0b, 0x69, /* */  0x04, 0x0a, 0x69, /* */  0x03, 0x0a, 0x69, // 33
  0x02, 0x0a, 0x69, /* */  0x01, 0x0b, 0x69, /* */  0x00, 0x0c, 0x69, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_enemy3_bullet5[3*42+1] = 
{
  42,              //  count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x00, 0x03, 0x69, /* */  0x01, 0x04, 0x69, /* */  0x02, 0x05, 0x69, // 15
  0x03, 0x05, 0x69, /* */  0x04, 0x06, 0x69, /* */  0x05, 0x06, 0x6a, // 18
  0x06, 0x07, 0x6b, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 21
  0x00, 0x00, 0x00, /* */  0x0b, 0x0c, 0x60, /* */  0x0b, 0x0d, 0x61, // 24
  0x0b, 0x0e, 0x60, /* */  0x0b, 0x0e, 0x61, /* */  0x0b, 0x0f, 0x60, // 27
  0x0b, 0x11, 0x61, /* */  0x0b, 0x12, 0x60, /* */  0x0b, 0x13, 0x61, // 30
  0x0b, 0x14, 0x60, /* */  0x0b, 0x15, 0x61, /* */  0x0b, 0x16, 0x60, // 33
  0x0b, 0x17, 0x61, /* */  0x0b, 0x18, 0x60, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_enemy4[3*42+1] = 
{
  42,              //  count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x03, 0x69, // 15
  0x01, 0x04, 0x69, /* */  0x02, 0x05, 0x69, /* */  0x03, 0x05, 0x69, // 18
  0x04, 0x06, 0x69, /* */  0x05, 0x06, 0x69, /* */  0x06, 0x07, 0x69, // 21
  0x07, 0x07, 0x69, /* */  0x08, 0x07, 0x69, /* */  0x09, 0x07, 0x69, // 24
  0x0a, 0x07, 0x69, /* */  0x0b, 0x08, 0x69, /* */  0x0c, 0x09, 0x69, // 27
  0x0c, 0x0a, 0x69, /* */  0x0b, 0x0b, 0x69, /* */  0x0a, 0x0c, 0x69, // 30
  0x09, 0x0c, 0x69, /* */  0x08, 0x0c, 0x69, /* */  0x07, 0x0c, 0x6a, // 33
  0x06, 0x0c, 0x6b, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_bullet1_bullet6[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x03, 0x06, 0x60, /* */  0x04, 0x07, 0x61, // 12
  0x05, 0x08, 0x60, /* */  0x06, 0x09, 0x61, /* */  0x07, 0x0a, 0x60, // 15
  0x08, 0x0b, 0x61, /* */  0x09, 0x0c, 0x60, /* */  0x0a, 0x0d, 0x61, // 18
  0x0b, 0x0e, 0x60, /* */  0x0c, 0x0f, 0x61, /* */  0x0d, 0x10, 0x60, // 21
  0x0e, 0x11, 0x61, /* */  0x0f, 0x12, 0x60, /* */  0x10, 0x13, 0x61, // 24
  0x09, 0x0d, 0x60, /* */  0x09, 0x0e, 0x61, /* */  0x09, 0x0f, 0x60, // 27
  0x09, 0x10, 0x61, /* */  0x09, 0x11, 0x60, /* */  0x09, 0x12, 0x61, // 30
  0x09, 0x13, 0x60, /* */  0x09, 0x14, 0x61, /* */  0x09, 0x15, 0x60, // 33
  0x09, 0x16, 0x61, /* */  0x09, 0x17, 0x60, /* */  0x09, 0x18, 0x61, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_bullet2[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x06, 0x08, 0x60, // 15
  0x06, 0x09, 0x61, /* */  0x06, 0x0a, 0x60, /* */  0x06, 0x0b, 0x61, // 18
  0x06, 0x0c, 0x60, /* */  0x06, 0x0d, 0x61, /* */  0x06, 0x0e, 0x60, // 21
  0x06, 0x0f, 0x61, /* */  0x06, 0x10, 0x60, /* */  0x06, 0x11, 0x61, // 24
  0x06, 0x12, 0x60, /* */  0x06, 0x13, 0x61, /* */  0x06, 0x14, 0x60, // 27
  0x06, 0x15, 0x61, /* */  0x06, 0x16, 0x60, /* */  0x06, 0x17, 0x61, // 30
  0x06, 0x18, 0x60, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_bullet3[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 15
  0x05, 0x07, 0x60, /* */  0x05, 0x08, 0x61, /* */  0x05, 0x09, 0x60, // 18
  0x05, 0x0a, 0x61, /* */  0x05, 0x0b, 0x60, /* */  0x05, 0x0c, 0x61, // 21
  0x05, 0x0d, 0x60, /* */  0x05, 0x0e, 0x61, /* */  0x05, 0x0f, 0x60, // 24
  0x05, 0x10, 0x61, /* */  0x05, 0x11, 0x60, /* */  0x05, 0x12, 0x61, // 27
  0x05, 0x13, 0x60, /* */  0x05, 0x14, 0x61, /* */  0x05, 0x15, 0x60, // 30
  0x05, 0x16, 0x61, /* */  0x05, 0x17, 0x60, /* */  0x05, 0x18, 0x61, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};

char tile_ani2_bullet4[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 15
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 18
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x06, 0x07, 0x60, // 21
  0x06, 0x08, 0x61, /* */  0x06, 0x09, 0x60, /* */  0x06, 0x0a, 0x61, // 24
  0x06, 0x0b, 0x60, /* */  0x06, 0x0c, 0x61, /* */  0x06, 0x0d, 0x60, // 27
  0x06, 0x0e, 0x61, /* */  0x06, 0x0f, 0x60, /* */  0x06, 0x10, 0x61, // 30
  0x06, 0x11, 0x60, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};



#if 0

char tile_ani2_template[3*42+1] = 
{
  42,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 1, 2, 3
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 6
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 9
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 12
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 15
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 18
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 21
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 24
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 27
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 30
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 33
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 34, 35, 36
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 39
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, // 40, 41, 42
};
#endif

char tile_grasveld[TILES_BG_SIZE] = 
{
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,

  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,

  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,

  0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
};

char tile_gras1[TILES_BG_SIZE] = 
{
  0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x54, 0x00, 
  0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x54, 0x00, 
  0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x54, 0x00, 
  0x32, 0x32, 0x32, 0x2e, 0x32, 0x32, 0x54, 0x00, 

  0x00, 0x00, 0x00, 0x54, 0x54, 0x54, 0x54, 0x00, 
  0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x4d, 0x4e, 
  0x00, 0x4d, 0x4e, 0x54, 0x00, 0x4d, 0x4e, 0x00, 
  0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 

  0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 
  0x4d, 0x4e, 0x00, 0x00, 0x4d, 0x4e, 0x00, 0x00, 
  0x00, 0x00, 0x57, 0x00, 0x00, 0x4d, 0x4e, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

char tile_gras2[TILES_BG_SIZE] = 
{
  0x43, 0x44, 0x00, 0x00, 0x3f, 0x00, 0x33, 0x00,
  0x45, 0x46, 0x00, 0x00, 0x40, 0x00, 0x33, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00,
  0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x33, 0x00,

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x4c,
  0x00, 0x4b, 0x4c, 0x00, 0x00, 0x4b, 0x4c, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  0x4b, 0x4c, 0x00, 0x00, 0x4b, 0x4c, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x4c, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  0x4c, 0x4b, 0x4c, 0x4b, 0x4c, 0x4b, 0x4c, 0x4b,
};

char tile_grasIII_1[TILES_BG_SIZE] = 
{
  0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 
  0x4d, 0x4e, 0x00, 0x00, 0x4d, 0x4e, 0x00, 0x00, 
  0x00, 0x00, 0x57, 0x00, 0x00, 0x4d, 0x4e, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x54, 0x54, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x32, 0x32, 0x31, 0x32, 0x55, 0x55, 0x00, 0x55, 
  0x31, 0x31, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 

  0x31, 0x31, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 
  0x32, 0x31, 0x32, 0x32, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x4e, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x4e, 0x4d, 

  0x4d, 0x4e, 0x00, 0x00, 0x4d, 0x4e, 0x4d, 0x4e,
};

char tile_grasIII_2[TILES_BG_SIZE] = 
{
  0x4b, 0x4c, 0x00, 0x00, 0x4b, 0x4c, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x4c, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x44, 0x3d, 0x33, 0x00, 0x33, 0x00, 0x00, 0x00, 
  0x46, 0x3e, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 

  0x00, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 
  0x00, 0x33, 0x00, 0x00, 0x33, 0x00, 0x4b, 0x4c, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x4c, 0x4b, 
  0x4b, 0x4c, 0x00, 0x00, 0x4b, 0x4c, 0x4b, 0x4c, 

  0x00, 0x4b, 0x4c, 0x00, 0x00, 0x4b, 0x4c, 0x00, 
};

char tile_anim_intro_tekst[3*34+1] =
{
  34,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x07, 0x01, 0x59, /* */  0x07, 0x01, 0x59, /* */  0x07, 0x01, 0x59,
  0x07, 0x01, 0x59, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,                                          
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
};

char tile_anim_intro_deur1[3*34+1] =
{
  34,              // count
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34,
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34,
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34,
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34,
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34,
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34,
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34,
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34,
  0x04, 0x0c, 0x34, /* */  0x04, 0x0c, 0x34, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,                                          
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,
};

char tile_anim_intro_deur2[3*34+1] =
{
  34,              // count
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34, /* */  0x02, 0x12, 0x34,
  0x02, 0x12, 0x34,
};

char tile_anim_intro_knaap[3*34+1] =
{
  34,              // count
  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, 
  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, //  1,  2,  3
  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, //  4,  5,  6
  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, //  7,  8,  9
  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, // 10, 11, 12
  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, // 13, 14, 15
  0x04, 0x06, 0x07, /* */  0x04, 0x06, 0x07, /* */  0x04, 0x07, 0x1b, // 16, 17, 18
  0x04, 0x08, 0x07, /* */  0x04, 0x08, 0x04, /* */  0x04, 0x08, 0x0a, // 19, 20, 21
  0x04, 0x09, 0x0c, /* */  0x04, 0x0a, 0x0a, /* */  0x04, 0x0b, 0x0b, // 22, 23, 24
  0x04, 0x0c, 0x0a, /* */  0x04, 0x0d, 0x0c, /* */  0x04, 0x0e, 0x0a, // 25, 26, 27
  0x04, 0x0f, 0x0b,                                          
  0x04, 0x10, 0x0a, /* */  0x04, 0x10, 0x01, /* */  0x03, 0x10, 0x02,
};

char tile_anim_intro_meisje[3*34+1] =
{
  34,              // count
  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, 
  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, //  1,  2,  3
  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, //  4,  5,  6
  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, //  7,  8,  9
  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, // 10, 11, 12
  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, // 13, 14, 15
  0x04, 0x02, 0x19, /* */  0x04, 0x02, 0x19, /* */  0x04, 0x03, 0x1b, // 16, 17, 18
  0x04, 0x04, 0x19, /* */  0x04, 0x05, 0x1a, /* */  0x04, 0x06, 0x19, // 19, 20, 21
  0x04, 0x07, 0x1b, /* */  0x04, 0x08, 0x19, /* */  0x04, 0x09, 0x1a, // 22, 23, 24
  0x04, 0x0a, 0x19, /* */  0x04, 0x0b, 0x1b, /* */  0x04, 0x0c, 0x19, // 25, 26, 27
  0x04, 0x0d, 0x1a, /* */  0x04, 0x0e, 0x19, /* */  0x04, 0x0f, 0x1b, // 28, 29, 30
  0x04, 0x10, 0x19, /* */                                             // 31
};

char tile_anim_intro_robotter[3*34+1] =
{
  34,              // count
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, 
  0x0e, 0x00, 0x1f, /* */  0x0d, 0x00, 0x20, /* */  0x0c, 0x00, 0x1f, //  1,  2,  3
  0x0b, 0x00, 0x21, /* */  0x0a, 0x00, 0x1f, /* */  0x09, 0x00, 0x20, //  4,  5,  6
  0x08, 0x00, 0x1f, /* */  0x07, 0x00, 0x21, /* */  0x06, 0x00, 0x1f, //  7,  8,  9
  0x06, 0x00, 0x28, /* */  0x06, 0x01, 0x29, /* */  0x06, 0x02, 0x28, // 10, 11, 12
  0x06, 0x02, 0x28, /* */  0x06, 0x02, 0x28, /* */  0x06, 0x02, 0x28, // 13, 14, 15
  0x06, 0x02, 0x28, /* */  0x06, 0x02, 0x28, /* */  0x06, 0x03, 0x29, // 16, 17, 18
  0x06, 0x04, 0x28, /* */  0x06, 0x05, 0x2a, /* */  0x06, 0x06, 0x28, // 19, 20, 21
  0x06, 0x07, 0x29, /* */  0x06, 0x08, 0x28, /* */  0x06, 0x08, 0x1f, // 22, 23, 24
  0x05, 0x08, 0x20, /* */  0x04, 0x08, 0x1f, /* */  0x04, 0x08, 0x28, // 25, 26, 27
  0x04, 0x09, 0x2a, /* */  0x04, 0x0a, 0x28, /* */  0x04, 0x0b, 0x29, // 28, 29, 30
  0x04, 0x0c, 0x28, /* */                                             // 31
};

char tile_anim_chase_knaap[3*52+1] =
{
  52,              // count
  0x02, 0x10, 0x01, /* */  0x02, 0x10, 0x0a, /* */  0x02, 0x11, 0x0b,
  0x02, 0x12, 0x0a, /* */  0x02, 0x13, 0x0c, /* */  0x02, 0x14, 0x0a,
  0x02, 0x14, 0x04, /* */  0x03, 0x14, 0x05, /* */  0x04, 0x14, 0x04,
  0x05, 0x14, 0x06, /* */  0x06, 0x14, 0x04, /* */  0x07, 0x14, 0x05,
  0x08, 0x14, 0x04, /* */  0x09, 0x14, 0x06, /* */  0x0a, 0x14, 0x04,
  0x0a, 0x14, 0x07, /* */  0x0a, 0x13, 0x08, /* */  0x0a, 0x12, 0x07,
  0x0a, 0x11, 0x09, /* */  0x0a, 0x10, 0x07, /* */  0x0a, 0x10, 0x04,
  0x0b, 0x10, 0x05, /* */  0x0c, 0x10, 0x04, /* */  0x0c, 0x10, 0x07,
  0x0c, 0x0f, 0x08, /* */  0x0c, 0x0e, 0x07, /* */  0x0c, 0x0d, 0x09,
  0x0c, 0x0c, 0x07, /* */  0x0c, 0x0b, 0x08, /* */  0x0c, 0x0a, 0x07,
  0x0c, 0x09, 0x09, /* */  0x0c, 0x08, 0x07, /* */  0x0c, 0x08, 0x01,
  0x0b, 0x08, 0x02, /* */  0x0a, 0x08, 0x01, /* */  0x09, 0x08, 0x03,
  0x08, 0x08, 0x01, /* */  0x07, 0x08, 0x02, /* */  0x06, 0x08, 0x01,
  0x05, 0x08, 0x03, /* */  0x04, 0x08, 0x01, /* */  0x04, 0x08, 0x0a,
  0x04, 0x09, 0x0c, /* */  0x04, 0x0a, 0x0a, /* */  0x04, 0x0b, 0x0b,
  0x04, 0x0c, 0x0a, /* */  0x04, 0x0d, 0x0c, /* */  0x04, 0x0e, 0x0a,
  0x04, 0x0f, 0x0b,                                          
  0x04, 0x10, 0x0a, /* */  0x04, 0x10, 0x01, /* */  0x03, 0x10, 0x02,
};

char tile_anim_chase_meisje[3*52+1] =
{
  52,              // count
  0x04, 0x10, 0x10, /* */  0x03, 0x10, 0x11, /* */  0x02, 0x10, 0x10,
  0x02, 0x10, 0x19, /* */  0x02, 0x11, 0x1a, /* */  0x02, 0x12, 0x19,
  0x02, 0x13, 0x1b, /* */  0x02, 0x14, 0x19, /* */  0x02, 0x14, 0x13,
  0x03, 0x14, 0x14, /* */  0x04, 0x14, 0x13, /* */  0x05, 0x14, 0x15,
  0x06, 0x14, 0x13, /* */  0x07, 0x14, 0x14, /* */  0x08, 0x14, 0x13,
  0x09, 0x14, 0x15, /* */  0x0a, 0x14, 0x13, /* */  0x0a, 0x14, 0x16,
  0x0a, 0x13, 0x17, /* */  0x0a, 0x12, 0x16, /* */  0x0a, 0x11, 0x18,
  0x0a, 0x10, 0x16, /* */  0x0a, 0x10, 0x13, /* */  0x0b, 0x10, 0x14,
  0x0c, 0x10, 0x13, /* */  0x0c, 0x10, 0x16, /* */  0x0c, 0x0f, 0x17,
  0x0c, 0x0e, 0x16, /* */  0x0c, 0x0d, 0x18, /* */  0x0c, 0x0c, 0x16,
  0x0c, 0x0b, 0x17, /* */  0x0c, 0x0a, 0x16, /* */  0x0c, 0x09, 0x18,
  0x0c, 0x08, 0x16, /* */  0x0c, 0x08, 0x10, /* */  0x0b, 0x08, 0x11,
  0x0a, 0x08, 0x10, /* */  0x09, 0x08, 0x12, /* */  0x08, 0x08, 0x10,
  0x07, 0x08, 0x11, /* */  0x06, 0x08, 0x10, /* */  0x05, 0x08, 0x12,
  0x04, 0x08, 0x10, /* */  0x04, 0x08, 0x19, /* */  0x04, 0x09, 0x1b,
  0x04, 0x0a, 0x19, /* */  0x04, 0x0b, 0x1a, /* */  0x04, 0x0c, 0x19,
  0x04, 0x0d, 0x1b,                                         
  0x04, 0x0e, 0x19, /* */  0x04, 0x0f, 0x1a, /* */  0x04, 0x10, 0x19,
};

char tile_anim_chase_robotter[3*52+1] =
{
  52,              // count
  0x04, 0x0d, 0x2a, /* */  0x04, 0x0e, 0x28, /* */  0x04, 0x0f, 0x29,
  0x04, 0x10, 0x28, /* */  0x04, 0x10, 0x1f, /* */  0x03, 0x10, 0x20,
  0x02, 0x10, 0x1f, /* */  0x02, 0x10, 0x28, /* */  0x02, 0x11, 0x29,
  0x02, 0x12, 0x28, /* */  0x02, 0x13, 0x2a, /* */  0x02, 0x14, 0x28,
  0x02, 0x14, 0x22, /* */  0x03, 0x14, 0x23, /* */  0x04, 0x14, 0x22,
  0x05, 0x14, 0x24, /* */  0x06, 0x14, 0x22, /* */  0x07, 0x14, 0x23,
  0x08, 0x14, 0x22, /* */  0x09, 0x14, 0x24, /* */  0x0a, 0x14, 0x22,
  0x0a, 0x14, 0x25, /* */  0x0a, 0x13, 0x26, /* */  0x0a, 0x12, 0x25,
  0x0a, 0x11, 0x27, /* */  0x0a, 0x10, 0x25, /* */  0x0a, 0x10, 0x22,
  0x0b, 0x10, 0x23, /* */  0x0c, 0x10, 0x22, /* */  0x0c, 0x10, 0x25,
  0x0c, 0x0f, 0x26, /* */  0x0c, 0x0e, 0x25, /* */  0x0c, 0x0d, 0x27,
  0x0c, 0x0c, 0x25, /* */  0x0c, 0x0b, 0x26, /* */  0x0c, 0x0a, 0x25,
  0x0c, 0x09, 0x27, /* */  0x0c, 0x08, 0x25, /* */  0x0c, 0x08, 0x1f,
  0x0b, 0x08, 0x20, /* */  0x0a, 0x08, 0x1f, /* */  0x09, 0x08, 0x21,
  0x08, 0x08, 0x1f, /* */  0x07, 0x08, 0x20, /* */  0x06, 0x08, 0x1f,
  0x05, 0x08, 0x21, /* */  0x04, 0x08, 0x1f, /* */  0x04, 0x08, 0x28,
  0x04, 0x09, 0x2a, /* */                                   
  0x04, 0x0a, 0x28, /* */  0x04, 0x0b, 0x29, /* */  0x04, 0x0c, 0x28,
};



/* x, y, tile 
   the x and y are actually twice as large - i.e. characters
   move 0.5 tiles at a time.
*/
char tile_anim_koelkast_en_deur[3*73+1] =
{
  73,              // count        aaaaaaaaaargh. 73 frames. *sigh*
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  //  1,  2,  3,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  //  4,  5,  6,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  //  7,  8,  9,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 10, 11, 12,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 13, 14, 15,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 16, 17, 18,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 19, 20, 21,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 22, 23, 24,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 25, 26, 27,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 28, 29, 30,
  0x06, 0x06, 0x34, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 31, 32, 33,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 34, 35, 36,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 37, 38, 39,
  0x08, 0x00, 0x41, /* */  0x08, 0x00, 0x41, /* */  0x08, 0x00, 0x41,  // 40, 41, 42,
  0x08, 0x00, 0x41, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 43, 44, 45,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 46, 47, 48,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x06, 0x06, 0x34,  // 49, 50, 51,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 52, 53, 54,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 55, 56, 57,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 58, 59, 60,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 61, 62, 63,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 64, 65, 66,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 67, 68, 69,
  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34, /* */  0x06, 0x06, 0x34,  // 70, 71, 72,
  0x06, 0x06, 0x34                                                     // 73
};

char tile_anim_koelkast[3*73+1] =
{
  73,              // count        aaaaaaaaaargh. 73 frames. *sigh*
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  //  1,  2,  3,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  //  4,  5,  6,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  //  7,  8,  9,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 10, 11, 12,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 13, 14, 15,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 16, 17, 18,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 19, 20, 21,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 22, 23, 24,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 25, 26, 27,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 28, 29, 30,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 31, 32, 33,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 34, 35, 36,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 37, 38, 39,
  0x08, 0x02, 0x42, /* */  0x08, 0x02, 0x42, /* */  0x08, 0x02, 0x42,  // 40, 41, 42,
  0x08, 0x02, 0x42, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 43, 44, 45,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 46, 47, 48,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 49, 50, 51,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 52, 53, 54,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 55, 56, 57,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 58, 59, 60,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 61, 62, 63,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 64, 65, 66,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 67, 68, 69,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 70, 71, 72,
  0x00, 0x00, 0x00                                                     // 73
};

char tile_anim_meisje[3*73+1] =
{
  73,              // count        aaaaaaaaaargh. 73 frames. *sigh*
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  //  1,  2,  3,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x1a, /* */  0x04, 0x12, 0x1a,  //  4,  5,  6,
  0x04, 0x12, 0x1a, /* */  0x04, 0x12, 0x1a, /* */  0x04, 0x12, 0x1a,  //  7,  8,  9,
  0x04, 0x12, 0x1a, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 10, 11, 12,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 13, 14, 15,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 16, 17, 18,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 19, 20, 21,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 22, 23, 24,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 25, 26, 27,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 28, 29, 30,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 31, 32, 33,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 34, 35, 36,
  0x04, 0x12, 0x14, /* */  0x04, 0x12, 0x18, /* */  0x04, 0x12, 0x16,  // 37, 38, 39,
  0x04, 0x12, 0x16, /* */  0x04, 0x12, 0x16, /* */  0x04, 0x12, 0x16,  // 40, 41, 42,
  0x04, 0x12, 0x16, /* */  0x04, 0x12, 0x16, /* */  0x04, 0x12, 0x13,  // 43, 44, 45,
  0x04, 0x12, 0x1a, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 46, 47, 48,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 49, 50, 51,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 52, 53, 54,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 55, 56, 57,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 58, 59, 60,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 61, 62, 63,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 64, 65, 66,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 67, 68, 69,
  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19, /* */  0x04, 0x12, 0x19,  // 70, 71, 72,
  0x04, 0x12, 0x19                                                     // 73
};

char tile_anim_knaapje[3*73+1] =
{
  73,              // count        aaaaaaaaaargh. 73 frames. *sigh*
  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07,  //  1,  2,  3,
  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07,  //  4,  5,  6,
  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07,  //  7,  8,  9,
  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07,  // 10, 11, 12,
  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x04, /* */  0x05, 0x16, 0x05,  // 13, 14, 15,
  0x06, 0x16, 0x04, /* */  0x06, 0x16, 0x07, /* */  0x06, 0x15, 0x08,  // 16, 17, 18,
  0x06, 0x14, 0x07, /* */  0x06, 0x13, 0x09, /* */  0x06, 0x12, 0x07,  // 19, 20, 21,
  0x06, 0x11, 0x08, /* */  0x06, 0x10, 0x07, /* */  0x06, 0x0f, 0x09,  // 22, 23, 24,
  0x06, 0x0e, 0x07, /* */  0x06, 0x0d, 0x08, /* */  0x06, 0x0c, 0x07,  // 25, 26, 27,
  0x06, 0x0b, 0x09, /* */  0x06, 0x0a, 0x07, /* */  0x06, 0x09, 0x08,  // 28, 29, 30,
  0x06, 0x08, 0x07, /* */  0x06, 0x07, 0x09, /* */  0x06, 0x06, 0x07,  // 31, 32, 33,
  0x06, 0x05, 0x08, /* */  0x06, 0x04, 0x07, /* */  0x06, 0x04, 0x04,  // 34, 35, 36,
  0x07, 0x04, 0x05, /* */  0x08, 0x04, 0x04, /* */  0x08, 0x04, 0x08,  // 37, 38, 39,
  0x08, 0x03, 0x07, /* */  0x08, 0x03, 0x07, /* */  0x08, 0x03, 0x08,  // 40, 41, 42,
  0x08, 0x03, 0x07, /* */  0x08, 0x03, 0x01, /* */  0x07, 0x03, 0x02,  // 43, 44, 45,
  0x06, 0x03, 0x01, /* */  0x06, 0x03, 0x0a, /* */  0x06, 0x04, 0x0b,  // 46, 47, 48,
  0x06, 0x05, 0x0a, /* */  0x06, 0x06, 0x0c, /* */  0x06, 0x07, 0x0a,  // 49, 50, 51,
  0x06, 0x08, 0x0b, /* */  0x06, 0x09, 0x0a, /* */  0x06, 0x0a, 0x0c,  // 52, 53, 54,
  0x06, 0x0b, 0x0a, /* */  0x06, 0x0c, 0x0b, /* */  0x06, 0x0d, 0x0a,  // 55, 56, 57,
  0x06, 0x0e, 0x0c, /* */  0x06, 0x0f, 0x0a, /* */  0x06, 0x10, 0x0b,  // 58, 59, 60,
  0x06, 0x11, 0x0a, /* */  0x06, 0x12, 0x0c, /* */  0x06, 0x13, 0x0a,  // 61, 62, 63,
  0x06, 0x14, 0x0b, /* */  0x06, 0x15, 0x0a, /* */  0x06, 0x16, 0x0c,  // 64, 65, 66,
  0x06, 0x16, 0x01, /* */  0x05, 0x16, 0x02, /* */  0x04, 0x16, 0x01,  // 67, 68, 69,
  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07, /* */  0x04, 0x16, 0x07,  // 70, 71, 72,
  0x04, 0x16, 0x07                                                     // 73
};

char tile_anim_tekst[3*73+1] =
{
  73,              // count        aaaaaaaaaargh. 73 frames. *sigh*
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x05, 0x11, 0x5a,  //  1,  2,  3,
  0x05, 0x11, 0x5b, /* */  0x05, 0x11, 0x5a, /* */  0x05, 0x11, 0x5b,  //  4,  5,  6,
  0x00, 0x00, 0x00, /* */  0x05, 0x15, 0x58, /* */  0x05, 0x15, 0x58,  //  7,  8,  9,
  0x00, 0x00, 0x00, /* */  0x05, 0x11, 0x5b, /* */  0x05, 0x11, 0x5a,  // 10, 11, 12,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 13, 14, 15,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 16, 17, 18,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 19, 20, 21,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 22, 23, 24,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 25, 26, 27,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 28, 29, 30,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 31, 32, 33,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 34, 35, 36,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 37, 38, 39,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 40, 41, 42,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 43, 44, 45,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 46, 47, 48,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 49, 50, 51,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 52, 53, 54,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 55, 56, 57,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 58, 59, 60,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 61, 62, 63,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 64, 65, 66,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 67, 68, 69,
  0x00, 0x00, 0x00, /* */  0x05, 0x15, 0x59, /* */  0x05, 0x15, 0x59,  // 70, 71, 72,
  0x00, 0x00, 0x00                                                     // 73
};


#if 0
char tile_anim_template[3*73+1] =
{
  73,              // count        aaaaaaaaaargh. 73 frames. *sigh*
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  //  1,  2,  3,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  //  4,  5,  6,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  //  7,  8,  9,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 10, 11, 12,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 13, 14, 15,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 16, 17, 18,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 19, 20, 21,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 22, 23, 24,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 25, 26, 27,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 28, 29, 30,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 31, 32, 33,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 34, 35, 36,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 37, 38, 39,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 40, 41, 42,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 43, 44, 45,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 46, 47, 48,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 49, 50, 51,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 52, 53, 54,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 55, 56, 57,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 58, 59, 60,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 61, 62, 63,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 64, 65, 66,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 67, 68, 69,
  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00, /* */  0x00, 0x00, 0x00,  // 70, 71, 72,
  0x00, 0x00, 0x00                                                     // 73
};
#endif






#endif  // _TILES_H_






