#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
        location <24, 2, -14>
        look_at <3, 6, -9>
} 

light_source { <-50, 21, -20> color White }

light_source { <-10, 20, -20> color White jitter }

light_source { <18, 3, -11> color OrangeRed jitter }

light_source { <17.5, 2, -9> color OrangeRed jitter }

light_source { <17.5, 5.5, -13> color OrangeRed jitter }

light_source { <17.5, 4.5, -13> color OrangeRed jitter }

light_source { <15, 4.5, -13> color OrangeRed jitter }

light_source { <15, 2.5, -9> color OrangeRed jitter }

light_source { <15, 3.5, -13> color OrangeRed jitter }

fog { rgb <0.01, 0.01, .1> distance 100 }

object {
 Plane_XZ
 pigment { Blue }
 translate <0, 20, 0>
 hollow
 normal {
  bumps 2.0
 }
 finish {
  specular 1
  roughness 0.001
  phong 2.0
  phong_size 150
  reflection 0.25
  ambient 0.3
  diffuse 0.1
 }
}

height_field {
 gif               
 "korkeus.gif"     
 scale <280, 50, 280>
 translate <-220, -27, -80>
 pigment { DarkBrown }
 smooth
 normal {
  bumps 0.4
 }
 finish {
  phong 0.3
  phong_size 15
  ambient 0
 }
}

//runko
object {
 Disk_X
 pigment { Black }
 scale <13, 1.5, 1.5>
 translate <4.5, 5, -9>
 finish {
  specular 0.5
  ambient 0.1
  reflection 0.1
 }
}

//per
object {
 Sphere
 pigment { Black }
 scale 1.5
 translate <3, 5, -9> 
 finish {
  specular 0.5
  ambient 0.1
  reflection 0.1
 }
}

//persin
object {
 Disk_Z
 pigment { Black }
 scale <0.5, 0.2, 2.5>
 translate <-6, 4.75, -9>
 finish {
  specular 0.5
  ambient 0.1
  reflection 0.1
 }
}

object {
 Disk_Y
 pigment { Black }
 scale <0.5, 0.75, 0.2>
 translate <-6, 4.75, -11.5>
 finish {
  specular 0.5
  ambient 0.1
  reflection 0.1
 }
}

object {
 Disk_Y
 pigment { Black }
 scale <0.5, 0.75, 0.2>
 translate <-6, 4.75, -6.5>
 finish {
  specular 0.5
  ambient 0.1
  reflection 0.1
 }
}

//torni
object {
 Disk_Y
 pigment { Black }
 scale <2, 1.2, 1.2>
 translate <8, 7, -9>
 finish {
  specular 0.5
  ambient 0.1
  reflection 0.1
 }
}

object {
 Disk_Y
 pigment { Black }
 scale <0.05, 1, 0.05>
 translate <8.5, 9, -9>
 finish {
  specular 0.5
  ambient 0.1
  reflection 0.1
 }
}

object {
 Disk_Y
 pigment { Black }
 scale <0.05, 0.8, 0.05>
 translate <7.5, 9, -9>
 finish {
  specular 0.5
  ambient 0.1
  reflection 0.1
 }
}

//keula
difference {
 
 object {
  Sphere
  pigment { Black }
  scale 1.5
  translate <17.5, 5, -9>
  finish {
   specular 0.5
   ambient 0.1
   reflection 0.1
  }
 }
 
 object {
  Disk_X
  scale <0.6, 0.15, 0.15>
  translate <19, 5 , -10>
  finish {
    specular 0.5
    ambient 0.1
    reflection 0.1  
  }
 }
 
 object {
  Disk_X
  scale <0.6, 0.15, 0.15>
  translate <19, 5 , -8>
  finish {
   specular 0.5
   ambient 0.1
   reflection 0.1  
  }
 }
}

//rjhdys
#declare tuli =
color_map {
 [0.0 color Yellow transmit .4]
 [0.8 color OrangeRed transmit .7]
 [1.0 color Orange transmit .4]
}

object {
 Sphere
 scale 1.1
 translate <17.5, 4.25, -9.75>
 hollow
 pigment {  
  marble
  turbulence 2
  color_map { tuli }
 }  
 normal {
  bumps 0.5
 }
 finish {
  phong 1
  phong_size 10
  ambient 1.8
  specular 0.1
 }
}

//teksti
text {
 ttf "crystal.ttf", "SSN 688",
 1,
 0 
 scale 0.6 
 pigment { White }
 translate <14, 4.8, -10.5>
 finish {
  reflection 0
  specular 0  
 }
}
