TITLE GoGO
%out "Gogo - Arroutada 2000. Daioros (c)"
;
; This intro works in a 286!!!!!!!!!!!!!!!!!!!!!
; Well, really i don't know... i supposse
;

.MODEL LARGE
.286

include INCLUDE.INC

;-----------------------------------------------------------------
;       EQUATES
;-----------------------------------------------------------------
Length_SS               EQU       020h
VGASeg                  EQU     0A000h
WaitSeconds             EQU     00060d
NoPalette               EQU      0200d
Quarter1                EQU     00000h
Quarter2                EQU     04040h
Quarter3                EQU     08080h
Quarter4                EQU     0C0C0h
Colors1                 EQU     00000h
Colors2                 EQU     00808h
Colors3                 EQU     01010h
Colors4                 EQU     01818h
Colors5                 EQU     02020h
Colors6                 EQU     02828h
Colors7                 EQU     03030h
Colors8                 EQU     03838h
Lines_Flakes_Creating   EQU     00125d
Number_Flakes           EQU     02500d          ;Good number for MY 286 at 12Mhz
Max_Flakes_Creating     EQU     Number_Flakes / Lines_Flakes_Creating
Color_Flake             EQU     040h AND 07fh
Snow_Color              EQU     0ffh
Shade_Color             EQU     0feh
Number_of_matches       EQU     01d
Number_Stars            EQU     01fffh/010h - 1 ;Maximum 0ffffh/010h = 0fffh
NumPixLet               EQU     0256d

;-----------------------------------------------------------------
;       STRUCTURES
;-----------------------------------------------------------------
Flake   STRUC
        pos     dw      ?
        oldpix  db      ?
        value   dw      ?
Flake   ENDS


Color   STRUC
        red     db      ?
        green   db      ?
        blue    db      ?
Color   ENDS


Star    STRUC
        X       db        00h
        Y       db        00h
        Z       db        00h
        P1      dw      0000h
        P2      dw      0000h
        P3      dw      0000h
        P4      dw      0000h
Star    ENDS


PixLet  STRUC
        Loc     dw      ?
        FinLoc  dw      ?
        PDec    dw      ?
        Part    dw      ?
        FgColor db      ?
        BgColor db      ?
        Living  dw      ?
PixLet  ENDS



;-----------------------------------------------------------------
;-----------------------------------------------------------------
;------ S T A C K   S E G M E N T --------------------------------
;-----------------------------------------------------------------
.STACK  010h * length_SS           ;For XMS memory. Not needed



;-----------------------------------------------------------------
;-----------------------------------------------------------------
;------ D A T A   S E G M E N T ----------------------------------
;-----------------------------------------------------------------
.DATA

;
;Mem Blocks
;
Text_Screen_Ptr dw      ?
Font            dw      ?
Ptr_Init_Pal    dw      ?
Flakes_Ptr      dw      ?
Fire_Ptr        dw      ?
Block1          dw      ?
Block2          dw      ?
Block3          dw      ?
Block4          dw      ?
Block5          dw      ?
Block6          dw      ?
Block7          dw      ?
Block8          dw      ?

;
;Text Screen Data
;
Init_cursor_x   db      ?
Init_cursor_y   db      ?
Txt_lines       db      00h


;
;texts
;
txt_copyright   db      'GoGo - Arroutada 2000. (C) Daioros.', nl, nl, 00h
txt_win_start   db      nl, 09h, 'Arroutada 2000',09,09,09,09h,'Super G O G O oool...',09, 09h,00h
txt_no286       db      nl, 'ERROR: No 286+ CPU.',00h
txt_noVGA       db      nl, 'ERROR: No VGA.',00h
txt_continue    db      nl, 'Errors encountered. Continue anyway (Y/N)?',00h
txt_win_found   db      nl, nl, 'Windoze found. Formatting then hard disk. Please wait...',00h
txt_a_joke      db      nl, nl, '.',nl,'..', nl,'Just a joke.',nl,'Push any key',00h
txt_more_joke   db      nl, nl,'Sorry, i said the key "ANY"',00h
txt_not_windows db      nl, 'Windows not found. This demo requires M$-WayOfLife.', nl, 'Formatting hard disk for installing...',00h
txt_SB_found    db      nl, 'Sound Blaster compatible card at: ', 00h
txt_not_alloc   db      nl, 'Cannot allocate memory. Panic!!!',00h
txt_cagando     db      nl, nl, nl, nl, nl, nl, nl, 09h,09h,'Cagando...',00h
txt_wall        db      nl, '**************************************'
                db      nl, '*  Arroutada Party in Corunha        *'
                db      nl, '*      20-22 October 2000            *'
                db      nl, '*     "U will always remember it,    *'
                db      nl, '*       (... or not!)                *'
                db      nl, '*      But U will love it            *'
                db      nl, '**************************************',00h,00h

nude_girl       db      nl, '           _--==          '
                db      nl, '          /    \          '
                db      nl, '          //---\\          '
                db      nl, '          |/O O \|         '
                db      nl, '           \ *  /|         '
                db      nl, '           \\()//          '
                db      nl, '         /--\--/--\        '
                db      nl, '        |  \.  . / |       '
                db      nl, '         \\ \ X / //       '
                db      nl, '          \\ \ / //        '
                db      nl, '     +=================+   '
                db      nl, '     #                 #   '
                db      nl, '     #  c e n s u r a  #   '
                db      nl, '     #                 #   '
                db      nl, '     +=================+   '
                db      nl, '           \ |/  /         '
                db      nl, '            \ / /          '
                db      nl, '            |< <           '
                db      nl, '            ||\ \          '
                db      nl, '            || ooo         '
                db      nl, '           ooo             ', 00h,00h

simple_girl     db      nl, '       -----------    '
                db      nl, '      /-#-#------     '
                db      nl, '     //---------      '
                db      nl, '     |/o o ----       '
                db      nl, '      \ -  ---        '
                db      nl, '      \\__/           '
                db      nl, '    .--\--/--.        '
                db      nl, '    |       |\        '
                db      nl, '    ||=@--@=/\\       '
                db      nl, '    ||\    /  \\      '
                db      nl, '    || |  |    \@@@@  '
                db      nl, '    // /  \    @@@@@@ '
                db      nl, ' @@// *----*   @@@@@@ '
                db      nl, '@@@@@ |\##/ )   @@@@  '
                db      nl, '@@@@@ | \/  |         '
                db      nl, '@@@@  | |\  |         '
                db      nl, '      \ | \ \___.     '
                db      nl, '      / |  \____o     '
                db      nl, '      | |       o     '
                db      nl, '      ||              '
                db      nl, '      ||              '
                db      nl, '     ooo              ', 00h,00h

firepal label byte
 db 00, 00, 00
 db 00, 00, 03
 db 00, 00, 06
 db 03, 00, 09
 db 06, 00, 12
 db 09, 00, 09
 db 12, 00, 08
 db 15, 00, 07
 db 18, 00, 06
 db 21, 00, 05
 db 24, 00, 04
 db 27, 00, 03
 db 30, 02, 02
 db 33, 04, 01
 db 36, 06, 00
 db 39, 08, 00
 db 42, 10, 00
 db 45, 12, 00
 db 48, 14, 00
 db 51, 16, 00
 db 54, 18, 00
 db 57, 20, 00
 db 60, 22, 00
 db 63, 24, 00
 db 63, 26, 00
 db 63, 28, 00
 db 63, 30, 00
 db 63, 32, 00
 db 63, 34, 00
 db 63, 36, 00
 db 63, 38, 00
 db 63, 40, 00
 db 63, 42, 00
 db 63, 44, 00
 db 63, 46, 00
 db 63, 48, 00
 db 63, 50, 00
 db 63, 52, 00
 db 63, 54, 00
 db 63, 56, 00
 db 63, 58, 00
 db 63, 60, 00
 db 63, 62, 00
 db 63, 63, 03
 db 63, 63, 06
 db 63, 63, 09
 db 63, 63, 12
 db 63, 63, 15
 db 63, 63, 18
 db 63, 63, 21
 db 63, 63, 24
 db 63, 63, 27
 db 63, 63, 30
 db 63, 63, 33
 db 63, 63, 36
 db 63, 63, 39
 db 63, 63, 42
 db 63, 63, 45
 db 63, 63, 48
 db 63, 63, 51
 db 63, 63, 54
 db 63, 63, 57
 db 63, 63, 60
 db 63, 63, 63

holepal label byte
 db  00, 00, 00
 db  63, 63, 63
 db  63, 63, 60
 db  63, 63, 57
 db  63, 63, 54
 db  63, 63, 51
 db  63, 63, 48
 db  63, 63, 45
 db  63, 63, 42
 db  63, 63, 39
 db  63, 63, 36
 db  63, 63, 33
 db  63, 63, 30
 db  63, 63, 27
 db  63, 63, 24
 db  63, 63, 21
 db  63, 63, 18
 db  63, 63, 15
 db  63, 63, 12
 db  63, 63, 09
 db  63, 63, 06
 db  63, 63, 03
 db  63, 61, 00
 db  63, 59, 00
 db  63, 57, 00
 db  63, 55, 00
 db  63, 53, 00
 db  63, 51, 00
 db  63, 49, 00
 db  63, 47, 00
 db  63, 45, 00
 db  63, 43, 00
 db  63, 41, 00
 db  63, 39, 00
 db  63, 37, 00
 db  63, 35, 00
 db  63, 33, 00
 db  63, 31, 00
 db  63, 29, 00
 db  63, 27, 00
 db  63, 25, 00
 db  63, 23, 00
 db  63, 21, 00
 db  61, 19, 00
 db  59, 17, 00
 db  57, 15, 00
 db  55, 13, 00
 db  53, 11, 00
 db  51, 09, 00
 db  49, 07, 00
 db  47, 05, 00
 db  45, 03, 00
 db  43, 01, 00
 db  41, 00, 00
 db  39, 00, 00
 db  37, 00, 00
 db  35, 00, 00
 db  33, 00, 00
 db  31, 00, 00
 db  29, 00, 00
 db  25, 00, 00
 db  22, 00, 00
 db  14, 00, 00
 db  07, 00, 15


;
;Miscellaneous
;
Hardware_Error  dw      0000h
Exit            dw      0000h
Hex_Tbl         db      '0123456789ABCDEF'
RandSeed1       dw      01234h
RandSeed2       dw      05678h
RandSeed3       dw      09abch
AvanceTexto     dw      0000h

;
;SB Data
;
SB              dw      ?
SBAdress        dw      ?
SBIRQ           dw      ?
SBDMA           dw      ?



;-----------------------------------------------------------------
;-----------------------------------------------------------------
;------ C O D E   S E G M E N T ----------------------------------
;-----------------------------------------------------------------
.CODE
;Ŀ
; Procedure principal (main of C)                       
;
Inicio  PROC
        P&p     @DATA, ds
        assume  ds:@DATA

        call Resize_prg

        push    @DATA OFFSET txt_copyright
        call Ver_txt

        call Sub1rowCursor

        call Test_Hardware         

        jnc @@well_hardware
        push    @DATA OFFSET txt_continue
        call Ver_txt
        cmp     ah, 015h
        je @@well_hardware
        jmp short @@end_inicio

@@well_hardware:

comment #
        mov     ax, 0160ah
        int 02fh
        or      ax, ax
        jnz @@not_windowsf
        push    @DATA OFFSET txt_win_found
        jmp short @@win_common
@@not_windowsf:
        push    @DATA OFFSET txt_not_windows
@@win_common:
        call Ver_txt
        PCall Seconds, 0005h
        push    @DATA OFFSET txt_a_joke
        call Ver_txt
        PCall Seconds, 0002h
        call Kbhit
        push    @DATA OFFSET txt_more_joke
        call Ver_txt
        PCall Seconds, 0002h
#

@@not_windows:
        call Save_Text_Screen

;;;
        mov     ax, 0160ah
        int 02fh
        or      ax, ax
        jnz @@not_windowsf
        push    @DATA OFFSET txt_win_found
        jmp short @@win_common
@@not_windowsf:
        push    @DATA OFFSET txt_not_windows
@@win_common:
        call Ver_txt
        PCall Seconds, 0005h
        push    @DATA OFFSET txt_a_joke
        call Ver_txt
        PCall Seconds, 0002h
        call Kbhit
        push    @DATA OFFSET txt_more_joke
        call Ver_txt
        PCall Seconds, 0002h
;;;


        call DemoStart

        mov     ax, 0013h
        int 010h

        stop

        call Make_Ini
;        call Make_Hello
        call Make_Stone
;        call Make_Fire
;        call Make_Hole
;        call Make_Snow


@@end_inicio:
        call Restore_Init_Screen
        PCall Free_alloc, Font

        push @DATA OFFSET nude_girl
        PCall Ver_txt

        mov     ax, 04c00h
        int 021h
Inicio  ENDP


;Ŀ
; Hardware check                                        
;
Test_hardware   PROC    NEAR

;
; Tests CPU, if it's a 8086 or 8088
;
        mov     dx, sp
        P&p     sp, ax
        cmp     ax, dx
        je @@test_VGA
        push    @DATA OFFSET txt_no286
        call Ver_txt
        mov     Hardware_Error, TRUE

;
;Tests if there is a VGA card installed
;
;Another way to test VGA
;        mov ax,01a00h
;        int 010h
;        cmp al, 07h
;        jb NO_VGA  (if al=7, VGA monochrome; if al=08, VGA color)
;
@@test_VGA:
        mov     ax, 01a00h
        int 010h
        cmp     al, 01ah
        je @@3rdtest
        push    @DATA OFFSET txt_noVGA
        call Ver_txt
        mov     Hardware_Error, TRUE

;
;Tests if there is a soundcard compatible SB (& base port)
; NOT NEEDED FOR THIS PARTY
;
@@3rdtest:
        xor     dx, dx
        mov     SBAdress, dx
        mov     SBIRQ, dx
        mov     SBDMA, dx
        mov     SB, dx
        mov     dx, 0210h
@@test_new_addres:
        add     dx, 06h
        mov     al, 1
        out     dx, al
        mov     cx, 0100d
@@wait1_first:
        loop @@wait1_first
        xor     al, al
        out     dx, al
        mov     cx, 0100d
        add     dx, 0eh - 06h
@@wait2_first:
        in      al, dx
        sub     dx, 0eh - 0ah
        in      al, dx
        cmp     al, 0aah
        je @@found_SB
        add     dx, 04h
        loop @@wait2_first
        and     dx, 0ff0h
        add     dx, 010h
        cmp     dx, 0290h
        jb @@test_new_addres
        jmp short @@fin_test_SB
@@found_SB:
        and     dx, 0ff0h
        mov     SBAdress, dx
        push    dx
        mov     SB, TRUE

;
; NOT NEEEDED FOR THIS INTRO
;
COMMENT #
        push    @DATA OFFSET txt_SB_found
        call Ver_txt
        pop     dx
        PCall Write_Value, dx
#
@@fin_test_SB:


@@end_test_hardware:
        retn
Test_hardware   ENDP

;Ŀ
; Display texts (in DX goes direction; i suppose @DATA) 
;Entry:  Segment  -   Offset    of ASCIIZ run           
;          0006h       0004h                            
;Return: Nothing                                        
;
Ver_txt         PROC    NEAR
        push    bp
        mov     bp, sp
        push    ax bx si ds

        mov     si, w [bp + 0006h]
        mov     ds, si
        mov     si, w [bp + 0004h]

        mov     ah, 0Eh
        xor     bx, bx
@@next_char:
        lodsb
        test    al, al
        jz @@end_text
        int 010h
        jmp short @@next_char

@@end_text:
        pop     ds si bx ax
        pop     bp
        retn    0004h
Ver_txt         ENDP


;Ŀ
; Display texts (in DX goes direction; i suppose @DATA) 
;Entry:  Segment  -   Offset    of ASCIIZ run           
;          0006h       0004h                            
;Return: Nothing                                        
;
Ver_txt2         PROC    NEAR
        push    bp
        mov     bp, sp
        push    ax bx si ds

        mov     si, w [bp + 0006h]
        mov     ds, si
        mov     si, w [bp + 0004h]

        mov     ah, 0Eh
        xor     bx, bx
@@next_char2:
        lodsb
        test    al, al
        jz @@end_text2
        cmp     al, 09h
        jne @@nada_texto2

        push cx
        mov cx, AvanceTexto
@@proximoAvance:
        mov     al, 09h
        int 10h
        loop @@proximoAvance
        pop cx

@@nada_texto2:
        int 010h
        jmp short @@next_char2

@@end_text2:
        pop     ds si bx ax
        pop     bp
        retn    0004h
Ver_txt2         ENDP



;Ŀ
; Display grf   (in DX goes direction; i suppose @DATA) 
;Entry:  Segment  -   Offset    of ASCIIZ run           
;          0006h       0004h                            
;Return: Nothing                                        
;
Ver_grf         PROC    NEAR
        push    bp
        mov     bp, sp
        push    ax bx si dx ds

        mov     si, w [bp + 0006h]
        mov     ds, si
        mov     si, w [bp + 0004h]


        PCall SetOneColor, 3f1fh, 1f00h       ;(03fh*256) SNOW COLOR
        mov ah, 02h
@@next_charg:
        lodsb
        test    al, al
        jz @@end_textg
        mov     dl, al
        int 021h                        ;;;010h

        jmp short @@next_charg

        call kbhit

@@end_textg:
        pop     ds dx si bx ax
        pop     bp
        retn    0004h
Ver_grf         ENDP

;Ŀ
; Display grf   (in DX goes direction; i suppose @DATA) 
;Entry:  Segment  -   Offset    of ASCIIZ run           
;          0006h       0004h                            
;Return: Nothing                                        
;
Ver_grf1        PROC    NEAR
        push    bp
        mov     bp, sp
        push    ax bx si dx ds

        mov     si, w [bp + 0006h]
        mov     ds, si
        mov     si, w [bp + 0004h]


        PCall SetOneColor, 3f00h, 0000h       ;(03fh*256) SNOW COLOR
        mov ah, 02h
@@next_charg1:
        lodsb
        test    al, al
        jz @@end_textg1
        mov     dl, al
        int 021h                        ;;;010h

        jmp short @@next_charg1

        call kbhit

@@end_textg1:
        pop     ds dx si bx ax
        pop     bp
        retn    0004h
Ver_grf1        ENDP



;Ŀ
; Writes given value in HEX                             
;  [bp+04h] --> Value                                   
;
Write_Value     PROC    NEAR
        push    bp
        mov     bp, sp

        push    ax bx
        lea     bx, hex_tbl

        mov     ax, [bp + 04h]
        rol     ax, 04h
        and     al, 0fh
        xlat
        PCall Write_Char, ax

        mov     ax, [bp + 04h]
        mov     al, ah
        and     al, 0fh
        xlat
        PCall Write_char, ax

        mov     ax, [bp + 04h]
        shr     ax, 04h
        and     al, 0fh
        xlat
        PCall Write_char, ax

        mov     ax, [bp + 04h]
        and     ax, 000fh
        xlat
        PCall Write_char, ax

        pop     bx ax
        pop     bp
        retn    0002
Write_Value     ENDP

;Ŀ
; Writes characters passed by Stack                     
;
Write_char      PROC    NEAR
        push    bp
        mov     bp, sp

        push    ax dx

        mov     dx, [bp + 04h]
        mov     ah, 02h
        int 021h

        pop     dx ax

        pop     bp
        retn    0002
Write_char      ENDP

;Ŀ
; Substract one row to actual cursor position           
;
Sub1rowCursor   PROC    NEAR
        pusha
        mov     ah, 03h         ;Get Cursor position
        xor     bh, bh
        int 010h
        dec     dh
        ;sub     dh, 02h
        dec     ah
        int 010h
        popa
        retn
Sub1rowCursor   ENDP

;Ŀ
;  Alloc memory needed for pointers                     
; Input:    N of paragraphs                            
;                 BX                                    
; Return:   AX (Segment ready)                          
;
Alloc_mem       PROC NEAR
        push    bp
        mov     bp, sp

        push    cx di es bx dx

        mov     bx, [bp + 04h]
        mov     ah, 048h
        int 021h
        jnc @@clear_alloc_mem
        mov     ax, 0003h
        int 010h
        mov     ax, 01112h
        xor     bl, bl
        int 010h
        push    @DATA OFFSET txt_not_alloc
        call Ver_txt
        shr     w [bp + 04h], 06h
        push    w [bp + 04h]
        call    Write_value
        mov     ax, 04c01h
        int 021h
@@clear_alloc_mem:
        push    ax
        mov     es, ax
        xor     di, di
        mov     cx, w [bp+04h]
        shl     cx, 03h                 ;(CX*16)/2
        xor     ax, ax
        rep stosw
        pop     ax

        pop     dx bx es di cx

        pop     bp
        retn    02h
Alloc_mem       ENDP

;Ŀ
;  Free-Alloc memory                                    
; Input:       Block to de-allocate                     
;                      ES                               
; Return:      Nothing                                  
;
Free_alloc      PROC NEAR
        push    bp
        mov     bp, sp

        push    ax es
        mov     ah, 049h
        mov     es, [bp + 04h]
        int 021h
        pop     es ax

        pop     bp
        retn    0002h
Free_alloc      ENDP


;Ŀ
; Save Text Screen                                      
;
Save_Text_Screen        PROC    NEAR
        push    ds
        mov     ah, 0fh         ;Get video mode
        int 010h
        cmp     al, 03h
        jne @@no_text_mode
        mov     ah, 03h         ;Read cursor position
        int 010h
;
;Get cursor position
;
        mov     Init_cursor_y, dh
        mov     Init_cursor_x, dl
;
;Get number of lines in screen
;
        mov     ax, 01130h
        mov     bh, 03h
        int 010h
        mov     b Txt_lines, dl

;
;Get Text mode screen to restore
;
        PCall Alloc_mem, 0501d          ;8000d/16d + 01d
        mov     Text_Screen_Ptr, ax
        mov     es, ax
        xor     di, di
        P&p     0b800h, ds
        assume  ds:nothing
        xor     si, si
        mov     cx, 08000d
        rep     movsb

        mov     ax, @DATA
        mov     ds, ax
        mov     es, ax
        assume  ds:@DATA

MemInitPal = ((256*3)/16) + 1
        PCall Alloc_mem, MemInitPal
        mov     Ptr_Init_Pal, ax
;
;Get palette of text cursor mode
;
        mov     dx, 03c7h       ;DAC Read Address
        xor     al, al          ;starting color to read
        out     dx, al
        mov     cx, 256 * 3     ;It could be enough with 32 colors...
        mov     di, w Ptr_Init_Pal
        mov     es, di
        xor     di, di
        mov     dx, 03c9h       ;PEL Data Register
        rep insb

@@no_text_mode:
        pop     ds
        retn
Save_Text_Screen        ENDP


;Ŀ
; Wait Retrace (Vertical)                               
;
WaitRetrace     PROC    NEAR
        push    dx ax
        mov     ah, BIT3
        mov     dx,3DAh
@@nvr:
        in      al, dx                   ; port 3DAh, CGA/EGA vid status
        test    al, ah
        jnz @@nvr                        ; Jump if not zero
@@vr:
        in      al, dx                   ; port 3DAh, CGA/EGA vid status
        test    al, ah
        jz  @@vr                         ; Jump if zero
        pop     ax dx
        ret
WaitRetrace     ENDP

;Ŀ
; Resize Program for allocating memory                  
;
Resize_prg      PROC    NEAR
        push    ax es bx
        mov     ah, 051h                ;Get Current PSP Segment
        int 021h
        mov     es, bx
        mov     ax, bx
        mov     bx, ss
        sub     bx, ax
        add     bx, length_SS + 1       ;Length in paragraphs
        mov     ah, 04ah                ;SetBlock
        int 021h
        pop     bx es ax
        ret
Resize_prg      ENDP

;Ŀ
; Restore Initial Screen                                
;
Restore_Init_Screen     PROC    NEAR
;
;Restore text mode
;
        mov     ax, 0003h
        int 010h
        cmp     Txt_lines, 00h          ;Not Mode 03h
        je @@not_restore_init_scr
        cmp     Txt_lines, 031h         ;50 lines?
        jne @@not_50lines
        mov     ax, 01112h              ;Duplicate lines
        xor     bx, bx
        int 010h
@@not_50lines:

;
;All palette first to black for fading up
;
        mov     dx, 03c8h       ;DAC Write Register
        xor     al, al
        out     dx, al
        mov     cx, 256 * 3
        xor     al, al
        inc     dx              ;DX = 03c9h
@@loop_black1:
        out     dx, al
        loop @@loop_black1

;
;Restore screen
;
        P&p     0b800h, es
        xor     di, di
        mov     ds, w Text_Screen_Ptr
        assume  ds:nothing
        xor     si, si
        mov     cx, 04000d
        rep movsw

        P&p     @DATA, ds
        assume  ds:@DATA
        PCall Free_Alloc, Text_Screen_Ptr

;
;Restore cursor position
;
        mov     dh, Init_cursor_y
        mov     dl, Init_cursor_x
        xor     bx, bx
        mov     ah, 02h                 ;Set cursor position
        int 010h

;
;Restore palette
;
        push    w Ptr_Init_Pal
        push    00000h
        Call FadeUp2Pal

        cmp     w Exit, 0001h
        jae @@not_restore_init_scr

comment #
        push @DATA OFFSET simple_girl
        PCall Ver_txt
#

        call Copper_FG

@@not_restore_init_scr:
        PCall Free_alloc, Ptr_Init_Pal
        call Clear_KB
        retn
Restore_Init_Screen     ENDP

;Ŀ
; Make Snow Falling                                     
;
Make_Snow       PROC    NEAR
        PCall SetOneColor, 03f3fh, 03fffh       ;(03fh*256) SNOW COLOR
        PCall SetOneColor, 03f3fh, 03f40h       ;(03fh*40h) FLAKE COLOR
        PCall SetOneColor, 00000h, 000feh       ;(000h*feh) SHADE COLOR

Mem_for_Flakes = ((size flake * Number_Flakes) / 016d) + 01d
        PCall   Alloc_Mem, Mem_for_Flakes
        mov     Flakes_Ptr, ax

        push    ds
        mov     es, ax
        mov     ds, ax
        assume  ds:nothing
        xor     di, di

        mov     ax, 0ff83h              ;00a0h - 00126h
        mov     cx, Number_Flakes       ;(Number_Flakes * size flake)/2
@@init_snow1:
        stosw
        stosw
        stosb
        loop @@init_snow1




        P&p     VGASeg, es
        mov     ah, 10000000b
        xor     dx, dx
        mov     cx, WaitSeconds * 066d
@@next_frame:
        push    cx
        call KbBlink 
        call WaitRetrace
        xor     si, si                          ;1st flake
        xor     dx, dx                          ;Flakes created
        call Test_positions
        pop     cx
        dec     cx
        jz @@end_snow
        mov     ah, 1
        int 16h
        jz @@next_frame

@@end_snow:
        pop     ds
        assume  ds:@DATA
        PCall Free_Alloc, Flakes_Ptr
;;        PCall Free_Alloc, Block1
        call UnSet_KB

        call ReStart
        ret
Make_Snow       ENDP

;Ŀ
; Test_Positions of Flakes                              
;
Test_positions  PROC    NEAR
        mov     cx, Number_flakes
@@next_flake:
        mov     di, si.[pos]
        cmp     si.[oldpix], Color_Flake
        je @@not_bg_col
        mov     al, b si.[oldpix]
        mov     b es:[di], al                   ;stosb

@@not_bg_col:
        mov     ah, 10000000b
        test    b es:[di+320], ah
        jz @@320
        test    b es:[di + 319], ah
        jz @@no320_319
        test    b es:[di + 321], ah
        jz @@321_fijo
        mov     b es:[di], Snow_Color
        call Create_another_flake
        jmp short @@display_flake
@@321_fijo:
        add     w si.[pos], 321d
        jmp short @@display_flake
@@no320_319:
        test    b es:[di+321], ah
        jz @@321_fijo
@@319_fijo:
        add     w si.[pos], 319d
        jmp short @@display_flake
@@320:
        ror     w si.[value], 1
        jnc @@nocarry
        ror     w si.[value], 1
        jnc @@carry_nocarry
        add     w si.[pos], 320d          ;11 Down
        jmp short @@display_flake
@@carry_nocarry:
        test    b es:[di + 319], ah
        jz @@319_fijo                   ;01 Left
        add     w si.[pos], 320d
        jmp short @@display_flake
@@nocarry:
        ror     w si.[value], 1
        jnc @@nocarry_nocarry
        test    b es:[di+321], ah
        jz @@321_fijo                   ;10 Right
        add     w si.[pos], 320d
        jmp short @@display_flake
@@nocarry_nocarry:
        test    b es:[di+640], ah
        jz @@640_fijo
        add     w si.[pos], 320d
        jmp short @@display_flake
@@640_fijo:                             ;00 Down-Down
        add     w si.[pos], 640d
        jmp short @@display_flake

@@display_flake:
        mov     di, w si.[pos]                  ;Screen pixel in DI
        mov     al, b es:[di]  
        mov     b si.[oldpix], al
        mov     b es:[di], Color_Flake
;;        mov     al, Color_Flake
;;        stosb

        add     si, size Flake
        dec     cx
        jz @@end_test_positions
        jmp @@next_flake

@@end_test_positions:
        ret
Test_positions   ENDP

;Ŀ
; Creates another flake                                 
;
Create_another_flake    PROC    NEAR
        push    ax
        cmp     dx, Max_Flakes_Creating
        jae @@not_more_creating_now
        inc     dx

@@another_rnd:
        call Random
        and     ax, 0000000111111111b   ;3
        cmp     ax, 320d                ;3
        jae @@another_rnd               ;3 + 7+m

        mov     w si.[pos], ax
        mov     b si.[oldpix], 00h
        call Random

        test    al, 003h
        jz @@quick_flake
        mov     ah, 00011011b
        mov     w si.[value], ax
        pop     ax
        ret

@@quick_flake:
        mov     w si.[value], 0010000000010000b
        pop     ax
        ret

@@not_more_creating_now:
        mov     w si.[pos], (320*198) - 1               ;Out of screen
        mov     b si.[oldpix], Snow_Color
        pop     ax
        ret
Create_another_flake    ENDP


;Ŀ
; Clear all variables, screen, kb... ALL                
;
ReStart PROC    NEAR
        call Fade2Black
        call ZeroScr
        call Clear_KB
        call Clear_Reg
        retn
ReStart ENDP



;Ŀ
; Returns a random number in AX                         
;
Random  PROC    NEAR
        push    bx bp ds                ;3*3

        mov     ax, @DATA               ;2
        mov     ds, ax                  ;2
        P&p     @DATA, ds
        assume  ds:@DATA

        mov     ax, [RandSeed1]         ;5
        mov     bx, [RandSeed2]         ;5
        mov     bp, [RandSeed3]         ;5
        add     ax, 0a137h              ;3
        add     bx, 063f7h              ;3
        add     bp, 0784ah              ;3
        rol     ax, 1                   ;2
        rol     ax, 1                   ;2
        mov     [RandSeed1], ax         ;3
        add     bx, ax                  ;2
        ror     bx, 1                   ;2
        mov     [RandSeed2], bx         ;3
        sub     bp, bx                  ;2
        xor     ax, bp                  ;2
        mov     [RandSeed3], bp         ;2
        add     ax, bx                  ;2

        pop     ds bp bx                ;5*3
        ret                             ;11+m   TOTAL = 85 + m
Random  ENDP

;Ŀ
; KeyBoard Blinking (only funny)                        
;
KbBlink PROC    NEAR
        push    ds bx cx

        P&p     0000h, ds
        mov     bx, 0417h
        mov     cl, b [bx]
        cmp     cl, 32d
        je @@next_kb_64
        cmp     cl, 64
        je @@next_kb_16
        cmp     cl, 16
        je @@next_kb_00
        mov     b [bx], BIT5 
        pop     cx bx ds
        ret

@@next_kb_64:
        mov     b [bx], BIT6 
        pop     cx bx ds
        ret

@@next_kb_00:
        mov     b [bx], 00h
        pop     cx bx ds
        ret

@@next_kb_16:
        mov     b [bx], BIT4 
        pop     cx bx ds
        ret
KbBlink ENDP

;Ŀ
; Unset stupid keyboard change                          
;
Unset_KB        PROC    NEAR
        push    ds bx
        P&p     0000h, ds
        mov     bx, 0417h
        and     b [bx], 10001111b
        or      b [bx], 00100000b       ;Only NumLock active :-)
        pop     bx ds
        ret
Unset_KB        ENDP

;Ŀ
; Make stupids coppers bars in text mode                
;
Copper_FG  PROC    NEAR
        push    dx cx bx ax
        mov     cx, 04ffh               ;1024 times

        mov ax,3
        int 10
        mov ax,1112h
        int 10

@@next_copper:
        cli                             ;3 ticks
        inc     bx                      ;2 ticks
        push    cx bx di                ;3*2 ticks
        mov     cx, 0400d               ;400 lines  - 3 ticks
        call WaitRetrace                ;7 + m + too much
        mov     di, 03c9h
@@AnotherColor:
        mov     dx, 03c8h               ;3 ticks        SELECT COLOR
        xor     al, al                  ;2 ticks ;color 0
        out     dx, al                  ;3 ticks

        inc     bl                      ;2 ticks
        and     bl, 01111111b           ;3 ticks
        test    bl, 01000000b           ;3 ticks
        jz @@dec_col                    ;7 + m
        mov     bh, bl                  ;2 ticks
        and     bh, 03fh                ;3 ticks
        jmp short @@AnotherHR           ;7+m ticks
@@dec_col:
        mov     bh, 03fh                ;3 ticks
        sub     bh, bl                  ;2 ticks

@@AnotherHR:
        mov     dx, 03dah               ;3 ticks  --- no HR in action now
@@noHR2:                                ;
        in      al, dx                  ;5 ticks
        ror     al, 1                   ;2 ticks
        jnc @@noHR2                     ;7+m ticks

        mov     dx, di                  ;2 ticks DX= 03c9h, setcolor
        mov     al, bh                  ;2 ticks
        out     dx, al                  ;3 ticks        RED
        xor     al, al                  ;2 ticks
        out     dx, al                  ;3 ticks        GREEN
        out     dx, al                  ;2 ticks        BLUE

;
;wait now until no-HR. Now it's really really quick :)
;
        mov     dx, 03dah               ;wait until HR
@@HR2:
        in      al, dx
        ror     al, 1
        jc @@HR2

        loop @@AnotherColor             ;4 / 8+m ticks
        PCall SetOneColor, 0000h, 0000h ;3 + 3 +  7+m  +  68+m
        sti                             ;2 ticks


        mov     ax,03h
        int 10h
        mov     AvanceTexto, cx
        and     cx, 0007h
        push @DATA OFFSET simple_girl
        PCall Ver_txt2

        call WaitRetrace


        pop     di bx cx                ;5 + 5 ticks
        mov     ah, 1                   ;3 ticks
        int 016h
        jnz @@end_bg_copper             ;3 / 7+m ticks
        loop @@next_copper              ;4 / 8+m ticks

@@end_bg_copper:
        pop     ax bx cx dx             ; 5 + 5 + 5 + 5 ticks
        ret                             ;11+m ticks
Copper_FG  ENDP


;Ŀ
; Wait until Horizontal Retrace                         
;                                                       
; Why i don't use this PROC ?  Coz it's too slow to     
; speed requirements (286 at 12Mhz). So i must insert   
; this in the PROCEDURE that needs it.                  
; Here, it only shows how it could be.                  
;
WaitHRetrace    PROC    NEAR
        push    dx ax
        mov     dx, 03dah
@@noHR:
        in      al, dx
        ror     al, 1
        jnc @@noHR
@@HR:
        in      al, dx
        ror     al, 1
        jc @@HR

        pop     ax dx
        ret
WaitHRetrace    ENDP

;Ŀ
; Set one VGA palette color                             
; Input:    <byte-byte> <byte-byte>                     
;           <blue-green><red--color>                    
; Output: Nothing                                       
;
SetOneColor     PROC    NEAR            ;TOTAL = 68+m
        push    bp                      ;3 ticks
        mov     bp, sp                  ;2 ticks
        push    dx ax                   ;3 + 3 ticks

        mov     dx, 03c8h               ;3 ticks
        mov     ax, w [bp + 04h]        ;5 ticks
        out     dx, al                  ;3 ticks
        inc     dx                      ;2 ticks
        mov     al, ah                  ;2 ticks
        out     dx, al                  ;3 ticks
        mov     ax, w [bp + 06h]        ;5 ticks
        out     dx, al                  ;3 ticks
        mov     al, ah                  ;2 ticks
        out     dx, al                  ;3 ticks

        pop     ax dx bp                ;5 + 5 + 5 ticks
        ret 0004h                       ;11+m
SetOneColor     ENDP

;Ŀ
;      Fade all palette to black                        
; Entry:  Nothing                                       
; Return: Nothing                                       
;
Fade2Black      PROC    NEAR
        push    ax bx cx dx si ds es

        PCall Alloc_mem, 49d            ;(768/16)+1
        mov     es, ax          ;Segment of temporary data palette
        xor     di, di
        mov     dx, 03c7h       ;DAC Read Address
        xor     al, al          ;starting color to read
        out     dx, al
        mov     cx, 256 * 3
        mov     dx, 03c9h       ;PEL Data Register
        rep insb

        mov     bh, 63d          ;Maximum 64 times
@@loop_pal_max:
        P&p     es, ds
        xor     si, si
        mov     cx, 256d * 03d
@@next_value_pal:
        cmp     b [si], 00
        jbe @@no_dec
        dec     b [si]
@@no_dec:
        inc     si
        loop @@next_value_pal

        mov     dx, 03c8h       ;DAC Write Register
        xor     al, al          ;starting color to write
        out     dx, al
        inc     dx              ;DX = 03c9h, PEL Data Register
        P&p     es, ds
        xor     si, si
        mov     cx, 256 * 3
        call WaitRetrace
        rep outsb
        dec     bh
        jnz @@loop_pal_max

        PCall Free_alloc, es

        pop     es ds si dx cx bx ax
        ret
Fade2Black      ENDP

;Ŀ
;   Fade to a given palette                             
; Entry:    segment:offset of palette                   
; Return: Nothing                                       
;
FadeUp2Pal        PROC    NEAR
        push    bp
        mov     bp, sp
        push    ax bx cx dx si ds

        xor     bh, bh
        mov     si, w [bp + 06h]
        mov     ds, si
@@loop_up_pal:
        mov     si, w [bp + 04h]
        mov     dx, 03c8h
        xor     al, al
        out     dx, al                  ;starting at 1st color
        mov     cx, 256 * 03d
        inc     dx
        call WaitRetrace
@@one_pal_up:
        lodsb
        cmp     al, bh
        jnae @@no_xchg1
        mov     al, bh
@@no_xchg1:
        out     dx, al
        loop @@one_pal_up
        inc     bh
        cmp     bh, 064d
        jb @@loop_up_pal

        pop     ds si dx cx bx ax
        pop     bp
        ret 0004h
FadeUp2Pal        ENDP

;Ŀ
;   Make a stone wall (blue) ;-)  Like Wolf-3D          
;
Make_Stone      PROC    NEAR
        call Fade2Black

        P&p     VGASeg, es
        xor     di, di
        xor     ax, ax
        xor     cx, cx                  ;Optimizable

        mov     al, 0ffh
        stosb
        stosb
        stosb

        xor     dx, dx
        mov     cx, 321d - 03d
@@1stLine:
        call Random
        or      al, 11000000b
        xor     ah, ah
        xor     dx, dx

        mov     bx, w es:[di-3]

        mov     dl, bl
        add     ax, dx
        mov     dl, bh
        add     ax, dx
        mov     dl, b es:[di-1]
        add     ax, dx
        shr     ax, 1
        shr     ax, 1
        stosb
        loop @@1stLine

        mov     cx, 64000d - 321d
@@another_pixel:
        call Random
        or      al, 11000000b
        xor     ah, ah
        xor     dx, dx
        mov     dl, b es:[di-320d]
        add     ax, dx
        shr     ax, 1
        mov     dl, b es:[di-319d]
        add     ax, dx
        mov     dl, b es:[di-321d]
        add     ax, dx
        mov     dl, b es:[di-001d]
        add     ax, dx
        shr     ax, 1
        shr     ax, 1

        stosb
        loop @@another_pixel

        call SetPalStone


        PCall Alloc_mem, 0FA1h          ;0FA1h = 0fa00h + 1
        mov     Block1, ax

MASK1 = Quarter2 OR Colors7

        push    0001h @DATA
        push    OFFSET Txt_wall
        push    Block1 0000h Quarter1
        Call VGAFont

MemPixLet = ((NumPixLet * size PixLet) / 16 )+ 1
        PCall Alloc_mem, MemPixLet
        mov     Block2, ax

        call Pre_PixLet
        P&p     VGASeg, es
        xor     dx, dx                  ;DX = Scanner pixel
        mov     cx, WaitSeconds*08d
@@until_kbhit_stone:
        push cx
        call WaitRetrace

        stop
        cmp     cx, WaitSeconds*05-1
        jne @@no_titulo_stone
        push    @DATA OFFSET txt_win_start
        call Ver_grf1
@@no_titulo_stone:

        pop cx
        mov     ah, 1
        int 016h
        jnz @@end_stone1
        loop @@until_kbhit_stone

@@end_stone1:

        PCall Free_Alloc, Block1
        PCall Free_Alloc, Block2
;;;;
        call ReStart
        ret
Make_Stone      ENDP

;Ŀ
;      Palette for stone wall (192-255 colors)          
;
SetPalStone PROC    NEAR
        push    dx ax cx

        mov     dx, 03c8h
        mov     al, 0255d - 064d
        out     dx, al
        inc     dx
        mov     cx, 00064d
@@setpal1:
        mov     al, cl
        dec     al
        xor     al, al
        out     dx, al
        out     dx, al
        mov     al, cl
        out     dx, al
        loop @@setpal1

        pop     cx ax dx
        ret
SetPalStone ENDP


;Ŀ
;      Fire routine Main                                
;
Make_Fire       PROC    NEAR
        PCall Alloc_Mem, 04001d                 ;(64000/16)+1
        mov     Block2, ax

        PCall Alloc_Mem, 135d                ;(((64+3)*32)/16)+1
        mov     Fire_Ptr, ax
        mov     es, ax

        push    @DATA
        push    OFFSET firepal
        push    Quarter1 064d
        call SetXPalette

        mov     cx, WaitSeconds * 010d
@@until_kbhit_fire:
        push    cx
        mov     ax, w Block2
        mov     es, ax
        call    Fire

;
;Put sprite
;
        assume  ds:@DATA
;        PCall Decode64, Block1, NoPalette, Block2, 29550, Quarter2

;
;Dump screen
;
        push    ds
        P&p     es, ds
        P&p     0A000h, es
        xor     si, si
        xor     di, di
        mov     cx, 64000/2
        call WaitRetrace
        rep movsw
        pop     ds

        pop     cx
        dec     cx
        jz @@end_make_fire
        mov     ah, 1
        int 16h
        jz @@until_kbhit_fire

@@end_make_fire:
        PCall Free_alloc, Fire_Ptr
        PCall Free_alloc, Block1
        PCall Free_alloc, Block2

        call ReStart
        ret
Make_Fire       ENDP


;Ŀ
;      Make Fire itself                                 
;                                                       
; I duplicate lines and pixels (2x3). And 'repeat'      
; each fire pixel 5 times around frame.                 
;
Fire    PROC    NEAR
        push    ds
        mov     ds, w Fire_Ptr
        mov     cx, 32/2
;        xor     ax, ax
        mov     si, 65 * 32
@@clear_first_line:
        call Random
        and     ax, 03f3fh
        or      ax,0000111100001111b
        mov     w [si], ax
        mov     w [si+32], ax
        add     si, 0002h
        loop @@clear_first_line

        mov     cx, Number_of_matches
@@another_rnd_fire:
        call Random
        and     ax, 001fh                       ;31d
        mov     si, 65 * 32
        add     si, ax
        mov     w [si + 00], 03f3fh           ;Fire_Color
        mov     w [si + 02], 03f3fh
        mov     w [si + 04], 03f3fh
        mov     w [si + 32], 03f3fh
        mov     w [si + 34], 03f3fh
        mov     w [si + 36], 03f3fh
        mov     w [si - 32], 03f3fh
        mov     w [si - 34], 03f3fh
        mov     w [si - 36], 03f3fh
        loop @@another_rnd_fire

;
;Advance fire
;
        mov     si, 064d
        mov     cx, 2048d               ;Number of pixels in buffer (32*100)
@@another_buffer_pixel:
        lodsb
        add     al, b [si + 30d]
        add     al, b [si + 31d]
        add     al, b [si + 32d]
        shr     al, 1
        shr     al, 1
        jz @@no_dec_fire
        dec     al
@@no_dec_fire:
        mov     b [si - 33d], al
        loop @@Another_Buffer_Pixel

;
;Duplicate fire pixels
;
        mov     si, 32d
        xor     di, di                  ;2
        mov     dx, 00064d              ;3      ;64 lines of buffer
@@AnotherLine:
        mov     cx, 00032d              ;3      ;((320/2)/5) = 32
        mov     bx, di                  ;2      ;BX = Another ptr of pixel
        add     bx, 00126d              ;3      ;64 + 64(end of part) - 2(word)
@@AnotherPix:
        mov     al, b [si]              ;5      ;Load pixel of buffer lodsb
        mov     ah, al                  ;2      ;For word
        mov     es:[di+000+128], ax     ;3      ;3rd part, 1st line
        mov     es:[di+000+256], ax     ;3      ;5th part, 1st line
        mov     es:[di+000+320], ax     ;3      ;1st part, 2nd line
        mov     es:[di+128+320], ax     ;3      ;3rd part, 2nd line
        mov     es:[di+256+320], ax     ;3      ;5th part, 2nd line
        mov     es:[di+000+640], ax     ;3      ;1st part, 3rd line
        mov     es:[di+128+640], ax     ;3      ;3rd part, 3rd line
        mov     es:[di+256+640], ax     ;3      ;5th part, 3rd line

        mov     es:[bx+000+000], ax     ;3      ;2nd part, 1st line
        mov     es:[bx+000+128], ax     ;3      ;4th part, 1st line
        mov     es:[bx+000+320], ax     ;3      ;2nd part, 2nd line
        mov     es:[bx+128+320], ax     ;3      ;4th part, 2nd line
        mov     es:[bx+000+640], ax     ;3      ;2nd part, 3rd line
        mov     es:[bx+128+640], ax     ;3      ;4th part, 3rd line

        stosw                           ;3      ;1nd part, 1st line
        sub     bx, 0002h               ;3
        inc     si                      ;2
        loop @@AnotherPix               ;13-4   ;End of line (32 buffer)?
        add     di, (0320*3) - 64d      ;3      ;Point to next screen pixel
        dec     dx                      ;2      ;End of 100 lines?
        jnz @@AnotherLine               ;10-3

        pop     ds
        ret
Fire    ENDP

;Ŀ
;Set palette for 'x' colors                             
;Entry:  Segment - Offset - Starting Color - NumberColor
;           0A       08          06            04       
;Output: Nothing                                        
;
SetXPalette  PROC    NEAR
        push    bp
        mov     bp, sp
        push    dx ax cx ds si

        mov     dx, 03c8h
        mov     ax, w [bp + 06h]
        out     dx, al
        inc     dx
        mov     si, w [bp + 0Ah]
        mov     ds, si
        mov     cx, w [bp + 04h]
        mov     si, cx
        shl     cx, 1
        add     cx, si                  ;CX*3
        mov     si, w [bp + 08h]
        rep outsb

        pop     si ds cx ax dx
        pop     bp
        ret 0008h
SetXPalette  ENDP

;Ŀ
;                                                       
;
Make_INI  PROC    NEAR
        assume  ds:@DATA
        call Fade2Black

        call INI2ndPal


        push    @DATA OFFSET txt_cagando
        call Ver_grf

        
        mov     dl, 032d+32d
        mov     cx, WaitSeconds * 002d
        P&p     0A000h, es
@@cicles_logo:
        push    cx
        mov     di, 320*(200-5)
        PCall Retraces, 0005h
        mov     cx, 0005h               ;Lines
@@restLineLogo:
        push    cx
        mov     al, dl
        mov     cx, 40d
@@1stLineLogo:
        push    cx
        and     al, 01fh
        mov     ah, al
        or      ax, Quarter2
        mov     cx, 0004h
        rep stosw
        inc     al
        pop     cx
        loop @@1stLineLogo
        pop     cx
        loop @@restLineLogo
        pop     cx
        dec     dl

        mov     ah, 1
        int 16h
        jnz @@end_w98logo

        loop @@cicles_logo

@@end_w98logo:
        PCall Free_alloc, Block1

;;        call ReStart
        call Clear_KB
        call ZeroScr
        ret
Make_INi  ENDP


;Ŀ
; Zero screen                                           
;
ZeroScr PROC    NEAR
        push    ax cx di es
        p&p     VGASeg, es
        xor     di, di
        xor     ax, ax
        mov     cx, 64000/2
        rep stosw
        pop es di cx ax
        retn
ZeroScr ENDP

;Ŀ
; Keyboard Hit                                          
;
KbHit   PROC    NEAR
        push    ax
        xor     ah, ah
        int 016h
        pop     ax
        ret
KbHit   ENDP

;Ŀ
; Wait n retraces                                       
; Entry =  [bp +04h] --> Number of retraces             
; Return= Nothing                                       
;
Retraces        PROC    NEAR
        push    bp
        mov     bp, sp

        push    cx
        mov     cx, w [bp+04h]
@@next_retrace:
        call WaitRetrace
        loop @@next_retrace
        pop     cx

        pop     bp
        retn 0002h
Retraces        ENDP

;Ŀ
; Wait n seconds                                        
; Entry =  [bp +04h] --> Number of seconds              
; Return= Nothing                                       
;
Seconds         PROC    NEAR
        push    bp
        mov     bp, sp

        push    cx
        mov     cx, w [bp+04h]
        shl     cx, 06h
@@next_second:
        call WaitRetrace
        loop @@next_second
        pop     cx

        pop     bp
        retn 0002h
Seconds         ENDP


;Ŀ
; Second pal part in W98 Logo                           
;
INI2ndPal PROC    NEAR
        mov     dx, 03c8h
        mov     al, 064d
        out     dx, al
        inc     dx

        mov     cx, 016d
@@logopal1:
        mov     al, 064d
        sub     al, cl
        sub     al, cl
        sub     al, cl
        sub     al, cl
        out     dx, al
        out     dx, al
        mov     al, 03fh
        out     dx, al
        loop @@logopal1

        mov     cx, 016d
@@logopal2:
        mov     al, cl
        dec     al
        add     al, cl
        add     al, cl
        add     al, cl
        out     dx, al
        out     dx, al
        mov     al, 03fh
        out     dx, al
        loop @@logopal2

        ret
INI2ndPal ENDP



;Ŀ
; Txt of starting W98: the marvellous OS                
;
DemoStart      PROC    NEAR
        push    ax cx

        call Fade2Black

        pop     cx ax
        ret
DemoStart      ENDP




;Ŀ
; Make Hole                                             
;
Make_Hole       PROC    NEAR

ParaHole = (Number_Stars * size Star) / 16d + 1
        PCall Alloc_Mem, ParaHole
        mov     block1, ax

        push    ds
        push    OFFSET HolePal
        push    Quarter1 064d
        Call SetXPalette
        call Generate_StarField

comment #
        push    OFFSET Rafa0001
        push    OFFSET Block2
        Call Read2Mem
        PCall SetXPalette, Block2, 0008h, Quarter2, 064d
#

        mov     cx, WaitSeconds * 017d          ;Not more than 017d -> CX= 1024
@@Continue_Stars:
        push    cx
        call WaitRetrace        ;Adds 5 seg. with Number_Stars=4000d
;        PCall Decode64, Block2, NoPalette, VGASeg, 26074, Quarter2
        mov     ax, cx
        mov     al, ah
        not     ax
        and     ax, 00000000000000011b
;;        and     ax, 00000000000000111b        ;More than 17*WaitSeconds
        add     ax, 0002h
        PCall StarField, ax

        pop     cx
        dec     cx
        jz @@end_make_hole
        MOV     AH,01
        INT     16h             ;eliminar este INT
        jz @@Continue_Stars

@@end_make_hole:
        PCall Free_Alloc, block1
        PCall Free_alloc, block2

        call ReStart
        retn
Make_Hole       ENDP


;Ŀ
;     M A K E   S T A R F I E L D   M O V I N G          
; Entry =  [bp +04h] --> Speed of stars                  
; Return= Nothing                                        
;
StarField  PROC NEAR
        push    bp
        mov     bp, sp
        ;
        ;inc     b [n_stars]
        ;mov     cx, w [n_stars]
        ;add     cx, cx
        ;add     cx, cx
        ;inc     cx

        push    ds
        mov     si, [block1]
        mov     ds, si
        mov     si, 0A000h
        mov     es, si
        xor     si, si
        mov     cx, Number_Stars

@@next_star:
        push    bp

        mov     al, b [bp + 04h]
        sub     b [si].Z, al    
;        dec     b [si].Z       ;SPEED UP--> 'sub b [si].Z, 04h' or more.

        call Limpia_Antiguos

        mov     al, b [si].X
        xor     ah, ah
        mov     dh, b [si].Z
        mul     dh
        mov     dl, ah                  ;DL = Coordenada X proyectada
        mov     al, b [si].Y
        xor     ah, ah
        mul     dh
        mov     dh, ah                  ;DH = Coordenada Y proyectada

        call PutStars

        add     si, size Star
        pop     bp
        loop @@next_star

        pop     ds
        pop     bp
        retn 0002h
StarField  ENDP

;__________________________________________________________
;
;   G E N E R A T E   S T A R F I E L D
;----------------------------------------------------------
Generate_StarField      PROC    NEAR
        push    ds
        mov     cx, w [block1]
        mov     ds, cx
        assume  ds:nothing
        xor     bx, bx
        mov     cx, Number_Stars               ;Number of Stars


        mov     cx, 158d
  @@loop_gen_1a:
        mov     b [bx].X, cl
        mov     b [bx].Y, 98d
        call Random
        mov     b [bx].Z, al
        add     bx, size Star

        mov     b [bx].X, cl
        mov     b [bx].Y, 98d
        call Random
        mov     b [bx].Z, al
        add     bx, size Star

        loop @@loop_gen_1a


        mov     cx, 98d
 @@loop_gen_2a:
        mov     b [bx].Y, cl
        mov     b [bx].X, 158d
        call Random
        mov     b [bx].Z, al
        add     bx, size Star

        mov     b [bx].Y, cl
        mov     b [bx].X, 158d
        call Random
        mov     b [bx].Z, al
        add     bx, size Star

        loop @@loop_gen_2a

        mov     cx, 108d
  @@loop_gen_1b:
        mov     b [bx].X, cl
        add     b [bx].X, 025d
        mov     b [bx].Y, 98d - 25d
        call Random
        mov     b [bx].Z, al
        add     bx, size Star

        mov     b [bx].X, cl
        add     b [bx].X, 025d
        mov     b [bx].Y, 98d - 25d
        call Random
        mov     b [bx].Z, al
        add     bx, size Star

        loop @@loop_gen_1b

        mov     cx, 98d - 50d
 @@loop_gen_2b:
        mov     b [bx].Y, cl
        add     b [bx].Y, 025d
        mov     b [bx].X, 158d - 25d
        call Random
        mov     b [bx].Z, al
        add     bx, size Star

        mov     b [bx].Y, cl
        add     b [bx].Y, 025d
        mov     b [bx].X, 158d - 25d
        call Random
        mov     b [bx].Z, al
        add     bx, size Star

        loop @@loop_gen_2b



        pop     ds
        retn
Generate_StarField      ENDP



;__________________________________________________________
;
;   Clear previous pixels of screen
;----------------------------------------------------------
Limpia_Antiguos PROC    NEAR
        xor     al, al
        mov     di, [si].P1
        stosb
        mov     di, [si].P2
        stosb
        mov     di, [si].P3
        stosb
        mov     di, [si].P4
        stosb
        retn
Limpia_Antiguos ENDP


;__________________________________________________________
;
;   P U T   S T A R S   P O I N T E D   B Y   D X
;----------------------------------------------------------
PutStars        PROC    NEAR
        mov     al, b [si].Z
        shr     al, 1
        shr     al, 1

        mov     bp, dx          ;\
        xor     dl, dl          ; \
        mov     di, dx          ;  \
        shr     di, 1           ;   \
        shr     di, 1           ;    > SI = 320 * Y + X
        add     di, dx          ;   /
        push    di              ;store (320 * y) for future use
        mov     dx, bp          ;  /
        xor     dh, dh          ; /
        add     di, dx          ;/
        add     di, 0320d * 0100d + 0160d
        mov     w [si].P1, di
        mov     b es:[di], al            ;4 cuadrante
        sub     di, dx
        sub     di, dx
        mov     w [si].P2, di
        mov     b es:[di], al            ;3 cuadrante
        pop     dx
        sub     di, dx
        sub     di, dx
        mov     w [si].P3, di
        mov     b es:[di], al            ;1 cuadrante
        mov     dx, bp
        xor     dh, dh
        add     di, dx
        add     di, dx
        mov     w [si].P4, di
        mov     b es:[di], al            ;2 cuadrante

        retn
PutStars        ENDP


;Ŀ
; Clear Keyboard hits  or  Quick Exit                   
;
Clear_KB        PROC    NEAR
        push    ds
        P&p     @DATA, ds
        assume  ds:@DATA
@@test_kbhit:
        mov     ah, 1
        int 16h
        jz @@test_end
        xor     ah, ah
        int 16h
        cmp     al, 01bh
        jne @@not_exit
        or      w Exit, 0001h
@@not_exit:
        jmp short @@test_kbhit

@@test_end:
        cmp     w Exit, 0002h
        jae @@hard_exit
        cmp     w Exit, 0001h
        jne @@end_clear
        mov     w Exit, 0002h
        call Restore_Init_Screen
        call Clear_KB
@@hard_exit:
        mov     ax, 04c00h
        int 021h
        retn                            ;Never used
@@end_clear:
        pop     ds
        retn
Clear_KB        ENDP


;Ŀ
; Clear Registers for test dependencies                 
;
Clear_Reg       PROC    NEAR
        xor     ax, ax
        xor     bx, bx
        xor     cx, cx
        xor     dx, dx
        xor     si, si
        xor     di, di
;        mov     ds, ax                ;@DATA
        mov     es, ax
        retn
Clear_Reg       ENDP


;Ŀ
; Hello from Billy the XXXXXX                           
;
Make_hello      PROC    NEAR
        assume  ds:@DATA

comment #
        push    OFFSET WallPape
        push    OFFSET Block1
        Call Read2Mem


        push    OFFSET BillG_01
        push    OFFSET Block2
        Call Read2Mem

        push    OFFSET Virus_01
        push    OFFSET Block3
        call Read2Mem

        push    OFFSET Virus_02
        push    OFFSET Block4
        call Read2Mem

        push    OFFSET Connect1
        push    OFFSET Block5
        call Read2Mem
#

;        PCall Decode64, Block1, 0000d, VGASeg, 00000h, Quarter2
        PCall Seconds, 0001h

        push    0003h @DATA
        push    OFFSET Txt_wall
        push    VGASeg 0000h Quarter2           ;Quarter3
        Call VGAFont

;        PCall Decode64, Block5, 0000d, VGASeg, 04f0ch, Quarter2
        PCall Seconds, 0005h

;        PCall Decode64, Block1, 0000d, VGASeg, 00000h, Quarter2
;        PCall Decode64, Block2, 0000d, VGASeg, 00740d, Quarter3
        PCall Seconds, 0006h

;        PCall Decode64, Block3, 0000d, VGASeg, 04f0ch, Quarter4
        PCall Seconds, 0006h

;        PCall Decode64, Block1, 0000d, VGASeg, 00000h, Quarter2
;        PCall Decode64, Block2, 0000d, VGASeg, 00740d, Quarter3
;        PCall Decode64, Block4, NoPalette, VGASeg, 04f0ch, Quarter4
        PCall Seconds, 0006h


        PCall Free_alloc, Block1
        PCall Free_alloc, Block2
        PCall Free_alloc, Block3
        PCall Free_alloc, Block4
        PCall Free_alloc, Block5
        call ReStart
        retn
Make_hello      ENDP


comment #
;Ŀ
; Read a file to mem                                    
; Entry: File to Read - Block to Write                  
;             0006h   -    0004h                        
; Return: Nothing                                       
;
Read2Mem        PROC    NEAR
        push    bp
        mov     bp, sp

        push    ds ax di bx
        mov     ax, @DATA
        mov     ds, ax
        assume  ds:@DATA
        mov     di, [bp + 06h]
        PCall Fopen_file, 0000h, @DATA, di              ;[di].FName
        mov     w FileHandle1, ax
        mov     bx, [di].FSize
        shr     bx, 04h
        inc     bx
        PCall Alloc_mem, bx
        mov     bx, w [bp +04h]
        mov     [bx], ax
        PCall Read_file, FileHandle1, [di].FSize, ax, 0000h
        PCall Close_File, FileHandle1

        pop     bx di ax ds
        pop     bp
        retn 0004h
Read2Mem        ENDP
#







;Ŀ
; Put text with fonts in VGA. Entries:                       
; SetPal,NumberFont,SegText,OffText,SegDest,OffDest,MaskColor
; [ +10h  +0Eh      +0Ch    +0Ah    +08h     +06h   +04h]    
; Return: Nothing                                            
;
VGAFont PROC    NEAR
        push    bp
        mov     bp, sp

;VF_SetPal     EQU w [bp+10h]
VF_NumberFont EQU w [bp+0eh]
VF_SegText    EQU w [bp+0Ch]
VF_OffText    EQU w [bp+0Ah]
VF_SegDest    EQU w [bp+08h]
VF_OffDest    EQU w [bp+06h]
VF_MaskColor  EQU w [bp+04h]

VF_Advance    EQU w [bp-02h]
VF_Counter    EQU w [bp-04h]
VF_SqLine     EQU w [bp-06h]
VF_SqLetter   EQU w [bp-08h]
VF_Font       EQU w [bp-0Ah]

        sub     sp, 000Ah

        pusha
        push    ds es

@@not_setpal:
        mov     w VF_Advance, 0008h
        mov     ax, Vf_OffText
        mov     w VF_Counter, ax
;;        mov     w VF_Counter, 0000h
        cmp     w VF_NumberFont, 0003h
        jne @@not_3font
        mov     w VF_Advance, 0006h
@@not_3font:
        P&p     @DATA, ds
        mov     ax, Font
        mov     VF_Font, ax
        mov     ax, VF_OffDest
        mov     VF_SqLine, ax
        mov     VF_SqLetter, ax
        mov     di, ax
        mov     ax, VF_SegText
        mov     ds, ax
        mov     ax, VF_OffText
        mov     si, ax
        mov     ax, VF_SegDest
        mov     es, ax
@@next_letter:
        lodsb
        mov     VF_Counter, si
;        inc     VF_Counter
        test    al, al
        jnz @@not_end_VF
        pop     es ds
        popa
        add     sp, 000Ah
        pop     bp
        retn 0Ch

@@not_end_VF:
        cmp     al, 0Dh
        jne @@not_NL

        mov     ax, VF_Advance
        mov     bh, al
        xor     bl, bl
        mov     ah, al
        xor     al, al
        shr     ax, 1
        shr     ax, 1
        add     ax, bx                  ;VF_Advance * 320
        add     VF_SqLine, ax
        mov     di, VF_SqLine
        mov     VF_SqLetter, di
        inc     si
        jmp short @@next_letter
        ;;;
@@not_NL:
        cmp     al, 032d        ;Space
        jne @@not_space
        mov     ax, VF_Advance
        add     VF_SqLetter, ax
        mov     di, VF_SqLetter
        jmp short @@next_letter
@@not_space:
        ;Then a normal letter, i supposse
        ;
        mov     cx, VF_Font
        mov     ds, cx
        mov     ah, al
        xor     al, al
        shr     ax, 2           ;al*64
        mov     si, ax
        mov     ax, 8192d               ;Size of every font (128 char * 64 [8x8])
        mul     VF_NumberFont           ;ax=0000,8192,16384,25...->32768
        add     si, ax
        mov     ah, b VF_MaskColor
        mov     cx, VF_Advance
@@next_letter_line:
        push    cx
        mov     cx, VF_Advance
@@next_letter_pix:
        lodsb
        test    al, al
        jnz @@putpix
        inc     di
        jmp short @@loop_nlp
@@putpix:
        or      al, ah
        stosb
@@loop_nlp:
        loop @@next_letter_pix
        mov     cx, w VF_Advance
        sub     di, cx
        add     di, 0320d
        sub     si, cx
        add     si, 0008h
        pop     cx
        loop @@next_letter_line

        mov     di, VF_SegText
        mov     ds, di
        mov     si, w VF_Counter
        mov     di, VF_SqLetter
        add     di, VF_Advance
        mov     VF_SqLetter, di
        jmp @@next_letter

@@end_VF:
        pop     es ds
        popa
        add     sp, 000Ah
        pop     bp
        retn 0Ch
VGAFont ENDP


;Ŀ
; Put text with fonts in VGA. Entries:                         
; SetPal,NumberFont,SegText,OffText,SegDest,OffDest,MaskColor  
; [010h +0Eh      +0Ch    +0Ah    +08h     +06h   +04h]        
; Return: Nothing                                              
;
Text1   PROC    NEAR

comment #
        push    @DATA
        push    OFFSET std64
        push    Quarter3 064d
        call SetXPalette
#

        push    0001h @DATA
        push    OFFSET Txt_wall
        push    VGASeg 0000h Quarter3
        Call VGAFont

        call Kbhit

        retn
Text1   ENDP


;Ŀ
; Do lines from Block1 & VGA                            
; [ block of picture  ,     block of pix struc  ]       
;    [ +06h                     +04h ]                  
;
Do_Lines        PROC    NEAR

DL_Block1       EQU     w [bp+06h]
DL_Block2       EQU     w [bp+04h]
        stop

        push    bp
        mov     bp, sp

        push    cx ds es
        mov     ds, w DL_Block2
        xor     si, si
        mov     cx, NumPixLet
@@next_pix1:
        push    cx

;restore old pixel
        cmp     w si.[Living], TRUE
        je @@restore_pix
        jmp @@pre_nextpix
@@restore_pix:
        mov     di, w si.[Loc]
        mov     al, b si.[Bgcolor]
        test    al, al
        jz @@not_restore_pixlet
        stosb
@@not_restore_pixlet:

;sub & test
        mov     ax, w si.[PDec]
        mov     di, w si.[Loc]
        add     w si.[Part], ax
;;        shr     b si.[Part+1], 1
;;        jnc @@not_dec320
;;        sub     di, 0320d
@@not_dec320:
        sub     di, ax
        cmp     di, w si.[FinLoc]
        jbe @@endingpix

;set new location
        mov     w si.[Loc], di
        mov     al, b es:[di]
        test    al, 11000000b
        jnz @@es_bg1
        mov     si.[Bgcolor], 0000h
        jmp short @@pre_nextpix
@@es_bg1:
        mov     b si.[Bgcolor], al
        mov     al, b si.[Fgcolor]
        mov     b es:[di], al
        jmp short @@pre_nextpix

@@endingpix:
;new pix lets
        mov     di, w si.[FinLoc]
        mov     al, b si.[Fgcolor]
        stosb
        mov     bx, 64000 + 32
        add     bx, cx
        mov     w si.[Loc], bx            ;Initial Position depending CX

        push    es di
        mov     es, w DL_Block1
        mov     di, dx
        inc     di
@@next_lookpix1:
        mov     cx, 64000d
        sub     cx, dx
        xor     al, al
        repe scasb
        jne @@set_newpix1

@@not_morepixlet:
        pop     di es
        mov     dx, 064000d
        mov     w si.[Living], FALSE
        jmp short @@pre_nextpix
@@set_newpix1:
        dec     di
        mov     al, b es:[di]
        mov     dx, di
        pop     di es

        mov     w si.[FinLoc], dx
        mov     b si.[Fgcolor], al

;calculo [si.[PDec]]
        mov     ax, w si.[Loc]
        sub     ax, dx
        push    dx
        xor     dx, dx
        mov     bx, 00100d              ;000200d
        div     bx
        mov     bx, dx
        pop     dx
        mov     w si.[PDec], ax
        mov     w si.[Part], bx

@@pre_nextpix:
        add     si, size PixLet

        pop     cx
        dec     cx
        jcxz @@end_dolines
        jmp @@next_pix1

@@end_dolines:
        pop     es ds cx

        pop     bp
        retn 0004h
Do_Lines        ENDP

;Ŀ
;                                                       
;
Pre_PixLet      PROC    NEAR
        push    ax cx di es
        mov     es, Block2
        xor     di, di
        xor     ax, ax
        mov     cx, NumPixLet
@@zero_pixlet:
        mov     ax, 64000d
        stosw
        mov     ax, 64100d
        stosw
        xor     ax, ax
        stosw
        stosw
        stosw
        dec     ax              ;AX=0ffffh
        stosw

        loop @@zero_pixlet
        pop     es di cx ax
        retn
Pre_PixLet      ENDP



;Ŀ
;                                                       
;
Baile   PROC    NEAR
        mov ax,3
        int 10h

        mov     cx, WaitSeconds*08d
@@until_kbhit_baile:
        push cx
        call WaitRetrace

        push    @DATA OFFSET simple_girl
        call Ver_txt

        cmp     cx, WaitSeconds*05-1
        jne @@no_titulo_baile
        push    @DATA OFFSET txt_win_start
        call Ver_grf1
@@no_titulo_baile:
        pop cx
        mov     ah, 1
        int 016h
        jnz @@end_baile1
        loop @@until_kbhit_baile

@@end_baile1:


        retn
Baile   ENDP



        END Inicio





