/*
converts targa's to img files

Swivel | CSR
swivel@csrmusic.org
*/




#include	<stdio.h>
#include	"image.h"
#include	"targa.h"


void	tgapal2rgbpal(unsigned char *tga, unsigned char *pal, unsigned short quantity)
{
	unsigned short i;

	for(i = 0; i < quantity; i++) {
		pal[i * 3] = tga[i * 3 + 2];
		pal[i * 3 + 1] = tga[i * 3 + 1];
		pal[i * 3 + 2] = tga[i * 3];
	}
}


int	main(int argn, char *args[])
{
	struct TARGA 	*tga;
	struct pal 	*pal;


	if(argn == 1 || argn > 3) {
		printf("Usage: %s infile(tga) outfile(pal)\n", args[0]);
		return 0;
	}


	tga = load_targa(args[1]);
	if(tga == NULL) return 0;

	pal = imnew_palette();
	if(pal == NULL) return 0;


	pal->start = tga->color_map_start;
	pal->quantity = tga->color_map_entries;

	pal->data = (unsigned char *)calloc(1, pal->quantity * 3);
	if(pal->data == NULL) {
		printf("Error allocating %i bytes for palette data.\n",
			pal->quantity * 3);
		return 0;
	}

	tgapal2rgbpal(tga->color_map, pal->data, pal->quantity);
	

	if(!imsave_palette(pal, args[2]))
		return 0; 

	
	
	return 1;
}
