#include <vga.h>
#include <vgagl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

#include "filereader.h"
#include "wav.h"
#include "utils.h"

#ifndef SOUNDDEVICE
#	define SOUNDDEVICE "/dev/dsp"
#endif

GraphicsContext ps;
GraphicsContext vs;
GraphicsContext text;
int soundfd;
char buf2[64000];
sound_t sound;
   
void initgraph()
{
   int i=0;
   vga_setmode(G320x200x256);
   gl_setcontextvga(G320x200x256);
   gl_getcontext(&ps);
   gl_setcontextvgavirtual(G320x200x256);
   gl_getcontext(&vs);
   gl_setcontextvgavirtual(G320x200x256);
   gl_getcontext(&text);

/*set text*/
   gl_setwritemode(FONT_COMPRESSED+WRITEMODE_MASKED);    
   gl_setfont(8,8,gl_font8x8);


/*setpalette*/
   for(i=0;i<128;i++)
	vga_setpalette(i,i/2,0,0);
   for(i=128;i<255;i++)
	vga_setpalette(i,63,(i-128),0);

};

int OSSinit(int sr,int s,int type)
{
   int st=s-1;
   int soundfd;
   if (!(soundfd=open(SOUNDDEVICE,O_WRONLY|O_NONBLOCK)))
   {	
	PERROR("cannot open the sound device");
	exit(1);
   }
   if(ioctl(soundfd,SNDCTL_DSP_RESET,0)==-1)
   {	
	PERROR("soundcard reset error\n");
	exit(1);
   };
   if(ioctl(soundfd,SNDCTL_DSP_SPEED,&sr)==-1)
	PWARN("soundcard speed error\n");
   if(ioctl(soundfd,SNDCTL_DSP_CHANNELS,&s)==-1)
	PWARN("soundcard channels error\n");
   if(ioctl(soundfd,SNDCTL_DSP_STEREO,&st)==-1)
	PWARN("soundcard channels error\n");
   if(ioctl(soundfd,SNDCTL_DSP_SETFMT,&type)==-1)
	PWARN("soundcard channels error\n");
   return soundfd;
};

void refreshscreen()
{
   int i;
   gl_setcontext(&vs);
   for(i=0;i<64000;i++)
	if(text.vbuf[i]!=0)vs.vbuf[i]=text.vbuf[i];
   gl_copyscreen(&ps);
};
void clearscreens()
{
   memset(text.vbuf,0,WIDTH*HEIGHT);
   memset(vs.vbuf,0,WIDTH*HEIGHT);
};

void processsound()
{
   int soundreaded=0;
   int xi=0,yi=0,i=0;
   int setted=0;
   float counter=0;
   char soundbyte;
   gl_setcontext(&text);
   gl_setfontcolors(0,235);
   gl_putbox(20,120,360,40,buf2);
   gl_setcontext(&vs);
   gl_setfontcolors(0,220);
   while(soundreaded<sound.samplesize)
   {
	/*process sound*/
	counter+=0.1;
	soundreaded+=1700;
	setted=0;
	write(soundfd,sound.data+soundreaded,1700);
	for(i=0;i<1800;i++)
	{
	   soundbyte=sound.data[i+soundreaded-1500];
	   if(!setted && soundbyte>-1 && soundbyte<1)
	   {   
		memset(VBUF,60,WIDTH*HEIGHT);
		setted=1;
	   }	

	   gl_setpixel(i/5,(unsigned char)soundbyte>>1,100);
	   gl_setpixel(i/5,((unsigned char)soundbyte>>1)+1,235);
	};
	if(counter>10 && counter <30)gl_printf(1,1,"EI what a fuck is this");
	if(counter>30 && counter <50)gl_printf(50,100,"whats going on");
	if(counter>50 && counter <55)gl_printf(70,100,"SHIT");
	if(counter>55 && counter <70)gl_printf((counter-55)*10,170,"I'm burning, run run");
	if(counter>110 && counter <120)gl_printf(50,160,"this isn't nice :(");
	if(counter>120 && counter <130)gl_printf(80,20,"I counldn't do more than this :(");
	if(counter>130 && counter <160)gl_printf(10,170,"So enjoy the shit :((");
	if(counter>160 && counter <170)gl_printf(10,60,"LOL,this is wrong");
	refreshscreen();
	for(yi=1;yi<200;yi++)
	   for(xi=0;xi<320;xi++)
	   {
		if(VBUF[xi+yi*320]>0) VBUF[(xi+(random()*RAND_MAX%2)-1)+(yi+(random()*RAND_MAX%2)-1)*320]=VBUF[(xi)+(yi)*320]-2;
	   };	   
   };
}





void fake()
{
   char buf1[64000];
   int something=1;
   int i=0;
   float xi=0,yi=0,mx=0.3,my=0.3;
   gl_setfontcolors(0,235);
   while(i<6000)
   {
	xi+=mx;
	yi+=my;
	if(xi>240){xi=238;mx*=-1;}
	if(xi<2){xi=2;mx*=-1;}
	if(yi>170){yi=168;my*=-1;}
	if(yi<2){yi=2;my*=-1;}
	i+=1;
	gl_printf(xi,yi,"Reboot'99");
	refreshscreen();
	clearscreens();
   };
   gl_printf(120,90,"the end");
   refreshscreen();   
   sleep(2);
   clearscreens();
   gl_printf(120,90,"Reboot'99");
   gl_getbox(120,90,90,10,buf1);
   clearscreens();   
   gl_scalebox(90,10,buf1,90*4,10*4,buf2);
   gl_setcontext(&vs);
   gl_putbox(20,90,90*4,10*4,buf2);
   refreshscreen();
   while(something)
   {
      something=0;
	for(i=0;i<64000;i++)
	{
	   if(ps.vbuf[i]!=0){ps.vbuf[i]=ps.vbuf[i]-1;something=1;};
	};
   }
   sleep(4);
   clearscreens();
};





void intro()
{
   gl_setfontcolors(0,235);
   gl_printf(1,1,"JIZZ, this is a demo?");
   refreshscreen();
   sleep(4);
   gl_printf(40,51,"damn, this realy sucks");
   refreshscreen();
   sleep(4);   
   gl_printf(1,150,":/ what can i do");
   refreshscreen();
   memset(text.vbuf,0,WIDTH*HEIGHT);
   sleep(4);

};







void main(int argc,char* argv[])
{
   file_t file;
   printf("\n\n\7Broadcast message from root (tty2) Mon Dec 27 20:31:31 1999...\n");
   printf("\nThis system is going down for maintenance mode NOW !!\n");
   printf("INIT: Switching to runlevel 6\n");
   sleep(2);
   printf("INIT: Sending processes the TERM signal\n");
   sleep(1);
   printf("INIT: Sending processes the KILL signal\n");
   sleep(3);
   printf("\nStarting services :\33[01;31mREBOOT 99\33[0m\n");
   sleep(4);
   printf("\n");
   initgraph();

   fake();
   intro();
   gl_setcontext(&vs);
   read_FILE(&file,"data/data.dat");
   read_WAV(&sound,file);
   free_FILE(&file);
   soundfd=OSSinit(sound.samplerate,sound.channels,8);
   processsound();
      




};