#include "filereader.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "utils.h"




void read_FILE(file_t *output,const char *fname)
{
   FILE *fileptr;
   int bytesreaded;
   if((fileptr=fopen(fname,"r"))==NULL)
   {
	PERROR("File not found: \033[01;37m%s\033[0m\n",fname);
	exit(1);
   };
   output->path=malloc(strlen(fname));
   strncpy(output->path,fname,strlen(fname));
   fseek(fileptr,0L,SEEK_END);
   output->size=ftell(fileptr);
   fseek(fileptr,0L,SEEK_SET);
   output->data=malloc(output->size);
   bytesreaded=fread(output->data,1,output->size,fileptr);
   if(bytesreaded!=output->size)
   {
	PERROR("reading file %s\n",fname);
	exit(1);
   };
   fclose(fileptr);
};
void free_FILE(file_t *output)
{
   free(output->path);
   free(output->data);
};