#ifndef _GCUBE_H_
#define _GCUBE_H_

#define numLights 2
#define sortListLen 1024

typedef struct {
  float x;
  float y;
} Point;

typedef struct {
  int x;
  int y;
} IPoint;
//--- vector functions

typedef struct {
  float x;
  float y;
  float z;
} Vector;

typedef struct {
  double x;
  double y;
  double z;
} DVector;

//--- tracks

typedef struct {
  float P;
  int frame;
} Key1;

typedef struct {
  Key1 *key;
  int startFrame;
  int endFrame;
  float P1;
  float R1;
  float P2;
  float R2;
} Track1;

typedef struct {
  Vector P;
  int frame;
} Key3;

typedef struct {
  Key3 *key;
  int startFrame;
  int endFrame;
  Vector P1;
  Vector R1;
  float adj1;
  Vector P2;
  Vector R2;
  float adj2;
  float nextAdj;
} Track3;

typedef struct {
  int *key;
  int state;
} SwitchTrack;

//--- camera
typedef struct {
  Vector p;
  Vector lx;
  Vector ly;
  Vector lz;
} Camera;

//--- texture map generator
typedef struct {
  unsigned char *r;
//  unsigned char *g;
//  unsigned char *b;
  int shift;
  int mask;
  float *filter;
  unsigned char *result;
} MapInfo;

//--- wall
typedef struct {
  float u;
  float v;
//  float r;
//  float g;
//  float b;
} WVertexAttr;

typedef struct {
  int idx[4];
} WFace;
/*
typedef struct {
  int bumpx;
  int bumpy;
} WBumpInfo;
*/
typedef struct {
  int nVerts;
  Vector *verts;
  WVertexAttr *attribs;
  int nFaces;
  WFace *faces;
  Vector p;
  Vector u;
  Vector v;
  Vector n;
  float xscale;
  float yscale;
/*  float cx;
  float cy;
  float cd;*/
  unsigned int *binfo[numLights];
} Wall;

typedef struct {
  float x;
  float y;
  float u;
  float v;
} WScreenPoint;

//---

typedef struct {
  DVector p;
  DVector v;
  Vector tp;
} Mass;

typedef struct {
  Mass *ma;
  Mass *mb;
} CEdge;


typedef struct {
  Mass *ma;
  Mass *mb;
  Mass *mc;
  DVector n; //normalized length
  //vertex weight calculation for collision
  int orientation; //0: xy, 1: yz, 2: zx
  //inverse matrix
  DVector M1;
  DVector M2;
  DVector M3;
} CFace;

typedef struct {
  int a;
  int b;
  int c;
  int light;
} Face;

typedef struct {
  float u;
  float v;
} Mapping;

typedef struct {
  char *vTags;        //vertex tags
  Vector *sVerts;     //shadow vertices
  Vector *lVerts;     //light vertices
  char *fTags;        //face tags
  float *lIntensities;//light face intensity
//  Vector lightDir;    //direction vector to light
} LightInfo;

typedef struct {
  char *vTags;
  Mapping *mapping;
} PhongInfo;


typedef struct {
  int nMasses;
  Mass *masses;

  int nCEdges;
  CEdge *cEdges;
  int nCFaces;
  CFace *cFaces;

  int nVerts;
  Vector *verts;
  Vector *normals;
  Mapping *mapping;
  float *alpha;
  int nFaces;
  Face *faces;

  DVector bound1;
  DVector bound2;
  Vector center;

  LightInfo linfo[numLights];
  PhongInfo pinfo[numLights];
} Object;

typedef struct {
  Mass m;
  int state;
} Particle;


typedef struct {
  int nMasses;
  Mass *masses;

  int nVerts;
  Vector *verts;
  Vector *normals;
  Mapping *mapping;

  int nFaces;
  Face *faces;

  Vector center;

  PhongInfo pinfo[numLights];
} Cloth;


//--- clip
typedef struct {
  float x;
  float y;
  float z;
  float dist;
  int clip;
  float param[1];
} ParamPoint;

typedef struct {
  int nParams;
  int size;
  ParamPoint *start;
  ParamPoint *end;
} ClipInfo;

//--- visualization

//--- texture mapping & rgb shading
typedef struct {
  float x;
  float y;
  int r, g, b;
} RgbPoint;

//--- sorting
typedef struct List {
  struct List *next;
  void (*paint)(struct List *, ParamPoint *, ParamPoint *);
} List;

typedef struct {
  List head;
  Vector *v[3];
  Mapping *mapping;
  float *alpha;
  Face *face;
  PhongInfo *pinfo;
} SortFace;

typedef struct {
  List head;
  Camera camera;
  float minDist;
  Vector *v[4];
  Object *obj;
} SortMirror;

typedef struct {
  List head;
  float x;
  float y;
  float u;
  float v;
//  Mass *particle;
} SortParticle;

typedef struct {
  List head;
  float x;
  float y;
  unsigned int *map;
  float mapx;
  float mapy;
} SortLight;


void vecAssign(Vector *v1, Vector *v2);
void vecAssign4(Vector *v, float x, float y, float z);
void vecNeg(Vector *v);
void vecAdd(Vector *v1, Vector *v2);
void vecAdd3(Vector *r, Vector *v1, Vector *v2);
void vecSub(Vector *v1, Vector *v2);
void vecSub3(Vector *r, Vector *v1, Vector *v2);
void vecMulf(Vector *v, float f);
void vecMul3(Vector *r, Vector *v, float f);
void vecMulAdd(Vector *r, Vector *v, float f);
void vecMulC(Vector *r, Vector *v);
float vecMul(Vector *v1, Vector *v2);
void vecCross(Vector *r, Vector *v1, Vector *v2);
float vecAbs(Vector *v);
void vecNorm(Vector *v);
void vecPrint(Vector *v);

void initTrack3(Track3 *track, Key3 *key);
void doTrack3(Track3 *track, int frame, Vector *p);
void initSwitchTrack(SwitchTrack *track, int *key);
int doSwitchTrack(SwitchTrack *track, int frame);

void step();
void render();
//void initTracks();
void setLocations();
void initIntro(int xres, int yres);
#endif