#include <stdio.h>

Uint32 *texture;

int teta = 0;
int h_cos[360];
int h_sin[360];





void 
init_tables (int zoom)
{

  int i;
  double h;
  double radian;

  for (i = 0; i < 360; i++)
    {

      radian = 2 * i * M_PI / 360;

      // La valeur avant cos, c'est le zoom. Plus le nombre est grand, plus on est eloigne

      h = zoom + cos (radian);

      h_cos[i] = 256 * (h * cos (radian));
      h_sin[i] = 256 * (h * sin (radian));

    }

}




void 
refresh ()
{

  const int c = h_cos[teta];
  const int s = h_sin[teta];

  const int xi = -(W / 2) * c;
  const int yi = (W / 2) * s;

  const int xj = -(H / 2) * s;
  const int yj = -(H / 2) * c;

  Uint32 *scrtmp = buffer;
  int i, j;

  int x, y;
  int xprime = xj;
  int yprime = yj;


  for (j = 0; j < H; j++)
    {

      x = xprime + xi;
      xprime += s/5;

      y = yprime + yi;
      yprime += c;

      for (i = 0; i < W; i++)
	{

	  x += c;
	  y -= s;

	  *(scrtmp++) = *(texture + ((x >> 8) & 255) + (y & (255 << 8)));

	}

    }

}


