/* Simon Frankau, and Now3d's demo doodah. Woah. */

#include <stdlib.h>
#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#include "Addrs.h"

#define X_BLOCKS 10
#define Y_BLOCKS 8
#define X_SIZE 32
#define Y_SIZE 32
#define X_OFFSET 0
#define Y_OFFSET 0

int saw(int i, int max);

/* Our poly grid. */
POLY_GT4 refract_map[Y_BLOCKS][X_BLOCKS];

int xcoords[Y_BLOCKS+1][X_BLOCKS+1];
int ycoords[Y_BLOCKS+1][X_BLOCKS+1];
int rcoords[Y_BLOCKS+1][X_BLOCKS+1];
int gcoords[Y_BLOCKS+1][X_BLOCKS+1];
int bcoords[Y_BLOCKS+1][X_BLOCKS+1];

void do_wobble(void)
{
	int x, y;
	/* Make sure all texture points are in range. */
	for (x=0; x<X_BLOCKS+1; x++) {
		for (y=0; y<Y_BLOCKS+1; y++) {
			if (xcoords[y][x] > 0xff)
					xcoords[y][x] = 0xff;
			else if (xcoords[y][x] < 0)
					xcoords[y][x] =0;
			if (ycoords[y][x] > 0xff)
				ycoords[y][x] = 0xff;
			else if (ycoords[y][x] < 0)
					ycoords[y][x] =0;
			if (rcoords[y][x] > 0xff)
				rcoords[y][x] = 0xff;
			else if (rcoords[y][x] < 0)
					rcoords[y][x] =0;
			if (gcoords[y][x] > 0xff)
				gcoords[y][x] = 0xff;
			else if (gcoords[y][x] < 0)
					gcoords[y][x] =0;
			if (bcoords[y][x] > 0xff)
				bcoords[y][x] = 0xff;
			else if (bcoords[y][x] < 0)
					bcoords[y][x] =0;
		}
	}

	/* Update the UV coords and colours and draw the primitives. */
	for (x=0; x<X_BLOCKS; x++) {
		for (y=0; y<Y_BLOCKS; y++) {
			setUV4(&refract_map[y][x], xcoords[y][x], ycoords[y][x],
												xcoords[y][x+1], ycoords[y][x+1],
												xcoords[y+1][x], ycoords[y+1][x],
												xcoords[y+1][x+1], ycoords[y+1][x+1]);
			setRGB0(&refract_map[y][x], rcoords[y][x],
				gcoords[y][x], bcoords[y][x]);
			setRGB1(&refract_map[y][x], rcoords[y][x+1],
				gcoords[y][x+1], bcoords[y][x+1]);
			setRGB2(&refract_map[y][x], rcoords[y+1][x],
				gcoords[y+1][x], bcoords[y+1][x]);
			setRGB3(&refract_map[y][x], rcoords[y+1][x+1],
				gcoords[y+1][x+1], bcoords[y+1][x+1]);

			DrawPrim(&refract_map[y][x]);
		}
	}
}

void init_wobble_stuff(void)
{
	int x, y;
	RECT r = {768, 0, 256, 256};
	GsIMAGE tim;

	/* Load Tim. */
	GsGetTimInfo(HELLO_TIM, &tim);
	LoadImage(&r, tim.pixel);

	/* Initialise the points array. */
	for (x=0; x<X_BLOCKS; x++) {
		for (y=0; y<Y_BLOCKS; y++) {
			SetPolyGT4(&refract_map[y][x]);
			setXY4(&refract_map[y][x], X_OFFSET+X_SIZE*x, Y_OFFSET+Y_SIZE*y,
				X_OFFSET+X_SIZE*(x+1), Y_OFFSET+Y_SIZE*y,
				X_OFFSET+X_SIZE*x, Y_OFFSET+Y_SIZE*(y+1),
				X_OFFSET+X_SIZE*(x+1), Y_OFFSET+Y_SIZE*(y+1));
			setTPage(&refract_map[y][x],2,0,768,0);
		}
	}
}

void screen_normal_cols(int i)
{
	int x, y;
	for (x=0; x<X_BLOCKS+1; x++) {
		for (y=0; y<Y_BLOCKS+1; y++) {
			rcoords[y][x] = i;
			gcoords[y][x] = i;
			bcoords[y][x] = i;
		}
	}
}

void screen_spotlight(int lx, int ly, int dimness)
{
	int val, x, y;
	for (x=0; x<X_BLOCKS+1; x++) {
		for (y=0; y<Y_BLOCKS+1; y++) {
			val = (lx-xcoords[y][x])*(lx-xcoords[y][x])
				+ (ly-ycoords[y][x])*(ly-ycoords[y][x]);
			val = (2048-val)/(8+dimness);
			rcoords[y][x]= val;
			gcoords[y][x]= val;
			bcoords[y][x]= val;
		}
	}
}

void screen_fadeup(int i)
{
	int x, y;
	for (x=0; x<X_BLOCKS+1; x++) {
		for (y=0; y<Y_BLOCKS+1; y++) {
			rcoords[y][x]= xcoords[y][x]-ycoords[y][x]-320+3*i;
			gcoords[y][x]= -xcoords[y][x]-ycoords[y][x]+3*i;
			bcoords[y][x]= ycoords[y][x]-256+3*i;
		}
	}

}

void screen_standard(void)
{
	int x, y;
	for (x=0; x<X_BLOCKS+1; x++) {
		for (y=0; y<Y_BLOCKS+1; y++) {
			xcoords[y][x] = (x*256)/X_BLOCKS;
			ycoords[y][x] = (y*256)/Y_BLOCKS;
		}
	}
}

void screen_wobble(int much)
{
	int x, y;
	for (x=0; x<X_BLOCKS+1; x++) {
		for (y=0; y<Y_BLOCKS+1; y++) {
			xcoords[y][x] += -much/2 + (much*rand())/RAND_MAX;
			ycoords[y][x] += -much/2 + (much*rand())/RAND_MAX;
		}
	}
}

void screen_twist(int much)
{
	int x, y, distx, disty, centrex, centrey;
	for (x=0; x<X_BLOCKS+1; x++) {
		for (y=0; y<Y_BLOCKS+1; y++) {
			distx = 128-xcoords[y][x];
			disty = 128-ycoords[y][x];
			xcoords[y][x] += (disty*abs(disty)*much)>>14;
			ycoords[y][x] -= (distx*abs(distx)*much)>>14;
		}
	}
}

void screen_ripple(int time, int magnitude)
{
	int x, y, distx, disty, centrex, centrey;
	for (x=0; x<X_BLOCKS+1; x++) {
		for (y=0; y<Y_BLOCKS+1; y++) {
			distx = 128-xcoords[y][x];
			disty = 128-ycoords[y][x];
			xcoords[y][x] += (saw(distx+time, 64)-32)/(8+magnitude/8);
			ycoords[y][x] += (saw(disty+time, 64)-32)/(8+magnitude/8);
		}
	}
}
