/* Simon Frankau, and Now3d's demo doodah. Woah. */

#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#include "hitmod.h"
#include "addrs.h"

#define SCR_Z	512				/* distant to screen */
#define OTLEN	8
#define OTSIZE	(1<<OTLEN)

#define SOUND

typedef struct {
	DRAWENV		draw;			/* drawing environment */
	DISPENV		disp;			/* display environment */
	u_long		ot[OTSIZE];		/* ordering table */
} DB;

void do_wobble(void);
void init_wobble_stuff(void);
void init_wobble_texture(void);
void screen_standard(void);
void screen_spotlight(int lx, int ly, int dimness);
void screen_fadeup(int i);
void screen_wobble(int much);
void screen_twist(int much);
void screen_ripple(int time, int magnitude);
void screen_normal_cols(int i);

void do_phantom(int dist);
void init_phantom_stuff(void);

void draw_text(int much);
void init_text_stuff(void);

void init_firework_stuff(void);

int saw(int i, int max);

main()
{
	DB	db[2];		/* packet double buffer */
	DB	*cdb;		/* current db */
	long	dmy, flg;	/* dummy */
	long	otz;
	long	min_otz;
	long	opz[6][2];

	int	i,j,k;
	int x,y;
	int counter = 0; 
   int loc;

	ResetCallback();
	PadInit(0);             /* initialize PAD */
	ResetGraph(0);		/* reset graphic subsystem (0:cold,1:warm) */
	SetGraphDebug(1);	/* set debug mode (0:off, 1:monitor, 2:dump) */

#ifdef SOUND
	MOD_Init();
	MOD_Load((unsigned char*)MAT_HIT);
	MOD_Start();
#endif

	InitGeom();			/* initialize geometry subsystem */
	SetGeomOffset(160, 120);	/* set geometry origin as (160, 120) */
	SetGeomScreen(SCR_Z);		/* distance to viewing-screen */

	/* initialize environment for double buffer
	 *	buffer #0:	(0,  0)-(320,240) (320x240)
	 *	buffer #1:	(0,240)-(320,480) (320x240)
	 */
	SetDefDrawEnv(&db[0].draw, 0,   0, 320, 240);
	SetDefDrawEnv(&db[1].draw, 0, 240, 320, 240);
	SetDefDispEnv(&db[0].disp, 0, 240, 320, 240);
	SetDefDispEnv(&db[1].disp, 0,   0, 320, 240);

	db[0].draw.dtd = 0;
	db[1].draw.dtd = 0;

	/* set background color */
	db[0].draw.isbg = 1;
	setRGB0(&db[0].draw, 0, 0, 0);	/* (r,g,b) = (60,120,120) */
	db[1].draw.isbg = 1;
	setRGB0(&db[1].draw, 0, 0, 0);	/* (r,g,b) = (60,120,120) */

	/* display */
	SetDispMask(1);		/* enable to display (0:inhibit, 1:enable) */

	SetBackColor(100,100,100);

	init_wobble_stuff();
	init_phantom_stuff();
	init_text_stuff();
   init_firework_stuff();

	while (1) {
		cdb = (cdb==db)? db+1: db;	/* swap double buffer ID */
		ClearOTagR(cdb->ot, OTSIZE);	/* clear ordering table */

		if (counter<750) {
			do_phantom(counter);
		} else if (counter < 900) {
			loc = counter - 750;
			screen_standard();
			screen_spotlight(64, 48, 75-saw(loc, 75));
			do_wobble();
		} else if (counter < 1050) {
			loc = counter - 900;
			screen_standard();
			screen_spotlight(230, 128, 75-saw(loc, 75));
			do_wobble();
		} else if (counter < 1200) {
			loc = counter - 1050;
			screen_standard();
			screen_spotlight(80+loc, loc, 75-saw(loc, 75));
			do_wobble();
		} else if (counter < 1400) {
			loc = counter - 1200;
			screen_standard();
			screen_spotlight(360-2*loc, 28+loc, 100-saw(loc, 100));
			do_wobble();
		} else if (counter < 1700) {
			loc = counter - 1400;
			screen_fadeup(loc);
			screen_standard();
			screen_wobble(1);
			screen_ripple(counter,0);
			do_wobble();
		} else if (counter < 2000) {
			loc = counter - 1700;
			screen_standard();
			screen_normal_cols(255);
			screen_wobble(1);
			screen_ripple(counter, loc/2);
			do_wobble();
		} else if (counter < 2400) {
			loc = counter - 2000;
			screen_standard();
			screen_normal_cols(255);
			screen_twist(saw(counter+64-2000, 128)-64);
			if (counter > 2200) {
				screen_wobble((counter-2200)/8);
			}
			do_wobble();
		} else if (counter < 2600) {
			loc = counter - 2400;
			screen_standard();
			screen_normal_cols(255);
			screen_wobble((200-loc)/8+4);
			do_wobble();
		} else if (counter < 2800) {
			screen_standard();
			screen_normal_cols(255);
			screen_wobble(4);
			do_wobble();
		} else if (counter < 3350) {
			screen_standard();
			screen_normal_cols(255);
			screen_wobble(4);
			do_wobble();
         do_firework();
		} else if (counter < 3650) {
      	loc = counter-3350;
			screen_fadeup(300-loc);
			screen_standard();
  			screen_wobble(4);
			do_wobble();
		}
		if (counter > 600)
			draw_text(counter-600);

		counter++;

		/* swap buffer */
		DrawSync(0);	/* wait for end of drawing */
		VSync(0);	/* wait for the next V-BLNK */

		PutDrawEnv(&cdb->draw); /* update drawing environment */
		PutDispEnv(&cdb->disp); /* update display environment */
		/*DumpOTag(cdb->ot);	/* for debug */
/*		DrawOTag(cdb->ot+OTSIZE-1);	/* draw */
	}
	PadStop();
	ResetGraph(3);
	StopCallback();
	return 0;
}

int saw(int i, int max)
{
	int j = i % (2*max);
	if (j > max)
		j = (max*2)-j;
	return j;
}
