/* Simon Frankau, and Now3d's demo doodah. Woah. */

#include <stdlib.h>
#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#include "Addrs.h"

#define POLY_COUNT 200

static LINE_F2 star;

/* Tris! */
struct {
	int x, y, vx, vy;
	int r, g, b;
} stars[POLY_COUNT];

void do_phantom(int dist)
{
	int i, j, colour_scale = 64;

	int bast = (dist*256)/600;
	int bast2 = ((dist+64)*256)/600;
	bast = 256-bast;
	bast2 = 256-bast2;
	if (bast < 0)
		bast = 0;
	if (bast2 < 0)
		bast2 = 0;

	dist /= 4;

	if (dist < 150) {
		setXY4(&poly, (dist*160)/256, 256-dist,
					320-(dist*160)/256, 256-dist,
					(dist*160)/256, 320-(dist*320)/256,
					320-(dist*160)/256, 320-(dist*320)/256);
		setRGB0(&poly, bast2, bast2, 0);
		setRGB1(&poly, bast2, bast2, 0);
		setRGB2(&poly, bast, bast, 0);
		setRGB3(&poly, bast, bast, 0);
		DrawPrim(&poly);
	} else {
		colour_scale = 300+64 - dist*2;
		if (colour_scale<0)
			colour_scale = 0;
	}

	for(i=0; i<STAR_COUNT; i++) {
		setXY2(&star, stars[i].x/64, stars[i].y, stars[i].x/64, stars[i].y);
		j = (stars[i].dist*colour_scale)/64;
		setRGB0(&star, j, j, j);
		stars[i].x = stars[i].x + stars[i].dist;
		if (stars[i].x > 320*64)
			stars[i].x -= 320*64;
      DrawPrim(&star);
	}
}

void init_phantom_stuff(void)
{
	int i;

	RECT r = {768, 256, 256, 256};
	GsIMAGE tim;

	/* Load Tim. */
	GsGetTimInfo(PHANTOM_TIM, &tim);
	LoadImage(&r, tim.pixel+1);

   SetLineF2(&star);
	SetPolyGT4(&poly);
	setUV4(&poly, 0,0, 255,0, 0,255, 255,255);
	setTPage(&poly,2,0,768,256);

	for (i=0; i<STAR_COUNT; i++) {
		stars[i].x = (rand())%(320*64);
		stars[i].y = (rand()>>6)& 0xff;
		stars[i].dist = (rand()>>6)&0xff;
	}
}

