/* modplay.c - dynamic modplay loader and driver
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <dlfcn.h>
#include <stdio.h>

#include "video.h"
#include "screen.h"
#include "file.h"

int video_register_driver ( struct screen* s, char* so_path, char* driverlibname )
{
    void *handle;
    char *error;

    handle = dlopen ( so_file ( so_path, driverlibname ), RTLD_NOW );

    if ( handle == NULL )
    {
        fprintf ( stderr, "invtro: %s\n", dlerror() );
        s->driver.disfunctional = 1;
        return -1;
    }

    s->driver.init = dlsym ( handle, "init" );
    s->driver.done = dlsym ( handle, "done" );
    s->driver.set_mode = dlsym ( handle, "set_mode" );
    s->driver.update_buffer = dlsym ( handle, "update_buffer" );
    s->driver.update_palette = dlsym ( handle, "update_palette" );
    s->driver.poll_input = dlsym ( handle, "poll_input" );

    if ( ( error = dlerror() ) != NULL )
    {
        fprintf ( stderr, "invtro: %s\n", error );
        s->driver.disfunctional = 1;
        return -1;
    }
    
    s->driver.disfunctional = 0;
    return 0;
}

int video_init ( struct screen* s )
{
    if ( s->driver.disfunctional ) return -1;
    return ( s->driver.init ( s ) );
}

void video_done ( struct screen* s )
{
    if ( s->driver.disfunctional ) return;
    s->driver.done ( s );
}

int video_set_mode ( struct screen* s, uint32 width, uint32 height, uint32 bpp )
{
    if ( s->driver.disfunctional ) return -1;
    return ( s->driver.set_mode ( s, width, height, bpp ) );
}

void video_update_buffer ( struct screen* s )
{
    if ( s->driver.disfunctional ) return;
    s->driver.update_buffer ( s );
}

void video_update_palette ( struct screen* s, uint32 begincolor, uint32 length )
{
    if ( s->driver.disfunctional ) return;
    s->driver.update_palette ( s, begincolor, length );
}

int video_poll_input ( struct screen* s )
{
    if ( s->driver.disfunctional ) return -1;
    return ( s->driver.poll_input ( s ) );
}
