/* modplay.c - dynamic modplay loader and driver
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <dlfcn.h>
#include <stdio.h>

#include "modplay.h"
#include "file.h"

int modplay_register ( struct music* m, char* so_path )
{
    void *handle;
    char *error;
    
    handle = dlopen ( so_file ( so_path, "libmikmod-plugin.so.0" ), RTLD_NOW );

    if (handle == NULL)
    {
        fprintf ( stderr, "invtro: %s\n", dlerror() );
        m->disfunctional = 1;
        return -1;
    }

    m->driver.load = dlsym ( handle, "load" );
    m->driver.init = dlsym ( handle, "init" );
    m->driver.done = dlsym ( handle, "done" );
    m->driver.update = dlsym ( handle, "update" );
    m->driver.set_volume = dlsym ( handle, "set_volume" );
    m->driver.set_pattern = dlsym ( handle, "set_pattern" );
    m->driver.start = dlsym ( handle, "start" );
    m->driver.stop = dlsym ( handle, "stop" );

    if ( ( error = dlerror() ) != NULL )
    {
        fprintf ( stderr, "invtro: %s\n", error );
        m->disfunctional = 1;
        return -1;
    }
    
    m->disfunctional = 0;
    return 0;
}

int modplay_init ( struct music* m )
{
    if ( m->disfunctional ) return -1;
    return ( m->driver.init ( m ) );
}

void modplay_done ( struct music* m )
{
    if ( m->disfunctional ) return;
    m->driver.done ( m );
}

int modplay_load ( struct music* m, char* path, char* filename )
{
    if ( m->disfunctional ) return -1;
    return ( m->driver.load ( m, path, filename ) );
}

void modplay_update ( struct music* m )
{
    if ( m->disfunctional ) return;
    m->driver.update ( m );
}

void modplay_start ( struct music* m )
{
    if ( m->disfunctional ) return;
    m->driver.start ( m );
}

void modplay_stop ( struct music* m )
{
    if ( m->disfunctional ) return;
    m->driver.stop ( m );
}

void modplay_set_volume ( struct music* m, int volume )
{
    if ( m->disfunctional ) return;
    m->driver.set_volume ( m, volume );
}

void modplay_set_pattern ( struct music* m, int pattern )
{
    if ( m->disfunctional ) return;
    m->driver.set_pattern ( m, pattern );
}
