/* font.h - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __FONT_H
#define __FONT_H

#include "types.h"
#include "image.h"

#define FONT_NOCHAR -1

/* the small writerpane font */
#define FONT1_HEIGHT 8
#define FONT1_WIDTH  8
#define FONT1_OFFSET_X 0
#define FONT1_OFFSET_Y 0
#define FONT1_CHARS 58

/* the bigger scroller font */
#define FONT2_HEIGHT 16
#define FONT2_WIDTH  14
#define FONT2_OFFSET_X 0
#define FONT2_OFFSET_Y 8
#define FONT2_CHARS 60

struct font {
    uint32 n; /* number of characters */
    uint32 width,height; /* size of one character */
    uint8** buffer;
    int map[256]; /* ascii to font map */
};

void freeFont( struct font* ); 

void createFont1( struct font* f, struct image* i );
void createFont2( struct font* f, struct image* i );

void drawChar( struct image* i, struct font* f, uint32 destx, uint32 desty, char character);
void drawTransparentChar( struct image* i, struct font* f, uint32 destx, uint32 desty, char character);

void font_draw_hclip ( struct image* i, struct font* f, sint32 destx, sint32 desty, char character);

#endif /* __FONT_H */
