/* font.c - 
   Copyright (C) 1999 .
    <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>

#include "screen.h"
#include "font.h"
#include "types.h"

        /* genFontMap()
           generates a translation table from the ascii map above to
           the index used by the font, especially useful for calling
           drawChar() below */

void genFontMap( struct font* font, char *map )
{
    int i,j;
    
    for ( i = 0; i < 256; i++ ) {
        font->map[i] = FONT_NOCHAR;
        
        for (j = 0; j < strlen(map); j++) {
            if ( map[j] == i )
                font->map[i] = j;
        }
    }
}

        /* createFont?()
           convert the image to usable character chunks */

void createFont1( struct font* font, struct image* image )
{
            /* the small blue font */
    char c;
    uint32 x,y;
    uint8* dest;

    font->width = FONT1_WIDTH;
    font->height = FONT1_HEIGHT;
    font->n = FONT1_CHARS;

    genFontMap( font, "abcdefghijklmnopqrstuvwxyz!?@\";:1234567890. \\/-&ABC,()'P$F" );

    font->buffer = malloc( sizeof(uint8*) * FONT1_CHARS );

    for (c = 0; c < FONT1_CHARS; c++)
    {
        font->buffer[(int) c] = malloc( FONT1_HEIGHT*FONT1_WIDTH );
        dest = font->buffer[(int) c];
        
        for (y = 0; y < FONT1_HEIGHT; y++)
        {
            for (x = 0; x < FONT1_WIDTH; x++)
            {
                *dest++ = image->buffer[ FONT1_OFFSET_X + FONT1_WIDTH*c + x + (FONT1_OFFSET_Y+y) * image->width ];
            }
        }
    }
}

void createFont2( struct font* font, struct image* image )
{
            /* the big grey font */
    char c;
    uint32 x,y;
    uint8* dest;

    font->width = FONT2_WIDTH;
    font->height = FONT2_HEIGHT;
    font->n = FONT2_CHARS;

    genFontMap( font, "abcdefghijklmnopqrstuvwxyz-+;1234567890?P\"!@SWJ:DC)(.,/'*= " );

    font->buffer = malloc( sizeof(uint8*) * FONT2_CHARS );

    for (c = 0; c < FONT2_CHARS; c++)
    {
        font->buffer[(int) c] = malloc( FONT2_HEIGHT*FONT2_WIDTH );
        dest = font->buffer[(int) c];
        
        for (y = 0; y < FONT2_HEIGHT; y++)
        {
            for (x = 0; x < FONT2_WIDTH; x++)
            {
                *dest++ = image->buffer[ FONT2_OFFSET_X + FONT2_WIDTH*c + x + (FONT2_OFFSET_Y+y) * image->width ];
            }
        }
    }
}

void freeFont( struct font* f )
{
}

void drawChar( struct image* i, struct font* f, uint32 destx, uint32 desty, char character)
{
    uint8* dest, *src;
    int x,y;
    int code;

    code = f->map[(int) character];
    dest = i->buffer + destx + SCR_WIDTH * desty;
    
    if (code != FONT_NOCHAR) {
        
        src = f->buffer[code];
        
        for ( y = 0; y < f->height; y++)
        {
            for ( x = 0; x < f->width; x++)
                *(dest+x) = *src++;
            dest += i->width;
        }
    }
    else
    {
                /* space makes for special case scenario :) */
        
        for ( y = 0; y < f->height; y++)
        {
            for ( x = 0; x < f->width; x++)
                *(dest+x) = 0;
            dest += i->width;
        }
    }
}

void drawTransparentChar( struct image* i, struct font* f, uint32 destx, uint32 desty, char character)
{
    uint8* dest, *src;
    int x,y;
    int code;
    uint8 c;

    code = f->map[(int) character];
    dest = i->buffer + destx + SCR_WIDTH * desty;
    
    if (code != FONT_NOCHAR) {
        
        src = f->buffer[code];
        
        for ( y = 0; y < f->height; y++)
        {
            for ( x = 0; x < f->width; x++)
            {
                c = *src++;
                
                        /* major hack here. the font background ought
                           to be 0 not 130,.. have to tell this to the
                           graphician someday */
                           
                if (c != 130)
                    *(dest+x) = c;
            }
            dest += i->width;
        }
    }
}

void font_draw_hclip ( struct image* i, struct font* f, sint32 destx, sint32 desty, char character)
{
    uint8 *dest, *src, *dest_ptr, *src_ptr;
    
    int x,y;
    int code;

    int x0, x1;
    
    int src_stride = f->width;
    int dest_stride = i->width;

    code = f->map[(int) character];
    dest_ptr = i->buffer + destx + SCR_WIDTH * desty;

    if ( code != FONT_NOCHAR ) {
        
        src_ptr = f->buffer[code];
        x0 = 0;
        x1 = f->width;

                /* clip left */
        if ( destx < 0 )
        {
            if ( -destx > f->width )
                return;
            
            dest_ptr = i->buffer + SCR_WIDTH * desty;
            src_ptr += -destx;

            x1 = destx + f->width;
        }
        
                /* clip right */
        if ( destx + f->width > 319 )
        {
            if ( destx > 319 )
                return;
            
            x0 = destx;
            x1 = 319;
        }
        
        for ( x = x0; x < x1; x++)
        {
            dest = dest_ptr ++;
            src = src_ptr ++;
            for ( y = 0; y < f->height; y++)
            {
                *dest = *src;
                dest += dest_stride;
                src += src_stride;
            }
        }
    }
}

