/* video.h - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __VIDEO_H
#define __VIDEO_H

#include "types.h"

#define INPUT_NOKEY 0 /* nokey and pokey sitting in a tree, k.i.s.s.i.n.g. */
#define INPUT_LEFT  1
#define INPUT_RIGHT 2
#define INPUT_UP  3
#define INPUT_DOWN  4
#define INPUT_QUIT  5
#define INPUT_CONTINUE 6
#define INPUT_BACK 7

struct screen;

struct video_driver {

    int disfunctional;

    int (*init) ( struct screen* s );
    void (*done) ( struct screen* s );

    int (*set_mode) ( struct screen* s, uint32 width, uint32 height, uint32 bitdepth );
    
    void (*update_buffer) ( struct screen* s );
    void (*update_palette) ( struct screen* s, uint32 begincolor, uint32 length );

    int (*poll_input) ( struct screen* s );
};
    
int video_register_driver ( struct screen* s, char* so_path, char* driverlibname );
int video_init ( struct screen* s );
void video_done ( struct screen* s );
int video_set_mode ( struct screen* s, uint32 width, uint32 height, uint32 bpp );
void video_update_buffer ( struct screen* s );
void video_update_palette ( struct screen* s, uint32 begincolor, uint32 length );

int video_poll_input ( struct screen* s );

#endif /* __VIDEO_H */

