/* ggi.c - libggi support for the invtro 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define PLUGIN_NAME "invtro, svgalib-plugin: "

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "screen.h"

#include <vga.h>

int init ( struct screen* s )
{
    vga_init ();
    
    s->image = malloc ( sizeof (struct image) );
    if (!s->image) {
        fprintf ( stderr, PLUGIN_NAME "could not get memory for screen\n");
        return 1;
    }
    
    s->image->width = SCR_WIDTH;
    s->image->height = SCR_HEIGHT;

    s->image->buffer = (uint8*) malloc( SCR_WIDTH * SCR_HEIGHT );
    if (!s->image->buffer) {
        fprintf ( stderr, PLUGIN_NAME "could not get memory for screen\n");
        return 1;
    }
    return 0;
}

int set_mode ( struct screen* s, uint32 width, uint32 height, uint32 bpp )
{
    int mode;
    
    switch ( s->zoom_factor ) {
            case 1:
                mode = G320x200x256;
                break;
            case 2:
                mode = G640x480x256;
                break;
            default:
                fprintf ( stderr, PLUGIN_NAME "the svgalib plugin only allows zoom factor 1 and 2.\n");
                return -1;
    }

    if ( !vga_hasmode ( mode ) )
    {
        fprintf ( stderr, PLUGIN_NAME "svgalib mode not available, try another zoom factor\n" );
        return -1;
    }

    vga_setmode ( mode );

    return 0;
}

void done ( struct screen* s )
{
    vga_setmode ( TEXT );
}

void zoom_screen_2(struct screen *s)
{
    uint32 width;
    uint8 pixel;
    uint8 *src, *dest;
    uint32 x,y;
    
    width = s->image->width * s->zoom_factor;
    src = s->image->buffer;
    
    for (y=0; y < s->image->height; y++)
    {
        dest = s->dummyZoomLineBuffer;
        for (x=0; x < s->image->width; x++)
        {
            pixel = *src++;
            *dest++ = pixel;
            *dest++ = pixel;
        }
        vga_drawscansegment ( s->dummyZoomLineBuffer, 0, y*2, width );
        vga_drawscansegment ( s->dummyZoomLineBuffer, 0, y*2+1, width );
    }
}

void update_buffer ( struct screen* s )
{
    int y;
    uint8* buf;
    
    if (! s->directBuffered ) {

        if ( s->wait_retrace )
            vga_waitretrace();
        
        if ( s->zoom_factor == 2 )
        {
            zoom_screen_2( s );
        }
        else 
        {
            buf = s->image->buffer;
            for ( y = 0; y < SCR_HEIGHT; y++ )
            {
                vga_drawscansegment ( buf, 0, y, SCR_WIDTH );
                buf += s->image->width;
            }
        }
    }
}

void update_palette ( struct screen* s, uint32 begincolor, uint32 length )
{
    int svgacolormap[3*256];
    int i;
    
    if ( s->paletteDirty ) {
        for (i = begincolor; i < begincolor+length; i++)
        {
            svgacolormap[i*3] = s->colormap[i].r >> 10;
            svgacolormap[i*3+1] = s->colormap[i].g >> 10;
            svgacolormap[i*3+2] = s->colormap[i].b >> 10;
        }

        vga_setpalvec ( begincolor, length, &(svgacolormap[begincolor*3]) );
        s->paletteDirty = 0;
    }
    
}

int poll_input ( struct screen* s )
{
#ifdef USE_RAW_KEYBOARD
            /* perhaps it's nice to support all the other keys here too */
#endif
    switch ( vga_getkey () ) {
            case 27:
                return INPUT_QUIT;
            case 32:
                return INPUT_CONTINUE;
    }
    return INPUT_NOKEY;
}
