/* scroller.c - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>

#include "screen.h"
#include "types.h"
#include "image.h"
#include "scroller.h"
#include "text.h"
#include "framecount.h"

int initScroller(struct scroller* s, struct screen* screen )
{
    return 0;
}

int loadScroller(char* datapath, struct scroller* s)
{
    int n;

    s->txt = malloc(SCROLL_MAXLENGTH);
    if (!s->txt)
        return 1;
    
    n = loadScrollText(datapath, s->txt, SCROLL_MAXLENGTH);
    s->txt_length = n;
    
    if (n <= 0)
        return 1;
    else
        return 0;
}

void updateScroller ( struct scroller* s, double frame )
{
    int i;
    int amount_chars; /* number of chars to draw this time */

    int pixel_offset; /* pixel precise drawing offset */
    int char_offset; /* offset in the scrolltext string */

    amount_chars = ( 320 / s->font->width ) + 1;
    char_offset = ( (int) frame / s->font->width ) % ( s->txt_length - 25 );
    pixel_offset = s->font->width - (int) frame % s->font->width;

            /* draw the string */
    for ( i = -1; i < amount_chars; i ++ )
    {
        font_draw_hclip ( s->dest, s->font,
                          i * s->font->width + pixel_offset, 0, /* x,y position */
                          s->txt[ char_offset + i + 1 ] ); /* character number */
    }
}

