/* screen.c - screen support for the invtro using libggi
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "screen.h"
#include "video.h"

int screen_init ( struct screen* s, char* so_path )
{
            /* first some general settings */
    
    s->directBuffered = 0;
    s->paletteDirty = 0;

    s->dummyZoomLineBuffer = malloc( s->zoom_factor * SCR_WIDTH );
    
            /* first try to use libggi,
               if that fails then and the user is root try svgalib
               if all else fails try x11 in 8bpp mode */

    if ( s->preferred_target & SCREEN_TARGET_LIBGGI )
    {
        if ( ! video_register_driver ( s, so_path, "libggi-plugin.so" ) )
        {
            if ( ! video_init ( s ) )
                return 0;
        }
    }

    if ( s->preferred_target & SCREEN_TARGET_SVGALIB )
    {
        if ( getuid () != 0 )
        {
            fprintf ( stderr, "invtro: you need to have root privileges to use the svgalib driver.\n");
        }
        else
        {
            if ( !video_register_driver ( s, so_path, "svgalib-plugin.so" ) )
            {
                if ( ! video_init ( s ) )
                    return 0;
            }
        }
    }

    if ( s->preferred_target & SCREEN_TARGET_X11 )
    {
        if ( ! video_register_driver ( s, so_path, "x11-plugin.so" ) )
        {
            if ( ! video_init ( s ) )
                return 0;
        }
    }

    return -1;
}

void screen_clear (struct screen* s)
{
    int i;
    for (i = 0; i < SCR_WIDTH*SCR_HEIGHT; i++)
        s->image->buffer[i] = 0;
}

void screen_fade ( struct screen* s, struct palette_color* to, float perunage)
{
    int color;
    float r,g,b;

    for (color = 0; color < 255; color++) {
        r = perunage * ((float) to[color].r);
        s->colormap[color].r = r; 
        g = perunage * ((float) to[color].g);
        s->colormap[color].g = g; 
        b = perunage * ((float) to[color].b);
        s->colormap[color].b = b; 
    }
    s->paletteDirty = 1;
}

void screen_set_color ( struct screen* s, uint8 color, sint32 r, sint32 g, sint32 b )
{
    s->colormap[color].r = r;
    s->colormap[color].g = g;
    s->colormap[color].b = b;
    s->paletteDirty = 1;
}
