/* graphics.c - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "graphics.h"
#include "image.h"
#include "font.h"
#include "file.h"

int loadGraphics( char* datapath, struct graphics* g )
{
    struct image fontImage;
    
    if ( loadImage( &fontImage, data_file(datapath,IMAGEFILE_FONT) ) ) 
        return 1;
    createFont1( &g->writerFont, &fontImage ); 
    createFont2( &g->scrollerFont, &fontImage );
    
    freeImage( &fontImage ); 

    if ( loadImage( &g->creditsImage, data_file(datapath,IMAGEFILE_CREDITS) ) )
        return 1;
    if ( loadImage( &g->titleImage, data_file(datapath,IMAGEFILE_TITLE) ) )
        return 1;
    if ( loadImage( &g->logoImage, data_file(datapath,IMAGEFILE_LOGO) ) )
        return 1;
    if ( loadImage( &g->backgroundImage, data_file(datapath,IMAGEFILE_BACKGROUND) ) )
        return 1;
    if ( loadImage( &g->textframeImage, data_file(datapath,IMAGEFILE_TEXTFRAME) ) )
        return 1;
    if ( loadImage( &g->endImage, data_file(datapath,IMAGEFILE_ENDIMAGE) ) )
        return 1;

    g->scroll.font = &g->scrollerFont;
    if ( loadScroller( datapath, &g->scroll ) )
        return 1;

    return 0;
}

int initGraphics( struct graphics* g, struct screen* s )
{
    g->titleImage.dest = s->image;
    g->logoImage.dest = s->image;
    g->backgroundImage.dest = s->image;
    g->textframeImage.dest = s->image;
    g->endImage.dest = s->image;
    g->creditsImage.dest = s->image;
    g->scroll.dest = s->image;

    initScroller( &g->scroll, s );

    return 0;
}

void doneGraphics( struct graphics* g )
{
    freeFont( &g->writerFont );
    freeFont( &g->scrollerFont );
}


