/* file.c - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "file.h"

char* get_data_path ( char* runningfilename, char** path_list, char* noinst_path )
{
    char* datapath;
    char* ptr;
    int i;
    struct stat statbuf;

    datapath = malloc( strlen(runningfilename) + 10 );
    strcpy(datapath, runningfilename);
    
    i = 0;
    while (path_list[i] != NULL) {
        if (!stat(path_list[i], &statbuf))
        {
            free(datapath);
            datapath = path_list[i];
            
            return datapath;
        }
        i++;
    }
        
    ptr = (char*) strrchr(datapath,'/');
    if (!ptr)
    {
        free(datapath);
        datapath = malloc(9);
        strcpy(datapath,noinst_path);
    }
    else
    {
        strcpy(ptr+1,noinst_path);
    }
        
    return datapath; 
}

char* get_so_path ( char* runningfilename, char** path_list, char* noinst_path )
{
    char* sopath;
    char* ptr;
    int i;
    struct stat statbuf;

    sopath = malloc( strlen(runningfilename) + 10 );
    strcpy(sopath, runningfilename);
    
    ptr = (char*) strrchr(sopath,'/');
    
    i = 0;
    while (path_list[i] != NULL) {
        if (!stat(path_list[i], &statbuf))
        {
            free(sopath);
            sopath = path_list[i];
            
            return sopath;
        }
        i++;
    }
        
    if (!ptr)
    {
        free(sopath);
        sopath = malloc(21);
        strcpy(sopath,noinst_path);
    }
    else
    {
        *ptr = '/';
        ptr++;
        strcpy(ptr,noinst_path);
    }

    return sopath; 
}

char* data_file (char *data_path, char* filename)
{
    static char* buf = NULL;
    
    free(buf);
    buf = malloc( strlen(data_path) + strlen(filename) + 1);
    if (!buf)
    {
        fprintf( stderr, "invtro: Not enough memory for concatenating filename to the datapath (ridiculous that i had to write an error message for this, by the way.)\n" );
        exit(1);
    }
    
    strcpy(buf, data_path);
    strcat(buf, filename);
    
    return buf;
}

char* so_file (char *so_path, char* filename)
{
    static char* buf = NULL;
    
    free(buf);
    buf = malloc( strlen(so_path) + strlen(filename) + 1);
    if (!buf)
    {
        fprintf( stderr, "invtro: Not enough memory for concatenating filename to the datapath\n" );
        exit(1);
    }
    
    strcpy(buf, so_path);
    strcat(buf, filename);
    
    return buf;
}

