/* endscreen.c - unoptimized endscreen effect
   Copyright (C) 1999 .
    <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <math.h>

#include "endscreen.h"
#include "framecount.h"

#define ENDSCREEN_FRAMENR_START_FADEIN 0
#define ENDSCREEN_FRAMENR_STOP_FADEIN 64
#define ENDSCREEN_FRAMENR_START_FADEOUT 230
#define ENDSCREEN_FRAMENR_QUIT 300

#define WIDTH 73
#define HEIGHT 21

#define X_OFFSET (SCR_WIDTH/2)-(WIDTH/2)
#define Y_OFFSET -100

void wobble( struct image* i, int frame )
{
    int x,y;
    int ofs;
    int yofs;
    int height;
    float f;

            /* heaviside frame number */
    if ( frame < 280 )
        f = frame / 2.0;
    else
        f = 280;

    for (y = 0; y < SCR_HEIGHT; y++)
    {
        ofs = y * SCR_WIDTH;
        for (x = 0; x < WIDTH; x++)
            i->dest->buffer[ofs+x+X_OFFSET] = 0;
    }
    
    for (x = 0; x < WIDTH; x++)
    {
                /* you shouldn't take this function too seriously */
        yofs = sin ( frame / 30.0 + x / 13.0 * (140.0 - f)/140.0 ) * 30.0
            * (140.0-f)/140.0 + frame / 2.0 + 30.0;
                /* so we don't */
        yofs = 100;
        
        if ( yofs < SCR_HEIGHT )
        {
            if ( yofs < (SCR_HEIGHT-HEIGHT) )
                height = HEIGHT;
            else
                height = SCR_HEIGHT-yofs;
            
            ofs = X_OFFSET + yofs*SCR_WIDTH + x;
            for (y = 0; y < height; y++)
            {
                i->dest->buffer[ofs + y*SCR_WIDTH] = i->buffer[x+y*i->width];
            }
        }
    }
}

void doEndScreen( struct screen* s, struct graphics* g, struct music* m )
{
    int frame, wobble_frame = 0.0;
    int color;
    struct palette_color destPal[256];
    float fadePerunage;
    struct frame_count fc;

    for ( color = 0; color < 255; color++ ) 
    {
        destPal[color].r = g->endImage.palette[color].r;
        destPal[color].g = g->endImage.palette[color].g;
        destPal[color].b = g->endImage.palette[color].b;

        screen_set_color (s, color, 0, 0, 0);
    }

    screen_clear ( s );
    
    video_update_palette ( s,0,255 );
    video_update_buffer ( s );

    modplay_set_volume ( m, 128 );
    modplay_set_pattern ( m, 20 );
    
    frame = 0;
    init_frame_counter ( &fc, SCR_REFRESH_RATE );

    while ( frame < ENDSCREEN_FRAMENR_QUIT ) {

        frame = wait_next_frame ( &fc );

        if ( frame > ENDSCREEN_FRAMENR_START_FADEIN )
        {
            wobble_frame = frame - ENDSCREEN_FRAMENR_START_FADEIN;
            if ( frame < ENDSCREEN_FRAMENR_STOP_FADEIN )
            {
                fadePerunage = frame * 0.02;
                if (fadePerunage > 1.0)
                    fadePerunage = 1.0;
                screen_fade ( s, destPal, fadePerunage );
            }
            else if ( frame > ENDSCREEN_FRAMENR_START_FADEOUT )
            {
                fadePerunage = 1.0 - (frame-ENDSCREEN_FRAMENR_START_FADEOUT) * 0.02;
                if (fadePerunage < 0.0)
                    fadePerunage = 0.0;
                screen_fade(s, destPal, fadePerunage);
            }
        }
            
        wobble( &g->endImage , wobble_frame );

        video_update_palette (s,1,2);
        video_update_buffer (s);
        
        modplay_update ( m );
    }
    sleep(1);
}

