/* title.c - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <math.h>

#include "types.h"
#include "image.h"
#include "modplay.h"
#include "graphics.h"
#include "credits.h"
#include "screen.h"
#include "framecount.h"

#define STATE_NEXT_PICTURE      0
#define STATE_FADE_IN           1
#define STATE_IDLE              2
#define STATE_FADE_OUT          3
#define STATE_QUIT              4

enum
{
    PICTURE_SMOKE_AND_PROOP = 0,
    PICTURE_PRESENT,
    PICTURE_AN_INVTRO_TO
};

void doCredits( struct screen* s, struct graphics* g, struct music* m )
{
    int color;

    int state;
    int picture;
    
    struct palette_color destPal[256];
    float fadePerunage = 0.0;
    struct frame_count fc;
    
            /* set up palette for the credits */
    for ( color = 0; color < 256; color++ ) 
    {
        destPal[color].r = g->creditsImage.palette[color].r;
        destPal[color].g = g->creditsImage.palette[color].g;
        destPal[color].b = g->creditsImage.palette[color].b;

        screen_set_color ( s, color, 0,0,0 );
    }
    video_update_palette ( s, 0, 255 );
    video_update_buffer ( s );
    sleep(1);

    init_frame_counter ( &fc, SCR_REFRESH_RATE );
    
    state = STATE_NEXT_PICTURE;
    picture = -1;
    
    while (state != STATE_QUIT) {

        wait_next_frame ( &fc );

        switch ( state ) {
                case STATE_NEXT_PICTURE:
                    
                    picture++;
                    state = STATE_FADE_IN;
                    
                    switch ( picture ) {
                            case PICTURE_SMOKE_AND_PROOP:
                                drawImage( &g->creditsImage, 0, 0, 320, 200, 0, 0 );
                                break;
                            case PICTURE_PRESENT:
                                drawImage( &g->creditsImage, 0, 0, 320, 200, 320, 0 );
                                break;
                            case PICTURE_AN_INVTRO_TO:
                                drawImage( &g->creditsImage, 0, 0, 320, 200, 0, 200 );
                                break;
                            default:
                                state = STATE_QUIT;
                    }
                    break;
                    
                case STATE_FADE_IN:

                    fadePerunage = get_frame_counter ( &fc ) * 0.02;
                    if (fadePerunage > 1.0)
                    {
                        fadePerunage = 1.0;
                        state = STATE_IDLE;
                        reset_frame_counter ( &fc );
                    }
                    screen_fade( s, destPal, fadePerunage );

                    break;

                case STATE_IDLE:

                    if ( get_frame_counter ( &fc ) > 70.0 )
                    {
                        state = STATE_FADE_OUT;
                        reset_frame_counter ( &fc );
                    }
                    
                    break;
                    
                case STATE_FADE_OUT:

                    fadePerunage = 1.0 - get_frame_counter ( &fc ) * 0.02;
                    if (fadePerunage < 0.0)
                    {
                        state = STATE_NEXT_PICTURE;
                        fadePerunage = 0.0;
                        reset_frame_counter ( &fc );
                    }
                    screen_fade( s, destPal, fadePerunage );
                    
                    break;
        }                        
            
        switch ( video_poll_input(s) ) {
                case INPUT_CONTINUE:
                case INPUT_QUIT:
                    state = STATE_QUIT;
                    break;
        }

        modplay_update ( m );
        
        video_update_palette ( s, 0, 255 );
        video_update_buffer ( s );
    }
}
