#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <time.h>
#include <math.h>

#include "j2d.h"

#define CUBE_PI 3.142

typedef struct {
    float x, y, z;
    float rx, ry, rz;
    int colour, px, py;
} point_struct;

#define CUBE_TABLE 1024

void main(void)
{
    int i, x, y, xai, yai, zai;
    char *pic, *pal, *vsc;
    FILE *fptr;
    point_struct *point;
    clock_t start;
    float *cube_cos, *cube_sin, angle, tx, ty, tz;
    
    J2D_ControllerInfo cont_info;
    J2D_ModeInfo mode_info;
    
    J2D_MakeWorkspace();
    J2D_GetControllerInfo(&cont_info);
    J2D_GetGraphicsMode(&mode_info, 320, 200, J2D_8BIT);

    pal = malloc(1024);
    pic = malloc(64000);
    vsc = malloc(64000);
    point = malloc(64000*sizeof(point_struct));
    cube_cos = malloc(CUBE_TABLE * sizeof(float));
    cube_sin = malloc(CUBE_TABLE * sizeof(float));

    fptr = fopen("gaf.tga","rb"); if (!fptr) exit(0);

    for (i=0; i<18; i++) fgetc(fptr);

    for (i=0; i<256; i++)
    {
        pal[i*4 + 0] = fgetc(fptr)/4;
        pal[i*4 + 1] = fgetc(fptr)/4;
        pal[i*4 + 2] = fgetc(fptr)/4;
        pal[i*4 + 3] = 0;
    }

    for (i=63999; i>=0; i--) pic[i] = fgetc(fptr);

    fclose(fptr);

    i=0;

    for (y=0; y<200; y++)
    {
        for (x=0; x<320; x++)
        {
            point[i].x=-160+x;
            point[i].y=-100+y;
            point[i].z=50;
            point[i].colour=pic[i++];
        }
    }

    for (i=0; i<CUBE_TABLE; i++)
    {
        cube_cos[i] = cos((2.0 * CUBE_PI * i) / CUBE_TABLE);
        cube_sin[i] = sin((2.0 * CUBE_PI * i) / CUBE_TABLE);
    }

    J2D_SetMode();
    J2D_SetPalette6bit(pal);
    J2D_SetVirtualScreenSize(320,200);

    start = clock();

    do
    {
        angle = 0.001*(clock() - start);

        xai = ((int) (0.015 * angle * CUBE_TABLE))%CUBE_TABLE;
        yai = ((int) (0.030 * angle * CUBE_TABLE))%CUBE_TABLE;
        zai = ((int) (0.060 * angle * CUBE_TABLE))%CUBE_TABLE;

        J2D_Clear256c(vsc, 0);

        for (i=0; i<64000; i++)
        {
            tx = point[i].x; ty = point[i].y;
            point[i].rx = tx*cube_cos[zai] + ty*cube_sin[zai];
            point[i].ry = ty*cube_cos[zai] - tx*cube_sin[zai];

            tx = point[i].rx; tz = point[i].y;
            point[i].rx = tx*cube_cos[zai] + tz*cube_sin[zai];
            point[i].rz = tz*cube_cos[zai] - tx*cube_sin[zai];

            ty = point[i].ry; tz = point[i].rz;
            point[i].ry = ty*cube_cos[zai] + tz*cube_sin[zai];
            point[i].rz = tz*cube_cos[zai] - ty*cube_sin[zai];

            point[i].px = 160 + (256*point[i].rx) / (256+point[i].rz);
            point[i].py = 100 + (256*point[i].ry) / (256+point[i].rz);

            if (point[i].px>=0 && point[i].px<320 && point[i].py>=0 && point[i].py<200)
            {
                vsc[320*point[i].py+point[i].px] = point[i].colour;
            }
        }

        J2D_Update256c(vsc,0,0);
    }
    while (clock()-start < 10000);

    do
    {
        angle = 0.001*(clock() - start);

        xai = ((int) (0.015 * angle * CUBE_TABLE))%CUBE_TABLE;
        yai = ((int) (0.030 * angle * CUBE_TABLE))%CUBE_TABLE;
        zai = ((int) (0.060 * angle * CUBE_TABLE))%CUBE_TABLE;

        J2D_Clear256c(vsc, 0);

        for (i=0; i<64000; i++)
        {
            point[i].z += (i/200)*cube_sin[xai];
//            point[i].y += (i%320)*cube_sin[yai];

            tx = point[i].x; ty = point[i].y;
            point[i].rx = tx*cube_cos[zai] + ty*cube_sin[zai];
            point[i].ry = ty*cube_cos[zai] - tx*cube_sin[zai];

            tx = point[i].rx; tz = point[i].y;
            point[i].rx = tx*cube_cos[zai] + tz*cube_sin[zai];
            point[i].rz = tz*cube_cos[zai] - tx*cube_sin[zai];

            ty = point[i].ry; tz = point[i].rz;
            point[i].ry = ty*cube_cos[zai] + tz*cube_sin[zai];
            point[i].rz = tz*cube_cos[zai] - ty*cube_sin[zai];

            point[i].px = 160 + (256*point[i].rx) / (256+point[i].rz);
            point[i].py = 100 + (256*point[i].ry) / (256+point[i].rz);

            if (point[i].px>=0 && point[i].px<320 && point[i].py>=0 && point[i].py<200)
            {
                vsc[320*point[i].py+point[i].px] = point[i].colour;
            }
        }

        J2D_Update256c(vsc,0,0);
    }
    while (clock()-start < 30000);

    J2D_TextMode();
    
    J2D_KillWorkspace();
}
