{+ cos tables
 + added backpage support
 + asm for putpixel
 + Protected mode
 + PLookUp in Heap
 + Flip16
 }

{$n+}

Unit Effe34p;

Interface

procedure Init;
procedure Nextframe (bitmap,dest : word);
procedure DeInit;


Implementation
uses crt,dos,gfx3;

Const
VideoSeg : word = $a000;

var
a,b,c,i : longint;
di,x,y,ixy    : word;
rectxsize,rectysize : integer;
stepx,stepy,dy,dx,iy,ix   : array [0..320] of integer;

colorX,ColorY : byte;
color         : byte;

tstart,tstop : longint;

fl : Single;
pinx     : array [0..4,0..200] of integer;
piny     : array [0..4,0..320] of integer;

cosi     : array [0..4096] of integer;
sini     : array [0..4096] of integer;
base     : array [0..18] of integer;

pbackpage : pointer;
backpage  : word;

frame  : longint;
Pbitmap : pointer;
PLookUp : Pointer;
THelix,PHelix  : Pointer;
Helix,BitMap,LookUp : Word;
Q1,Q2,Sx,Sy   : Word;

{$i tflip}

Procedure Init;
Begin
Frame:=0;

for c:=0 to 4096 do begin
 cosi[c]:=round(128*cos(3.14/256*c));
 sini[c]:=round(128*sin(3.14/256*c));
end;

getmem (PLookUp,$ffff);
LookUP:=Seg(PlookUp^);

for i:=0 to 199 do
for c:=0 to 319 do mem[LookUp:i*320+c]:=round(199/(i+1)*c);
c:=0;
End;

Procedure NextFrame;
Begin
c:=c+5;

for y:=0 to 199 do begin
                    pinx[0,y]:=0;
                    pinx[1,y]:=100+cosi[(y+2*c) mod 4096] div 4;
                    pinx[2,y]:=150+sini[(y+1*c) mod 4096] div 8;
                    pinx[3,y]:=319;
                   end;

for x:=0 to 319 do begin
                    piny[0,x]:=0;
                    piny[1,x]:=50+sini[(x+c)  mod 4096] div 12;
                    piny[2,x]:=130+cosi[(x+4*c) mod 4096] div 12;
                    piny[3,x]:=200;
                   end;

for di:=0 to 319 do Begin
                     iy[di]:=1;                                 {iy=0}
                     dy[di]:=piny[iy[di],di];                   {dist to next Y line}
                     stepy[di]:=0;                              {zero step}
end;

for di:=0 to 199 do begin
                     ix[di]:=1;                                 {ix=0}
                     dx[di]:=pinx[ix[di],di];                   {dist to next X line}
                     stepx[di]:=0;                              {zero step}
                    End;


{******************************************************************}

inc (frame);
asm
mov si,20*320
end;

for di:=0 to 51200 do begin
 x:=di mod 320;
 y:=di div 320;

 if stepy[x]=dy[x] then begin                                  {ftasame se limit}
                         inc (iy[x]);                          {next line}
                         Dy[x]:=PinY[iy[x],x]-PinY[iy[x]-1,x]; {next line}
                         stepy[x]:=0;
                       end;


 if stepx[y]=dx[y] then begin
                         inc (ix[y]);
                         dx[y]:=PinX[ix[y],y]-PinY[ix[y]-1,y];
                         stepx[y]:=0;
                        end;

 inc (stepy[x]);                                               {inc step}
 inc (stepx[y]);

 {if odd(ix[y]) then Begin}
 Q1:=(Dy[x] Shl 6)+(Dy[x] shl 8)+Stepy[x];
 Q2:=(Dx[y] Shl 6)+(Dx[y] shl 8)+Stepx[y];
 {end else Begin
 Q1:=(Dy[x] Shl 6)+(Dy[x] shl 8)+Stepy[x];
 Q2:=(Dx[y] Shl 6)+(Dx[y] shl 8)+(dx[y]-Stepx[y])+1;
 End;}

 asm
    push si
    xor ax,ax
    xor bx,bx
    mov es,LookUp
    mov si,Q1
    mov di,Q2

    mov al,es:[si]  {Sy<--- Dy}
    mov bl,es:[di]  {Sx<--- Dx}

    mov si,ax
    shl si,6
    shl ax,8
    add si,ax       {si=SY*320}
    add si,bx       {si=si+SX}

    mov es,BitMap
    mov al,es:[si]
    pop si

    mov es,dest
    mov es:[si],al
    inc si
    end;
end;

end;

Procedure DeInit;
Begin
Freemem (PLookUp,$ffff);
End;

Begin
End.
