{ GFXMCGA unit, 1996 by REAL ICE. Based on the GFX2 unit by Denthor}

Unit GFXMCGA;

INTERFACE

USES crt;
CONST VidSeg = $A000;

TYPE Virtual = Array [1..64000] of byte;  { The size of our Virtual Screen }
     VirtPtr = ^Virtual;                  { Pointer to the virtual screen }

VAR Virscr : VirtPtr;                     { Our first Virtual screen }
    VirSeg  : word;                        { The segment of our virtual screen}

Procedure SetMode(gmode : byte);
Procedure Cls (Where:word;Col : Byte);
PROCEDURE Cls2(where:word;col:byte);
Procedure SetUpVirtual; {Get memory 4 virtual scr}
Procedure ShutDown;     {Free memory}
procedure flip(source,dest:Word);
Procedure Pal(Col,R,G,B : Byte);
Procedure GetPal(Col : Byte; Var R,G,B : Byte);
procedure WaitRetrace;
Procedure Hline (x1,x2,y:word;col:byte;where:word);
Procedure Line(X1,Y1,X2,Y2:Word; Color:Byte; segm:word);
Procedure DrawPoly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;where:word);
Procedure Putpixel (X,Y : Integer; Col : Byte; where:word);
Function Getpixel (X,Y : Integer; where:word) :Byte;
procedure Ellipse(Y,X,XRad,YRad: integer; Color: byte; Fill:Boolean;Seg:WORD);
Procedure DrawSprite(vseg : word; x,y : integer; w,h : byte; sprite : pointer;c:byte);
Procedure FadeIn(PalPic : Pointer);
Procedure FadeOut;


IMPLEMENTATION

{}
procedure SetMode(gmode : byte); Assembler;
asm
mov ah,00
mov al,[gmode]
int 10h
end;

{}
Procedure Cls2 (Where:word;Col : Byte); assembler;
   { This clears the screen to the specified color }
asm
   push    es
   mov     cx, 32000;
   mov     es,[where]
   xor     di,di
   mov     al,[col]
   mov     ah,al
   rep     stosw
   pop     es
End;

{}
PROCEDURE Cls(where:word;col:byte);ASSEMBLER;
Asm
   mov   es,[where]
   mov   dx,64000
   mov   al,col
   mov   ah,al
@L1:
   mov   di,dx
   mov   [es:di],ax
   sub   dx,2
   jnz   @l1
end;
{}
Procedure SetUpVirtual;
   { This sets up the memory needed for the virtual screen }
BEGIN
  GetMem (VirScr,64000);
  VirSeg := seg (virscr^);
END;

{}
Procedure ShutDown;
   { This frees the memory used by the virtual screen }
BEGIN
  FreeMem (VirScr,64000);
END;

{}
procedure flip(source,dest:Word); assembler;
  { This copies the entire screen at "source" to destination }
asm
  push    ds
  mov     ds, [Source]
  mov     es, [Dest]
  xor     si, si
  xor     di, di
  mov     cx, 32000
  rep     movsw
  pop     ds
end;

{}
Procedure Pal(Col,R,G,B : Byte); assembler;
  { This sets the Red, Green and Blue values of a certain color }
asm
   mov    dx,3c8h
   mov    al,[col]
   out    dx,al
   inc    dx
   mov    al,[r]
   out    dx,al
   mov    al,[g]
   out    dx,al
   mov    al,[b]
   out    dx,al
end;

{}
Procedure GetPal(Col : Byte; Var R,G,B : Byte);
  { This gets the Red, Green and Blue values of a certain color }
Var
   rr,gg,bb : Byte;
Begin
   asm
      mov    dx,3c7h
      mov    al,col
      out    dx,al

      add    dx,2

      in     al,dx
      mov    [rr],al
      in     al,dx
      mov    [gg],al
      in     al,dx
      mov    [bb],al
   end;
   r := rr;
   g := gg;
   b := bb;
end;

{}
procedure WaitRetrace; assembler;
  {  This waits for a vertical retrace to reduce snow on the screen }
label
  l1, l2;
asm
    mov dx,3DAh
{l1:
    in al,dx
    test al,08h
    jnz l1    }
l2:
    in al,dx
    test al,08h
    jz  l2
end;

{}
Procedure Hline (x1,x2,y:word;col:byte;where:word); assembler;
  { This draws a horizontal line from x1 to x2 on line y in color col }
asm
  mov   ax,where
  mov   es,ax
  mov   ax,y
  mov   di,ax
  shl   ax,8
  shl   di,6
  add   di,ax
  add   di,x1

  mov   al,col
  mov   ah,al
  mov   cx,x2
  sub   cx,x1
  shr   cx,1
  jnc   @start
  stosb
@Start :
  rep   stosw
end;

{Procedure HlineT (x1,x2,y:word;col:byte;where:word);
var LL:Integer;
begin
 for LL:=x1 to x2 do dec(mem[where:y*320+ll],col);
end;}

{}
Procedure HlineT2 (x1,x2,y:word;col:byte;where:word); assembler;
asm
  mov   es,where
  mov   ax,y
  mov   di,ax
  shl   di,8
  shl   ax,4
  sub   di,ax
  add   di,x1

  mov   cx,x2
  sub   cx,x1
  shr   cx,1

  mov   al,30
  stosb
@l1:
  mov   ax,es:[di]
  add   ah,col
  cmp   ah,64
  js    @d1
  sub   ah,64
 @d1:
  add   al,col
  cmp   al,64
  js    @d2
  sub   al,64
 @d2:
  mov   es:[di], ax
  add   di,2
  dec   cx
  jg   @l1

end;
Procedure Line(X1,Y1,X2,Y2:Word; Color:Byte; segm:word); Assembler;

Var DeX,DeY  : Integer;
    IncF     : Integer;
    Offset   : Word;

Asm
    Mov  AX,[X2]
    Sub  AX,[X1]
    JNC  @@Dont1
    Neg  AX
  @@Dont1:
    Mov  [DeX],AX
    Mov  AX,[Y2]
    Sub  AX,[Y1]
    JNC  @@Dont2
    Neg  AX
  @@Dont2:
    Mov  [DeY],AX

    Cmp  AX,[DeX]
    JBE  @@OtherLine

    Mov  AX,[Y1]
    Cmp  AX,[Y2]
    JBE  @@DontSwap1
    Mov  BX,[Y2]
    Mov  [Y1],BX
    Mov  [Y2],AX
    Mov  AX,[X1]
    Mov  BX,[X2]
    Mov  [X1],BX
    Mov  [X2],AX
  @@DontSwap1:
    Mov  [IncF],1
    Mov  AX,[X1]
    Cmp  AX,[X2]
    JBE  @@SkipNegate1
    Neg  [IncF]
  @@SkipNegate1:
    Mov  AX,[Y1]
    Mov  BX,320
    Mul  BX
    Mov  DI,AX
{    mov  di,ax
    shl  ax,8
    shl  di,6
    add  di,ax}
    Add  DI,[X1]        {Offset in DI}
    Mov  BX,[DeY]       {RefVar in BX}
    Mov  CX,BX
    Mov  AX,SEGM
    Mov  ES,AX          {Video segment}
    Mov  DL,[Color]
    Mov  SI,[DeX]
  @@DrawLoop1:
    Mov  ES:[DI],DL
    Add  DI,320
    Sub  BX,SI
    JNC  @@GoOn1
    Add  BX,[DeY]
    Add  DI,[IncF]
  @@GoOn1:
    Loop @@DrawLoop1
    Jmp  @@ExitLine

  @@OtherLine:
    Mov  AX,[X1]
    Cmp  AX,[X2]
    JBE  @@DontSwap2
    Mov  BX,[X2]
    Mov  [X1],BX
    Mov  [X2],AX
    Mov  AX,[Y1]
    Mov  BX,[Y2]
    Mov  [Y1],BX
    Mov  [Y2],AX
  @@DontSwap2:
    Mov  [IncF],320
    Mov  AX,[Y1]
    Cmp  AX,[Y2]
    JBE  @@SkipNegate2
    Neg  [IncF]
  @@SkipNegate2:
    Mov  AX,[Y1]
    Mov  BX,320
    Mul  BX
    Mov  DI,AX
{    mov  di,ax
    shl  ax,8
    shl  di,6
    add  di,ax}
    Add  DI,[X1]        {Offset in DI}
    Mov  BX,[DeX]       {RefVar in BX}
    Mov  CX,BX
    Mov  AX,SEGM
    Mov  ES,AX          {Video segment}
    Mov  DL,[Color]
    Mov  SI,[DeY]
  @@DrawLoop2:
    Mov  ES:[DI],DL
    Inc  DI
    Sub  BX,SI
    JNC  @@GoOn2
    Add  BX,[DeX]
    Add  DI,[IncF]
  @@GoOn2:
    Loop @@DrawLoop2

  @@ExitLine:
End;

{}
{Procedure Line(a,b,c,d:integer;col:byte;where:word);
  function sgn(a:real):integer;
  begin
       if a>0 then sgn:=+1;
       if a<0 then sgn:=-1;
       if a=0 then sgn:=0;
  end;
var i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
begin
     u:= c - a;
     v:= d - b;
     d1x:= SGN(u);
     d1y:= SGN(v);
     d2x:= SGN(u);
     d2y:= 0;
     m:= ABS(u);
     n := ABS(v);
     IF NOT (M>N) then
     BEGIN
          d2x := 0 ;
          d2y := SGN(v);
          m := ABS(v);
          n := ABS(u);
     END;
     s := m shr 1;
     FOR i := 0 TO m DO
     BEGIN
          putpixel(a,b,col,where);
          s := s + n;
          IF not (s<m) THEN
          BEGIN
               s := s - m;
               a:= a + d1x;
               b := b + d1y;
          END
          ELSE
          BEGIN
               a := a + d2x;
               b := b + d2y;
          END;
     end;
END;


{}
Procedure DrawPoly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;where:word);
  { This draw a polygon with 4 points at x1,y1 , x2,y2 , x3,y3 , x4,y4
    in color col }
var
  x:integer;
  mny,mxy:integer;
  mnx,mxx,yc:integer;
  mul1,div1,
  mul2,div2,
  mul3,div3,
  mul4,div4:integer;

begin
  mny:=y1; mxy:=y1;
  if y2<mny then mny:=y2;
  if y2>mxy then mxy:=y2;
  if y3<mny then mny:=y3;
  if y3>mxy then mxy:=y3;    { Choose the min y mny and max y mxy }
  if y4<mny then mny:=y4;
  if y4>mxy then mxy:=y4;

  if mny<0 then mny:=0;
  if mxy>199 then mxy:=199;
  if mny>199 then exit;
  if mxy<0 then exit;        { Verticle range checking }

  mul1:=x1-x4; div1:=y1-y4;
  mul2:=x2-x1; div2:=y2-y1;
  mul3:=x3-x2; div3:=y3-y2;
  mul4:=x4-x3; div4:=y4-y3;  { Constansts needed for intersection calc }

  for yc:=mny to mxy do
    begin
      mnx:=240;
      mxx:=-1;
      if (y4>=yc) or (y1>=yc) then
        if (y4<=yc) or (y1<=yc) then   { Check that yc is between y1 and y4 }
          if not(y4=y1) then
            begin
              x:=(yc-y4)*mul1 div div1+x4; { Point of intersection on x axis }
              if x<mnx then
                mnx:=x;
              if x>mxx then
                mxx:=x;       { Set point as start or end of horiz line }
            end;
      if (y1>=yc) or (y2>=yc) then
        if (y1<=yc) or (y2<=yc) then   { Check that yc is between y1 and y2 }
          if not(y1=y2) then
            begin
              x:=(yc-y1)*mul2 div div2+x1; { Point of intersection on x axis }
              if x<mnx then
                mnx:=x;
              if x>mxx then
                mxx:=x;       { Set point as start or end of horiz line }
            end;
      if (y2>=yc) or (y3>=yc) then
        if (y2<=yc) or (y3<=yc) then   { Check that yc is between y2 and y3 }
          if not(y2=y3) then
            begin
              x:=(yc-y2)*mul3 div div3+x2; { Point of intersection on x axis }
              if x<mnx then
                mnx:=x;
              if x>mxx then
                mxx:=x;       { Set point as start or end of horiz line }
            end;
      if (y3>=yc) or (y4>=yc) then
        if (y3<=yc) or (y4<=yc) then   { Check that yc is between y3 and y4 }
          if not(y3=y4) then
            begin
              x:=(yc-y3)*mul4 div div4+x3; { Point of intersection on x axis }
              if x<mnx then
                mnx:=x;
              if x>mxx then
                mxx:=x;       { Set point as start or end of horiz line }
            end;
      if mnx<0 then
        mnx:=0;
      if mxx>239 then
        mxx:=239;          { Range checking on horizontal line }
      if mnx<=mxx then
        hlinet2 (mnx,mxx,yc,color,where);   { Draw the horizontal line }
    end;
{  Line(x1,y1,x2,y2,30,where);
  Line(x2,y2,x3,y3,30,where);
  Line(x3,y3,x4,y4,30,where);
  Line(x4,y4,x1,y1,30,where);}
  end;

{}
Function rad (theta : real) : real;
  {  This calculates the degrees of an angle }
BEGIN
  rad := theta * pi / 180
END;

{}
Procedure Putpixel (X,Y : Integer; Col : Byte; where:word); assembler;
  { This puts a pixel on the screen by writing directly to memory. }
Asm
  mov     ax,[where]
  mov     es,ax
  mov     bx,[X]
  mov     dx,[Y]
  mov     di,bx
  mov     bx, dx                  {; bx = dx}
  shl     dx, 8
  shl     bx, 4
  sub     dx, bx                  {; dx = dx + bx (ie y*320)}
  add     di, dx                  {; finalise location}
  mov     al, [Col]
  stosb
End;

{}
Function Getpixel (X,Y : Integer; where:word):byte; assembler;
Asm
  mov     ax,[where]
  mov     es,ax
  mov     bx,[X]
  mov     dx,[Y]
  mov     di,bx
  mov     bx, dx                  {; bx = dx}
  shl     dx, 8
  shl     bx, 6
  add     dx, bx                  {; dx = dx + bx (ie y*320)}
  add     di, dx                  {; finalise location}
  mov     al, es:[di]
End;

{}
procedure Ellipse(Y,X,XRad,YRad: integer; Color: byte; Fill:Boolean;Seg:WORD);
{Note here that X stands for Y and viceversa. Blame the original author. }
var
 EX,EY: integer;
 YRadSqr,YRadSqr2,XRadSqr,XRadSqr2,D,DX,DY: longint;
begin
 EX:=0;
 EY:=XRad;
 YRadSqr:=longint(YRad)*YRad;
 YRadSqr2:=2*YRadSqr;
 XRadSqr:=longInt(XRad)*XRad;
 XRadSqr2:=2*XRadSqr;
 D:=XRadSqr-YRadSqr*XRad+YRadSqr div 4;
 DX:=0;
 DY:=YRadSqr2*XRad;
 PutPixel(Y-EY,X,Color,Seg);
 PutPixel(Y+EY,X,Color,Seg);
if Fill then HLine(Y-EY,Y+EY,X,Color,Seg);

 PutPixel(Y,X-YRad,Color,Seg);
 PutPixel(Y,X+YRad,Color,Seg);
 while (DX<DY) do begin
  if (D>0) then begin
   Dec(EY);
   Dec(DY,YRadSqr2);
   Dec(D,DY);
  end;
  Inc(EX);
  Inc(DX,XRadSqr2);
  Inc(D,XRadSqr+DX);
  PutPixel(Y+EY,X+EX,Color,Seg);
  PutPixel(Y-EY,X+EX,Color,Seg);
if Fill then HLine(Y-EY,Y+EY,X+EX,Color,Seg);
  PutPixel(Y+EY,X-EX,Color,Seg);
  PutPixel(Y-EY,X-EX,Color,Seg);
if Fill then HLine(Y-EY,Y+EY,X-EX,Color,Seg);
 end;
 Inc(D,(3*(YRadSqr-XRadSqr) div 2-(DX+DY)) div 2);
 while (EY>0) do begin
  if(D<0) then begin
   Inc(EX);
   Inc(DX,XRadSqr2);
   Inc(D,XRadSqr+DX);
  end;
  Dec(EY);
  Dec(DY,YRadSqr2);
  Inc(D,YRadSqr-DY);
  PutPixel(Y+EY,X+EX,Color,Seg);
  PutPixel(Y-EY,X+EX,Color,Seg);
if Fill then HLine(Y-EY,Y+EY,X+EX,Color,Seg);
  PutPixel(Y+EY,X-EX,Color,Seg);
  PutPixel(Y-EY,X-EX,Color,Seg);
if Fill then HLine(Y-EY,Y+EY,X-EX,Color,Seg);
 end;
end;

{}
Procedure drawsprite(vseg : word; x,y : integer; w,h : byte; sprite : pointer;c:byte); assembler;
asm
  push ds
  lds si,[sprite]
  mov es,vseg
  cld
  mov ax,[y]
  shl ax,6
  mov di,ax
  shl ax,2
  add di,ax
  add di,[x]
  mov bh,[h]
  mov cx,320
  sub cl,[w]
  sbb ch,0
 @l:
  mov bl,[w]
 @l2:
  lodsb
  or al,al
  jz @s
  add al,[c]
  mov [es:di],al
 @s:
  inc di
  dec bl
  jnz @l2
  add di,cx
  dec bh
  jnz @l
  pop ds
end;

{}
Procedure FadeIn(PalPic : Pointer);
VAR loop1,loop2:integer;
    Tmp : Array [1..3] of byte;
BEGIN
  For loop1:=1 to 64 do BEGIN
    WaitRetrace;
    For loop2:=0 to 255 do BEGIN
      Getpal (loop2,Tmp[1],Tmp[2],Tmp[3]);
      If Tmp[1]<mem[seg(PalPic^):ofs(PalPic^)+Loop2*3+0] then inc (Tmp[1]);
      If Tmp[2]<mem[seg(PalPic^):ofs(PalPic^)+Loop2*3+1] then inc (Tmp[2]);
      If Tmp[3]<mem[seg(PalPic^):ofs(PalPic^)+Loop2*3+2] then inc (Tmp[3]);
      Pal (loop2,Tmp[1],Tmp[2],Tmp[3]);
    END;
  END;
END;

{}
Procedure FadeOut;
VAR loop1,loop2:integer;
    Tmp : Array [1..3] of byte;
BEGIN
  For loop1:=1 to 64 do BEGIN
    WaitRetrace;
    For loop2:=0 to 255 do BEGIN
      Getpal (loop2,Tmp[1],Tmp[2],Tmp[3]);
      If Tmp[1]>0 then dec (Tmp[1]);
      If Tmp[2]>0 then dec (Tmp[2]);
      If Tmp[3]>0 then dec (Tmp[3]);
      Pal (loop2,Tmp[1],Tmp[2],Tmp[3]);
    END;
  END;
END;

{}

BEGIN
END.
