;               6502 Source to the replay routine phor NEDs
;
;                 WARNING!!!!!!!!! THIS IS CRAP!!!!!!!!
;

;
; Short description oph the NED phormat...
;

; Phormat oph 8-byte header
;
; ID_String     .byte   78, 69, 68      ("NED")
; Version       .byte   $10             (Current is 1.0)
; Init_Speed    .byte   $06             (Initial speed oph tune)
; Inst_Tot      .byte   $00             (number oph instruments in phile)
; Pat_Tot       .byte   $00             (number oph pattern in phile)
; Order_Tot     .byte   $00             (number oph order positions in phile)


;
; Then come the instruments
; 
; Control_reg1  .byte   $00     (the 1st control reg oph the channel, as
;                                dephined in NESTECH.DOC)
; Control_reg2  .byte   $00     (the 2nd control reg oph the channel, as
;                                dephined in NESTECH.DOC)
; Control_reg4  .byte   $00     (the 4th control reg oph the channel)
;                                 (>>EXCLUDING THE PERIOD VALUE!<<)

;
; Then, the order list with one byte phor each order position
;

;
; And phinally, the relative positions oph the patterns (counted phrom
; the beginning oph the phile, oph course). One word phor each oph them.
;



; Start oph listing...

NED_OrderTot    = $00          ; # oph entries in order list (Byte)
NED_InstTot     = $01          ; # oph instruments (Byte)
NED_PatTot      = $02          ; # oph patterns (Byte)
NED_Speed       = $03          ; Current speed (Byte)
NED_NedAddr     = $04          ; Address oph NED phile (Word)
NED_CurrTick    = $06          ; Current tick (Byte)

NED_OrderAddr   = $08          ; Address oph order list
NED_PatListAddr = $0A          ; Address oph pattern ophphset table
NED_CurrPatAddr = $0C          ; Address oph current line in current pattern

NED_CurrPat     = $0E          ; Current pattern
NED_CurrRow     = $0F          ; Current line
NED_OrderPos    = $10          ; Current position in order list


NED_CurrChn     = $12
NED_CurrRegI    = $13

NED_ChnCreg1   = $14
NED_ChnCreg2   = $18
NED_ChnCreg3   = $1C
NED_ChnCreg4   = $20

NED_CurrYval    = $28
NED_BigTick     = $29
NED_ChnPortaNote= $2C
NED_ChnPortaSpd = $30

NED_Temp3       = $40
NED_Temp4       = $41
NED_Temp5       = $42
NED_Temp6       = $43
NED_Temp7       = $44

NED_QkTal       = $45

NED_ArpAdd      = $46

NED_CurrNote    = $48
NED_CurrInst    = $49
NED_CurrEph     = $4A
NED_CurrEparm   = $4B

NED_ChnLastInst = $4C
NED_ChnVol      = $50
NED_ChnPeriodLo = $54
NED_ChnPeriodHi = $58
NED_ChnLastNote = $5C
NED_ChnPdAlt    = $60

NED_Temp1       = $68
NED_Temp2       = $69


NED_EphModVol   = $10
NED_EphSetSpeed = $20
NED_EphBrkPat   = $30
NED_EphPortaUp  = $40
NED_EphPortaDown= $50
NED_EphP2Note   = $60
NED_EphArpeggio = $70

NED_SONG        = $8576
NED_PHQLIMIT    = $0A


* = $8002

                LDX     #$FF
                TXS
                JSR     NED_LOAD_NED
                LDA     #$90
                STA     $2000
                LDA     #$0F
                STA     $4015


INPHLOOP        JMP     INPHLOOP
                
                
VBLANK_INT      PHA
                TXA
                PHA
                TYA
                PHA

                JSR     NED_PlayNed

                PLA
                TAY
                PLA
                TAX
                PLA
                RTI
                




NED_LOAD_NED    LDA     #<NED_SONG  ; Save the modules address
                STA     NED_NedAddr
                LDA     #>NED_SONG
                STA     NED_NedAddr+1

                LDY     #0
        
                LDA     #"N"             ; 1st, check iph it's a valid NED phile
                CMP     (NED_NedAddr), Y
                BNE     NED_ErrIsNotNed
                INY
                LDA     #"E"
                CMP     (NED_NedAddr), Y
                BNE     NED_ErrIsNotNed
                INY
                LDA     #"D"
                CMP     (NED_NedAddr), Y
                BNE     NED_ErrIsNotNed
                JMP     Ok

NED_ErrIsNotNed JMP     NED_IsNotNed

Ok              INY
                INY
                LDA     (NED_NedAddr), Y
                STA     NED_Speed
                INY
                LDA     (NED_NedAddr), Y
                STA     NED_InstTot
                INY
                LDA     (NED_NedAddr), Y
                ;STA     OrderTot
                sta     NED_PatTot          ; M A J O R   B U G ! ! !
                INY
                LDA     (NED_NedAddr), Y
                ;STA     PatTot
                sta     NED_OrderTot
                INY

                LDA     #0              ; Loop through instruments
                CMP     NED_InstTot
                BEQ     NED_EndInstLoop
                LDX     NED_InstTot
NED_InstLoop    INY
                INY
                INY
                DEX
                BNE     NED_InstLoop
NED_EndInstLoop CLC
                TYA
                ADC     NED_NedAddr
                STA     NED_OrderAddr
                LDA     #0
                ADC     NED_NedAddr+1
                STA     NED_OrderAddr+1
        
                CLC
                LDA     NED_OrderAddr
                ADC     NED_OrderTot
                STA     NED_PatListAddr
                LDA     #0
                ADC     NED_OrderAddr+1
                STA     NED_PatListAddr+1

                LDA     #0
                STA     NED_CurrPat
                STA     NED_CurrRow
                STA     NED_OrderPos
                STA     NED_CurrTick
                STA     NED_BigTick
                STA     NED_BigTick+1
        
                LDY     #0
                LDA     (NED_OrderAddr), Y
                ASL     A
                TAY
                CLC
                LDA     (NED_PatListAddr), Y
                ADC     NED_NedAddr
                STA     NED_CurrPatAddr
                INY
                LDA     (NED_PatListAddr), Y
                ADC     NED_NedAddr+1
                STA     NED_CurrPatAddr+1
        
                RTS
        
NED_IsNotNed    SEI
                JMP     NED_IsNotNed
        


;
;       The player routine to be called 50 times/sec
;

NED_PlayNed     LDA     #0
                STA     NED_CurrChn
                STA     NED_CurrRegI
                STA     NED_CurrYval
                
                STA     NED_ChnPdAlt
                STA     NED_ChnPdAlt+1
                STA     NED_ChnPdAlt+2
                STA     NED_ChnPdAlt+3
                         
                INC     NED_CurrTick            ; iph CurrTick >= Speed then
                LDA     NED_CurrTick            ; CurrTick = 0
                CMP     NED_Speed
                ;BMI     NED_DontUpdRow
                BNE     NED_DontUpdRow

                        ;JSR     NED_UpdateRow

                        LDA     #0
                        STA     NED_CurrTick

                        
                        LDA     NED_CurrRow
                        CMP     #$40
                        Bne     NED_NoIncOrder
                        ;JMP     NED_NoIncOrder
                                LDA     #0
                                STA     NED_CurrRow
                                INC     NED_OrderPos
                                LDA     NED_OrderPos
                                CMP     NED_OrderTot    ; BCC = JB
                                BCC     NED_NoRestart   ; BCS = JAE
                                        LDA     #0
                NED_NoRestart   STA     NED_OrderPos
        NED_NoIncOrder  JSR     NED_UpdateRow   ; ***
                        INC     NED_CurrRow
                        JMP     NED_PlayNedEnd
                        
NED_DontUpdRow  LDA     NED_CurrPatAddr
                SEC
                SBC     #12
                STA     NED_CurrPatAddr
                LDA     NED_CurrPatAddr+1
                SBC     #0
                STA     NED_CurrPatAddr+1

                LDA     #0
                STA     NED_CurrChn

NED_UpdEphLoop  LDY     #1
                LDA     (NED_CurrPatAddr), Y
                AND     #$E0
                LSR
                INY
                PHA
                LDA     (NED_CurrPatAddr), Y
                TAX
                PLA
                JSR     NED_DoEphsTx        ; Update tick based ephphects
                
                CLC
                LDA     NED_CurrPatAddr         ; Increment pattern pointer
                ADC     #3
                STA     NED_CurrPatAddr
                LDA     NED_CurrPatAddr+1
                ADC     #0
                STA     NED_CurrPatAddr+1
                
                INC     NED_CurrChn
                LDA     NED_CurrChn
                CMP     #4
                BNE     NED_UpdEphLoop
                

;       Process channels

NED_PlayNedEnd  LDA     #0
                STA     NED_CurrChn

NED_ProcessLoop LDX     NED_CurrChn
                TXA
                ASL
                ASL
                TAY

                LDA     NED_ChnVol, X   ; iph(Vol<0) vol = 0
                BPL     NED_NoVolUPhlow
                LDA     #0

NED_NoVolUPhlow CMP     #$3F            ; iph(Vol>63) vol = 63
                BMI     NED_NoVolOPhlow
                LDA     #$3F
NED_NoVolOPhlow STA     NED_ChnVol, X
                
                LSR
                LSR
                ORA     NED_ChnCreg1, X
                STA     $4000, Y

                LDA     NED_ChnCreg2, X
                STA     $4001, Y

                LDA     NED_ChnPdAlt, X
                BEQ     NED_NoSetPeriod



                LDA     NED_ChnPeriodHi, X
                BPL     NED_PdNoUph
                LDA     #0
                STA     NED_ChnPeriodHi, X
                LDA     #NED_PHQLIMIT
                STA     NED_ChnPeriodLo, X
NED_PdNoUPh     LDA     NED_ChnPeriodHi, X
                AND     #$FC
                BEQ     NED_PdNoOPh
                LDA     #7
                STA     NED_ChnPeriodHi, X
                LDA     #$FF
                STA     NED_ChnPeriodLo, X

NED_PdNoOPh     LDA     NED_ChnPeriodLo, X
                STA     $4002, Y
                LDA     NED_ChnPeriodHi, X
                ORA     NED_ChnCreg4, X
                STA     $4003, Y

NED_NoSetPeriod INC     NED_CurrChn
                LDA     NED_CurrChn
                CMP     #4
                BNE     NED_ProcessLoop
                
                RTS



NED_UpdateRow   JSR     NED_CalcPatAddr

                LDA     #0
                STA     NED_CurrChn

NED_ChnLoop     LDY     #0
                LDA     (NED_CurrPatAddr), Y    ; Get NOTE
                STA     NED_CurrNote

                INY
                LDA     (NED_CurrPatAddr), Y    ; Get INST
                TAX
                AND     #$1F
                STA     NED_CurrInst
                DEC     NED_CurrInst

                TXA                             ; Get EPHPHECT
                AND     #$E0
                LSR
                STA     NED_CurrEph

                INY
                LDA     (NED_CurrPatAddr), Y    ; Get EPHPHECT_PARAMETER
                STA     NED_CurrEparm

                LDA     NED_CurrNote
                BEQ     NED_NoNote
                        LDX     NED_CurrChn     ; LastInst[Chn] = CurrInst

                        STA     NED_ChnLastNote, X
                        LDA     NED_CurrInst
                        STA     NED_ChnLastInst, X

                        STA     NED_Temp1       ; Volume[Chn] = CurrVol
                        ASL
                        CLC
                        ADC     NED_Temp1
                        ADC     #8
                        TAY
                        LDA     (NED_NedAddr), Y
                        AND     #$0F
                        ASL
                        ASL
                        STA     NED_ChnVol, X

                        LDA     (NED_NedAddr), Y        ; Phix up instruments
                        AND     #$F0
                        STA     NED_ChnCreg1, X
                        INY
                        LDA     (NED_NedAddr), Y
                        STA     NED_ChnCreg2, X
                        INY
                        LDA     (NED_NedAddr), Y
                        STA     NED_ChnCreg4, X



                        LDA     NED_CurrEph
                        CMP     #NED_EphP2Note
                        BEQ     NED_NoStorePd

                        LDX     NED_CurrNote
                        DEX
                        TXA
                        JSR     NED_GetPeriod

                        LDY     NED_CurrChn
                        STA     NED_ChnPeriodLo, Y
                        TXA
                        STA     NED_ChnPeriodHi, Y

                        LDA     #1
                        STA     NED_ChnPdAlt, Y
        NED_NoStorePd   NOP

NED_NoNote      LDA     NED_CurrEph
                BEQ     NED_SkipEph

                LDX     NED_CurrEparm
                JSR     NED_DoEphsT0

NED_SkipEph     nop


                CLC
                LDA     NED_CurrPatAddr         ; Increment pattern pointer
                ADC     #3
                STA     NED_CurrPatAddr
                LDA     NED_CurrPatAddr+1
                ADC     #0
                STA     NED_CurrPatAddr+1

                LDX     NED_CurrChn
                INX
                STX     NED_CurrChn
                CPX     #4
                BEQ     NED_EndChnLoop
                JMP     NED_ChnLoop

NED_EndChnLoop  RTS






;
;       Calcs pattern address based on the values oph OrderPos & CurrRow
;

NED_CalcPatAddr LDY     NED_OrderPos
                LDA     (NED_OrderAddr), Y
                ASL
                TAY
                LDA     (NED_PatListAddr), Y
                CLC
                ADC     NED_NedAddr
                STA     NED_CurrPatAddr
                INY
                LDA     (NED_PatListAddr), Y
                ADC     NED_NedAddr+1
                STA     NED_CurrPatAddr+1

                LDA     #0
                STA     NED_Temp1
                LDA     NED_CurrRow
                ASL
                ASL
                ASL
                ROL     NED_Temp1
                
                ADC     NED_CurrPatAddr
                STA     NED_CurrPatAddr
                LDA     NED_CurrPatAddr+1
                ADC     NED_Temp1
                STA     NED_CurrPatAddr+1

                LDA     NED_CurrRow
                ASL
                ASL
                ADC     NED_CurrPatAddr
                STA     NED_CurrPatAddr
                LDA     NED_CurrPatAddr+1
                ADC     #0
                STA     NED_CurrPatAddr+1

                RTS
                
;
;       IN: A = Note
;
;       OUT: AX = Period value
;

NED_GetPeriod   ASL
                TAY
                LDA     NED_PeriodTab, Y
                INY
                LDX     NED_PeriodTab, Y
                RTS

;
;       Called to process tick 0 ephphects
;

NED_DoEphsT0    CMP     #NED_EphSetSpeed
                BEQ     NED_DoSetSpeed
                CMP     #NED_EphBrkPat
                BEQ     NED_DoBrkPat
                CMP     #NED_EphP2Note
                BEQ     NED_DoP2NoteT0
                CMP     #NED_EphModVol
                BEQ     NED_DoModVolT0
                RTS

NED_DoSetSpeed  STX     NED_Speed
                RTS

NED_DoBrkPat    dex
                STX     NED_CurrRow
                LDX     NED_OrderPos
                INX
                CPX     NED_OrderTot
                BNE     NED_BPNoRestart
                LDX     #0
NED_BPNoRestart STX     NED_OrderPos
                RTS

NED_DoP2NoteT0  TXA
                LDX     NED_CurrChn
                CMP     #0
                BEQ     NED_P2NNoSpeed
                STA     NED_ChnPortaSpd, X
NED_P2NNoSpeed  LDA     NED_CurrNote
                BEQ     NED_P2NNoNote
                STA     NED_ChnPortaNote, X
NED_P2NNoNote   RTS

NED_DoModVolT0  TXA             ; Check iph it's the SetVol cmd
                AND     #$F0
                CMP     #$00
                BEQ     NED_DoSetVol
                RTS

NED_DoSetVol    TXA
                ASL
                ASL
                LDX     NED_CurrChn
                STA     NED_ChnVol, X
                RTS

;
;       Called to process tick-based ephphects
;

NED_DoEphsTx    STX     NED_Temp1
                CMP     #NED_EphModVol
                BEQ     NED_DoModVolTx
                CMP     #NED_EphPortaUp
                BEQ     NED_DoPortaUp
                CMP     #NED_EphPortaDown
                BEQ     NED_DoPortaDown
                JMP     NED_ETxContinue


NED_DoModVolTx  TXA             ; Modiphy volume cmd
                AND     #$F0
                CMP     #$10
                BEQ     NED_DoSlideUp
                CMP     #$20
                BEQ     NED_DoSlideDown
                RTS


NED_DoSlideUp   TXA
                AND     #$0F
                STA     NED_Temp1
                LDX     NED_CurrChn
                LDA     NED_ChnVol, X
                CLC
                ADC     NED_Temp1
                STA     NED_ChnVol, X
                RTS

NED_DoSlideDown TXA
                AND     #$0F
                STA     NED_Temp1
                LDX     NED_CurrChn
                LDA     NED_ChnVol, X
                SEC
                SBC     NED_Temp1
                STA     NED_ChnVol, X
                RTS

NED_DoPortaUp   STX     NED_Temp1
                LDX     NED_CurrChn
                LDA     NED_ChnPeriodLo, X
                SEC
                SBC     NED_Temp1
                STA     NED_ChnPeriodLo, X
                LDA     NED_ChnPeriodHi, X
                SBC     #0
                STA     NED_ChnPeriodHi, X
                LDA     #1
                STA     NED_ChnPdAlt, X
                RTS

NED_DoPortaDown STX     NED_Temp1
                LDX     NED_CurrChn
                LDA     NED_ChnPeriodLo, X
                CLC
                ADC     NED_Temp1
                STA     NED_ChnPeriodLo, X
                LDA     NED_ChnPeriodHi, X
                ADC     #0
                STA     NED_ChnPeriodHi, X
                LDA     #1
                STA     NED_ChnPdAlt, X
                RTS


NED_ETxContinue CMP     #NED_EphP2Note
                BEQ     NED_DoP2NoteApa
                CMP     #NED_EphArpeggio
                BEQ     NED_DoArpeggio
                RTS

NED_DoP2NoteApa JMP     NED_DoP2Note

NED_DoArpeggio  STX     NED_Temp1
                LDX     NED_CurrChn
                LDA     NED_CurrTick
NED_DoArpLoop   CMP     #0
                BEQ     NED_DoArpeggio0
                CMP     #1
                BEQ     NED_DoArpeggioX
                CMP     #2
                BEQ     NED_DoArpeggioY
                SEC
                SBC     #3
                JMP     NED_DoArpLoop

NED_DoArpeggio0 LDA     #1
                STA     NED_ChnPdAlt, X
                LDA     NED_ChnLastNote, X
                TAY
                DEY
                TYA
                JSR     NED_GetPeriod
                PHA ;N
                TXA
                LDX     NED_CurrChn
                STA     NED_ChnPeriodHi, X
                PLA
                STA     NED_ChnPeriodLo, X
                RTS

NED_DoArpeggioX LDA     #1
                STA     NED_ChnPdAlt, X
                LDA     #$F0
                AND     NED_Temp1
                LSR
                LSR
                LSR
                LSR
                STA     NED_Temp1
                LDA     NED_ChnLastNote, X
                CLC
                DEC     NED_Temp1
                ADC     NED_Temp1
                JSR     NED_GetPeriod
                PHA ;N, PHAN, PHAN!
                TXA
                LDX     NED_CurrChn
                STA     NED_ChnPeriodHi, X
                PLA
                STA     NED_ChnPeriodLo, X
                RTS

NED_DoArpeggioY LDA     #1
                STA     NED_ChnPdAlt, X
                LDA     #$0F
                AND     NED_Temp1
                STA     NED_Temp1
                LDA     NED_ChnLastNote, X
                CLC
                DEC     NED_Temp1
                ADC     NED_Temp1
                JSR     NED_GetPeriod
                PHA ;N I HELVETE!!!!
                TXA
                LDX     NED_CurrChn
                STA     NED_ChnPeriodHi, X
                PLA
                STA     NED_ChnPeriodLo, X
                RTS

NED_DoP2Note    LDX     NED_CurrChn
                LDA     #1
                STA     NED_ChnPdAlt, X
                LDA     NED_ChnPortaNote, X
                JSR     NED_GetPeriod
                STA     NED_Temp1
                STX     NED_Temp2

                LDA     NED_ChnPeriodLo, X ; iph(Period<NotePeriod) GoUp
                SEC
                SBC     NED_Temp1
                LDA     NED_ChnPeriodHi, X
                SBC     NED_Temp2
                BMI     NED_DoP2NGoUp
                ;JMP     NED_DoP2NGoDown

NED_DoP2NGoDown LDA     NED_ChnPeriodLo, X
                SEC
                SBC     NED_ChnPortaSpd, X
                STA     NED_ChnPeriodLo, X
                LDA     NED_ChnPeriodHi, X
                SBC     #0
                STA     NED_ChnPeriodHi, X

                ; iph(Period<NotePeriod) SetPeriod(PortaNote)
                LDA     NED_ChnPeriodLo, X
                SEC
                SBC     NED_Temp1
                LDA     NED_ChnPeriodHi, X
                SBC     NED_Temp2

                BPL     NED_P2NNotBelow
                LDA     NED_Temp1
                STA     NED_ChnPeriodLo, X
                LDA     NED_Temp2
                STA     NED_ChnPeriodHi, X
NED_P2NNotBelow RTS


NED_DoP2NGoUp   LDA     NED_ChnPeriodLo, X
                CLC
                ADC     NED_ChnPortaSpd, X
                STA     NED_ChnPeriodLo, X
                LDA     NED_ChnPeriodHi, X
                ADC     #0
                STA     NED_ChnPeriodHi, X

                ; iph(Period>NotePeriod) SetPeriod(PortaNote)
                LDA     NED_ChnPeriodLo, X
                SEC
                SBC     NED_Temp1
                LDA     NED_ChnPeriodHi, X
                SBC     NED_Temp2

                BMI     NED_P2NNotAbove
                LDA     NED_Temp1
                STA     NED_ChnPeriodLo, X
                LDA     NED_Temp2
                STA     NED_ChnPeriodHi, X
NED_P2NNotAbove RTS


NED_PeriodTab .word 1614, 1523, 1438, 1357, 1281, 1209, 1141, 1077, 1016, 959, 905, 855
.word 807, 761, 719, 678, 640, 604, 570, 538, 508, 479, 452, 427
.word 403, 380, 359, 339, 320, 302, 285, 269, 254, 239, 226, 213 
.word 201, 190, 179, 169, 160, 151, 142, 134, 127, 119, 113, 106 
.word 100, 95, 89, 84, 80, 75, 71, 67, 63, 59, 56, 53
.word 50, 47, 44, 42, 40, 37, 35, 33, 31, 29, 28, 26 
.word 25, 23, 22, 21, 20, 18, 17, 16, 15, 14, 14, 13 
.word 12, 11, 11, 10, 10, 9, 8, 8, 7, 7, 7, 6


.END
