.286
.model huge
.code

;
include lens.inc
SourceBuffer    db  LensDiameter*LensDiameter dup(?)
TargetBuffer    db  LensDiameter*LensDiameter dup(?)

PUBLIC          _fetchbuffer
; PUBLIC          _morphbuffer
; PUBLIC          _displaynewbuffer
PUBLIC          _restorebuffer


;

        ;read in the portion of the screen we're going to work on
        ;call FetchBuffer
        ;put it under the lens
        ;call MorphBuffer
        ;display the new buffer
        ;call DisplayNewBuffer
        ;read in the mouse position, if it's changed, then reupdate
        ;restore what was originally on the screen
        ;call RestoreBuffer

;
;read in the portion of the screen that we're working on into a buffer
_fetchbuffer PROC
ARG PositionX:word,PositionY:word
	push ds
	push es
        mov ax,0A000h
        mov ds,ax
        push cs
        pop es
        mov si,[cs:PositionY]
        mov ax,320
        mul si
        mov si,ax
        add si,[cs:PositionX]
        mov di,offset SourceBuffer
        mov cx,LensDiameter
@@CopyRow:
        push si cx
        mov cx,LensDiameter
        cld
        rep movsb
        pop cx si
        add si,320
        dec cx
        jnz @@CopyRow
	pop es
        pop ds
;        RET
;ENDP    _fetchbuffer
;
;put the portion of the screen that we've captured under the lens
; proc    _morphbuffer
	push ds
	push es
        mov ax,cs
        mov ds,ax
        mov es,ax
        mov si,offset Lens
        mov di,offset TargetBuffer
        mov cx,LensDiameter*LensDiameter
        cld
        xor bh,bh
@@DoPoint:
        lodsw
        mov bx,ax
        mov al,byte ptr [offset SourceBuffer+bx]
        stosb
        inc dx
        dec cx
        jnz @@DoPoint
	pop es
	pop ds

;         ret
; endp    _morphbuffer
;
;display the new calculated buffer
; proc    _displaynewbuffer
; ARG PositionX:word,PositionY:word
        push ds
	push es
        mov ax,0A000h
        mov es,ax
        push cs
        pop ds
        mov di,[cs:PositionY]
        mov ax,320
        mul di
        mov di,ax
        add di,[cs:PositionX]
        mov si,offset TargetBuffer
        mov cx,LensDiameter
@@CopyRow2:
        push di cx
        mov cx,LensDiameter
        cld
        rep movsb
        pop cx di
        add di,320
        dec cx
        jnz @@CopyRow2
	pop es
	pop ds

        RET
; endp    _displaynewbuffer
ENDP     _fetchbuffer
;
;restore the unmagnified portion of the image on screen
_restorebuffer PROC
ARG PositionX:word,PositionY:word
        push ds
        push es
        mov ax,0A000h
        mov es,ax
        push cs
        pop ds
        mov di,[cs:PositionY]
        mov ax,320
        mul di
        mov di,ax
        add di,[cs:PositionX]
        mov si,offset SourceBuffer
        mov cx,LensDiameter
@@CopyRow3:
        push di cx
        mov cx,LensDiameter
        cld
        rep movsb
        pop cx di
        add di,320
        dec cx
        jnz @@CopyRow3
	push es
	push ds
        ret
endp    _restorebuffer

;
        
ENDS

END